/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security;

import java.io.Serializable;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.security.Identity;

public class IdentityRegistry {
    private static final String CACHE_NAME = "portal.IdentityRegistry";
    private final ExoCache<String, Identity> identitiesCache;

    public IdentityRegistry(CacheService cacheService) {
        this.identitiesCache = cacheService.getCacheInstance(CACHE_NAME);
    }

    public Identity getIdentity(String userId) {
        return (Identity)this.identitiesCache.get((Serializable)((Object)userId));
    }

    public void register(Identity identity) {
        this.identitiesCache.put((Serializable)((Object)identity.getUserId()), (Object)identity);
    }

    public void unregister(String userId) {
        this.identitiesCache.remove((Serializable)((Object)userId));
    }

    void clear() {
        this.identitiesCache.clearCache();
    }
}

