/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.LowercaseTokenFilterLanguages;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class LowercaseTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    @Nullable
    private final LowercaseTokenFilterLanguages language;
    public static final JsonpDeserializer<LowercaseTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, LowercaseTokenFilter::setupLowercaseTokenFilterDeserializer);

    private LowercaseTokenFilter(Builder builder) {
        super(builder);
        this.language = builder.language;
    }

    public static LowercaseTokenFilter of(Function<Builder, ObjectBuilder<LowercaseTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.Lowercase;
    }

    @Nullable
    public final LowercaseTokenFilterLanguages language() {
        return this.language;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "lowercase");
        super.serializeInternal(generator, mapper);
        if (this.language != null) {
            generator.writeKey("language");
            this.language.serialize(generator, mapper);
        }
    }

    protected static void setupLowercaseTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::language, LowercaseTokenFilterLanguages._DESERIALIZER, "language");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<LowercaseTokenFilter> {
        @Nullable
        private LowercaseTokenFilterLanguages language;

        public final Builder language(@Nullable LowercaseTokenFilterLanguages value) {
            this.language = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public LowercaseTokenFilter build() {
            this._checkSingleUse();
            return new LowercaseTokenFilter(this);
        }
    }
}

