/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.plugin;

import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import io.meeds.layout.model.PortletInstance;
import io.meeds.layout.model.PortletInstanceContext;
import io.meeds.layout.model.PortletInstanceDatabind;
import io.meeds.layout.model.PortletInstancePreference;
import io.meeds.layout.plugin.PortletInstanceDatabindPlugin$AjcClosure1;
import io.meeds.layout.service.PortletInstanceService;
import io.meeds.layout.util.JsonUtils;
import io.meeds.social.databind.model.DatabindReport;
import io.meeds.social.databind.plugin.DatabindPlugin;
import io.meeds.social.databind.service.DatabindService;
import io.meeds.social.translation.model.TranslationField;
import io.meeds.social.translation.service.TranslationService;
import jakarta.annotation.PostConstruct;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.attachment.model.UploadedAttachmentDetail;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.upload.UploadResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class PortletInstanceDatabindPlugin
implements DatabindPlugin {
    private static final Random RANDOM;
    public static final String OBJECT_TYPE = "PortletInstance";
    private static final String PLATFORM_USERS_PERMISSION = "*:/platform/users";
    @Autowired
    private PortletInstanceService portletInstanceService;
    @Autowired
    private DatabindService databindService;
    @Autowired
    private FileService fileService;
    @Autowired
    private TranslationService translationService;
    @Autowired
    private AttachmentService attachmentService;
    @Autowired
    private UserACL userAcl;
    @Autowired
    private IdentityManager identityManager;
    private long superUserIdentityId;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @PostConstruct
    public void init() {
        this.databindService.addPlugin((DatabindPlugin)this);
    }

    public String getObjectType() {
        return OBJECT_TYPE;
    }

    public boolean canHandleDatabind(String objectType, String objectId) {
        return StringUtils.equals((CharSequence)OBJECT_TYPE, (CharSequence)objectType);
    }

    public void serialize(String objectId, ZipOutputStream zipOutputStream, String username) {
        FileItem file;
        TranslationField translationDescriptionField;
        PortletInstance portletInstance = this.portletInstanceService.getPortletInstance(Long.parseLong(objectId), username, Locale.getDefault(), true);
        PortletInstanceDatabind databind = new PortletInstanceDatabind();
        databind.setContentId(portletInstance.getContentId());
        TranslationField translationNameField = this.translationService.getTranslationField("portletInstance", Long.parseLong(objectId), "title", username);
        if (translationNameField != null) {
            Map<String, String> names = translationNameField.getLabels().entrySet().stream().collect(Collectors.toMap(entry -> ((Locale)entry.getKey()).toLanguageTag(), Map.Entry::getValue));
            databind.setNames(names);
        }
        if ((translationDescriptionField = this.translationService.getTranslationField("portletInstance", Long.parseLong(objectId), "description", username)) != null) {
            Map<String, String> descriptions = translationDescriptionField.getLabels().entrySet().stream().collect(Collectors.toMap(entry -> ((Locale)entry.getKey()).toLanguageTag(), Map.Entry::getValue));
            databind.setDescriptions(descriptions);
        }
        if ((file = this.fileService.getFile(portletInstance.getIllustrationId())) != null) {
            databind.setIllustration(Base64.encodeBase64String((byte[])file.getAsByte()));
        }
        databind.setPreferences(this.portletInstanceService.getPortletInstancePreferences(Long.parseLong(objectId), new PortletInstanceContext(true, new HashMap<String, String>()), username));
        String jsonData = JsonUtils.toJsonString(databind);
        this.writeContent(zipOutputStream, objectId, jsonData);
    }

    public CompletableFuture<Pair<DatabindReport, File>> deserialize(File zipFile, Map<String, String> params, String username) {
        String categoryId = params.get("categoryId");
        if (categoryId != null) {
            return CompletableFuture.supplyAsync(() -> this.importPortletInstances(zipFile, Long.parseLong(categoryId))).thenApply(processedTemplates -> {
                DatabindReport report = new DatabindReport();
                report.setSuccess(!processedTemplates.isEmpty());
                report.setProcessedItems(processedTemplates);
                return Pair.of((Object)report, (Object)zipFile);
            });
        }
        return CompletableFuture.completedFuture(null);
    }

    @ContainerTransactional
    public List<String> importPortletInstances(File zipFile, long categoryId) {
        File file = zipFile;
        long l = categoryId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)file, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, file, Conversions.longObject((long)l), joinPoint};
        PortletInstanceDatabindPlugin$AjcClosure1 portletInstanceDatabindPlugin$AjcClosure1 = new PortletInstanceDatabindPlugin$AjcClosure1(objectArray);
        return (List)ContainerTransactionalAspect.aspectOf().around(portletInstanceDatabindPlugin$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private void writeContent(ZipOutputStream zipOutputStream, String objectId, String content) throws IOException {
        ZipEntry entry = new ZipEntry(String.format("%s_%s.json", OBJECT_TYPE, objectId));
        zipOutputStream.putNextEntry(entry);
        zipOutputStream.write(content.getBytes(StandardCharsets.UTF_8));
        zipOutputStream.closeEntry();
    }

    private Map<String, PortletInstanceDatabind> extractInstances(File zipFile) {
        HashMap<String, PortletInstanceDatabind> instances = new HashMap<String, PortletInstanceDatabind>();
        try (ZipInputStream zis = new ZipInputStream((InputStream)new FileInputStream(zipFile), StandardCharsets.UTF_8);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                int bytesRead;
                if (entry.isDirectory() || !entry.getName().endsWith(".json")) continue;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((bytesRead = zis.read(buffer)) != -1) {
                    baos.write(buffer, 0, bytesRead);
                }
                String jsonContent = baos.toString(StandardCharsets.UTF_8);
                PortletInstanceDatabind instance = JsonUtils.fromJsonString(jsonContent, PortletInstanceDatabind.class);
                if (instance == null) continue;
                instances.put(entry.getName(), instance);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error reading zip file", e);
        }
        return instances;
    }

    private void processPortletInstance(PortletInstanceDatabind instance, long categoryId) {
        List<PortletInstancePreference> preferences;
        PortletInstance portletInstance = new PortletInstance();
        portletInstance.setName(instance.getNames().get("en"));
        portletInstance.setDescription(instance.getDescriptions().get("en"));
        portletInstance.setContentId(instance.getContentId());
        portletInstance.setCategoryId(categoryId);
        portletInstance.setPermissions(List.of(PLATFORM_USERS_PERMISSION));
        portletInstance.setSystem(false);
        portletInstance.setSupportedModes(List.of("view"));
        PortletInstance createdPortletInstance = this.portletInstanceService.createPortletInstance(portletInstance);
        this.saveNames(instance, createdPortletInstance);
        this.saveDescriptions(instance, createdPortletInstance);
        if (instance.getIllustration() != null) {
            this.saveIllustration(createdPortletInstance.getId(), Base64.decodeBase64((String)instance.getIllustration()));
        }
        if ((preferences = instance.getPreferences()) != null) {
            preferences.add(new PortletInstancePreference("portletInstanceId", String.valueOf(createdPortletInstance.getId())));
        } else {
            preferences = Collections.singletonList(new PortletInstancePreference("portletInstanceId", String.valueOf(createdPortletInstance.getId())));
        }
        createdPortletInstance.setPreferences(preferences);
        this.portletInstanceService.updatePortletInstance(createdPortletInstance);
    }

    private void saveIllustration(long portletInstanceId, byte[] illustrationBytes) {
        File tempFile = null;
        try {
            tempFile = this.getIllustrationFile(illustrationBytes);
            String uploadId = "PortletInstanceIllustration" + RANDOM.nextLong();
            UploadResource uploadResource = new UploadResource(uploadId);
            uploadResource.setFileName(tempFile.getName());
            uploadResource.setMimeType("image/png");
            uploadResource.setStatus(1);
            uploadResource.setStoreLocation(tempFile.getPath());
            this.attachmentService.deleteAttachments("portletInstance", String.valueOf(portletInstanceId));
            UploadedAttachmentDetail uploadedAttachmentDetail = new UploadedAttachmentDetail(uploadResource);
            this.attachmentService.saveAttachment(uploadedAttachmentDetail, "portletInstance", String.valueOf(portletInstanceId), null, this.getSuperUserIdentityId());
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Error while saving illustration as attachment for portlet instance '%s'", portletInstanceId), e);
        }
        finally {
            if (tempFile != null) {
                try {
                    Files.delete(tempFile.toPath());
                }
                catch (IOException e) {
                    tempFile.deleteOnExit();
                }
            }
        }
    }

    private void saveNames(PortletInstanceDatabind portletInstanceDatabind, PortletInstance portletInstance) {
        this.translationService.saveTranslationLabels("portletInstance", portletInstance.getId(), "title", portletInstanceDatabind.getNames().entrySet().stream().collect(Collectors.toMap(entry -> Locale.forLanguageTag((String)entry.getKey()), Map.Entry::getValue)));
    }

    private void saveDescriptions(PortletInstanceDatabind portletInstanceDatabind, PortletInstance portletInstance) {
        this.translationService.saveTranslationLabels("portletInstance", portletInstance.getId() == 0L ? null : String.valueOf(portletInstance.getId()), "description", portletInstanceDatabind.getDescriptions().entrySet().stream().collect(Collectors.toMap(entry -> Locale.forLanguageTag((String)entry.getKey()), Map.Entry::getValue)), true);
    }

    private File getIllustrationFile(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Illustration data is null");
        }
        File tempFile = File.createTempFile("temp", ".png");
        FileUtils.writeByteArrayToFile((File)tempFile, (byte[])data);
        return tempFile;
    }

    private long getSuperUserIdentityId() {
        if (this.superUserIdentityId == 0L) {
            this.superUserIdentityId = Long.parseLong(this.identityManager.getOrCreateUserIdentity(this.userAcl.getSuperUser()).getId());
        }
        return this.superUserIdentityId;
    }

    static {
        PortletInstanceDatabindPlugin.ajc$preClinit();
        RANDOM = new Random();
    }

    static final /* synthetic */ List importPortletInstances_aroundBody0(PortletInstanceDatabindPlugin ajc$this, File zipFile, long categoryId, JoinPoint joinPoint) {
        Map<String, PortletInstanceDatabind> instances = ajc$this.extractInstances(zipFile);
        ArrayList<String> processedInstances = new ArrayList<String>();
        for (Map.Entry<String, PortletInstanceDatabind> entry : instances.entrySet()) {
            PortletInstanceDatabind instance = entry.getValue();
            ajc$this.processPortletInstance(instance, categoryId);
            processedInstances.add(instance.getContentId());
        }
        return processedInstances;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PortletInstanceDatabindPlugin.java", PortletInstanceDatabindPlugin.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "importPortletInstances", "io.meeds.layout.plugin.PortletInstanceDatabindPlugin", "java.io.File:long", "zipFile:categoryId", "", "java.util.List"), 175);
    }
}

