/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch.ml.DataframeEvaluation;
import co.elastic.clients.elasticsearch.ml.DataframeEvaluationVariant;
import co.elastic.clients.elasticsearch.ml.EvaluateDataFrameResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class EvaluateDataFrameRequest
extends RequestBase
implements JsonpSerializable {
    private final DataframeEvaluation evaluation;
    private final String index;
    @Nullable
    private final Query query;
    public static final JsonpDeserializer<EvaluateDataFrameRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, EvaluateDataFrameRequest::setupEvaluateDataFrameRequestDeserializer);
    public static final Endpoint<EvaluateDataFrameRequest, EvaluateDataFrameResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<EvaluateDataFrameRequest, EvaluateDataFrameResponse>("es/ml.evaluate_data_frame", request -> "POST", request -> "/_ml/data_frame/_evaluate", request -> Collections.emptyMap(), request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, EvaluateDataFrameResponse._DESERIALIZER);

    private EvaluateDataFrameRequest(Builder builder) {
        this.evaluation = ApiTypeHelper.requireNonNull(builder.evaluation, this, "evaluation");
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.query = builder.query;
    }

    public static EvaluateDataFrameRequest of(Function<Builder, ObjectBuilder<EvaluateDataFrameRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final DataframeEvaluation evaluation() {
        return this.evaluation;
    }

    public final String index() {
        return this.index;
    }

    @Nullable
    public final Query query() {
        return this.query;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("evaluation");
        this.evaluation.serialize(generator, mapper);
        generator.writeKey("index");
        generator.write(this.index);
        if (this.query != null) {
            generator.writeKey("query");
            this.query.serialize(generator, mapper);
        }
    }

    protected static void setupEvaluateDataFrameRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::evaluation, DataframeEvaluation._DESERIALIZER, "evaluation");
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index");
        op.add(Builder::query, Query._DESERIALIZER, "query");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<EvaluateDataFrameRequest> {
        private DataframeEvaluation evaluation;
        private String index;
        @Nullable
        private Query query;

        public final Builder evaluation(DataframeEvaluation value) {
            this.evaluation = value;
            return this;
        }

        public final Builder evaluation(Function<DataframeEvaluation.Builder, ObjectBuilder<DataframeEvaluation>> fn) {
            return this.evaluation(fn.apply(new DataframeEvaluation.Builder()).build());
        }

        public final Builder evaluation(DataframeEvaluationVariant value) {
            this.evaluation = value._toDataframeEvaluation();
            return this;
        }

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        public final Builder query(@Nullable Query value) {
            this.query = value;
            return this;
        }

        public final Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public final Builder query(QueryVariant value) {
            this.query = value._toQuery();
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public EvaluateDataFrameRequest build() {
            this._checkSingleUse();
            return new EvaluateDataFrameRequest(this);
        }
    }
}

