/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.inference.HuggingFaceServiceSettings;
import co.elastic.clients.elasticsearch.inference.HuggingFaceServiceType;
import co.elastic.clients.elasticsearch.inference.HuggingFaceTaskType;
import co.elastic.clients.elasticsearch.inference.InferenceChunkingSettings;
import co.elastic.clients.elasticsearch.inference.PutHuggingFaceResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutHuggingFaceRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final InferenceChunkingSettings chunkingSettings;
    private final String huggingfaceInferenceId;
    private final HuggingFaceServiceType service;
    private final HuggingFaceServiceSettings serviceSettings;
    private final HuggingFaceTaskType taskType;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<PutHuggingFaceRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutHuggingFaceRequest::setupPutHuggingFaceRequestDeserializer);
    public static final Endpoint<PutHuggingFaceRequest, PutHuggingFaceResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutHuggingFaceRequest, PutHuggingFaceResponse>("es/inference.put_hugging_face", request -> "PUT", request -> {
        boolean _taskType = true;
        int _huggingfaceInferenceId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_inference");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.taskType.jsonValue(), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.huggingfaceInferenceId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _taskType = true;
        int _huggingfaceInferenceId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("taskType", request.taskType.jsonValue());
            params.put("huggingfaceInferenceId", request.huggingfaceInferenceId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutHuggingFaceResponse._DESERIALIZER);

    private PutHuggingFaceRequest(Builder builder) {
        this.chunkingSettings = builder.chunkingSettings;
        this.huggingfaceInferenceId = ApiTypeHelper.requireNonNull(builder.huggingfaceInferenceId, this, "huggingfaceInferenceId");
        this.service = ApiTypeHelper.requireNonNull(builder.service, this, "service");
        this.serviceSettings = ApiTypeHelper.requireNonNull(builder.serviceSettings, this, "serviceSettings");
        this.taskType = ApiTypeHelper.requireNonNull(builder.taskType, this, "taskType");
        this.timeout = builder.timeout;
    }

    public static PutHuggingFaceRequest of(Function<Builder, ObjectBuilder<PutHuggingFaceRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final InferenceChunkingSettings chunkingSettings() {
        return this.chunkingSettings;
    }

    public final String huggingfaceInferenceId() {
        return this.huggingfaceInferenceId;
    }

    public final HuggingFaceServiceType service() {
        return this.service;
    }

    public final HuggingFaceServiceSettings serviceSettings() {
        return this.serviceSettings;
    }

    public final HuggingFaceTaskType taskType() {
        return this.taskType;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.chunkingSettings != null) {
            generator.writeKey("chunking_settings");
            this.chunkingSettings.serialize(generator, mapper);
        }
        generator.writeKey("service");
        this.service.serialize(generator, mapper);
        generator.writeKey("service_settings");
        this.serviceSettings.serialize(generator, mapper);
    }

    protected static void setupPutHuggingFaceRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::chunkingSettings, InferenceChunkingSettings._DESERIALIZER, "chunking_settings");
        op.add(Builder::service, HuggingFaceServiceType._DESERIALIZER, "service");
        op.add(Builder::serviceSettings, HuggingFaceServiceSettings._DESERIALIZER, "service_settings");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutHuggingFaceRequest> {
        @Nullable
        private InferenceChunkingSettings chunkingSettings;
        private String huggingfaceInferenceId;
        private HuggingFaceServiceType service;
        private HuggingFaceServiceSettings serviceSettings;
        private HuggingFaceTaskType taskType;
        @Nullable
        private Time timeout;

        public final Builder chunkingSettings(@Nullable InferenceChunkingSettings value) {
            this.chunkingSettings = value;
            return this;
        }

        public final Builder chunkingSettings(Function<InferenceChunkingSettings.Builder, ObjectBuilder<InferenceChunkingSettings>> fn) {
            return this.chunkingSettings(fn.apply(new InferenceChunkingSettings.Builder()).build());
        }

        public final Builder huggingfaceInferenceId(String value) {
            this.huggingfaceInferenceId = value;
            return this;
        }

        public final Builder service(HuggingFaceServiceType value) {
            this.service = value;
            return this;
        }

        public final Builder serviceSettings(HuggingFaceServiceSettings value) {
            this.serviceSettings = value;
            return this;
        }

        public final Builder serviceSettings(Function<HuggingFaceServiceSettings.Builder, ObjectBuilder<HuggingFaceServiceSettings>> fn) {
            return this.serviceSettings(fn.apply(new HuggingFaceServiceSettings.Builder()).build());
        }

        public final Builder taskType(HuggingFaceTaskType value) {
            this.taskType = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutHuggingFaceRequest build() {
            this._checkSingleUse();
            return new PutHuggingFaceRequest(this);
        }
    }
}

