/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.query.BaseQueryBuilder;
import org.springframework.data.elasticsearch.core.query.DocValueField;
import org.springframework.data.elasticsearch.core.query.HighlightQuery;
import org.springframework.data.elasticsearch.core.query.IndexBoost;
import org.springframework.data.elasticsearch.core.query.IndicesOptions;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.RescorerQuery;
import org.springframework.data.elasticsearch.core.query.RuntimeField;
import org.springframework.data.elasticsearch.core.query.ScriptedField;
import org.springframework.data.elasticsearch.core.query.SourceFilter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class BaseQuery
implements Query {
    public static final int INDEX_MAX_RESULT_WINDOW = 10000;
    private static final int DEFAULT_REACTIVE_BATCH_SIZE = 500;
    private static final Pageable UNSET_PAGE = PageRequest.of((int)0, (int)1);
    @Nullable
    protected Sort sort;
    protected Pageable pageable = UNSET_PAGE;
    protected List<String> fields = new ArrayList<String>();
    @Nullable
    protected List<String> storedFields;
    @Nullable
    protected SourceFilter sourceFilter;
    protected float minScore;
    @Nullable
    protected Collection<String> ids;
    @Nullable
    protected String route;
    @Nullable
    protected Query.SearchType searchType = Query.SearchType.QUERY_THEN_FETCH;
    @Nullable
    protected IndicesOptions indicesOptions;
    protected boolean trackScores;
    @Nullable
    protected String preference;
    @Nullable
    protected Integer maxResults;
    @Nullable
    protected HighlightQuery highlightQuery;
    @Nullable
    private Boolean trackTotalHits;
    @Nullable
    protected Integer trackTotalHitsUpTo;
    @Nullable
    protected Duration scrollTime;
    @Nullable
    protected Duration timeout;
    private boolean explain = false;
    @Nullable
    protected List<Object> searchAfter;
    @Nullable
    protected List<IndexBoost> indicesBoost;
    protected List<RescorerQuery> rescorerQueries = new ArrayList<RescorerQuery>();
    @Nullable
    protected Boolean requestCache;
    protected List<Query.IdWithRouting> idsWithRouting = Collections.emptyList();
    protected List<RuntimeField> runtimeFields = new ArrayList<RuntimeField>();
    @Nullable
    protected Query.PointInTime pointInTime;
    private boolean queryIsUpdatedByConverter = false;
    @Nullable
    private Integer reactiveBatchSize = null;
    @Nullable
    private Boolean allowNoIndices = null;
    private EnumSet<IndicesOptions.WildcardStates> expandWildcards = EnumSet.noneOf(IndicesOptions.WildcardStates.class);
    private List<DocValueField> docValueFields = new ArrayList<DocValueField>();
    private List<ScriptedField> scriptedFields = new ArrayList<ScriptedField>();

    public BaseQuery() {
    }

    public <Q extends BaseQuery, B extends BaseQueryBuilder<Q, B>> BaseQuery(BaseQueryBuilder<Q, B> builder) {
        this.sort = builder.getSort();
        this.setPageable(builder.getPageable() != null ? builder.getPageable() : UNSET_PAGE);
        this.fields = builder.getFields();
        this.storedFields = builder.getStoredFields();
        this.sourceFilter = builder.getSourceFilter();
        this.minScore = builder.getMinScore();
        this.ids = builder.getIds() == null ? null : builder.getIds();
        this.route = builder.getRoute();
        this.searchType = builder.getSearchType();
        this.indicesOptions = builder.getIndicesOptions();
        this.trackScores = builder.getTrackScores();
        this.preference = builder.getPreference();
        this.maxResults = builder.getMaxResults();
        this.highlightQuery = builder.getHighlightQuery();
        this.trackTotalHits = builder.getTrackTotalHits();
        this.trackTotalHitsUpTo = builder.getTrackTotalHitsUpTo();
        this.scrollTime = builder.getScrollTime();
        this.timeout = builder.getTimeout();
        this.explain = builder.getExplain();
        this.searchAfter = builder.getSearchAfter();
        this.indicesBoost = builder.getIndicesBoost();
        this.rescorerQueries = builder.getRescorerQueries();
        this.requestCache = builder.getRequestCache();
        this.idsWithRouting = builder.getIdsWithRouting();
        this.pointInTime = builder.getPointInTime();
        this.reactiveBatchSize = builder.getReactiveBatchSize();
        this.allowNoIndices = builder.getAllowNoIndices();
        this.expandWildcards = builder.getExpandWildcards();
        this.docValueFields = builder.getDocValueFields();
        this.scriptedFields = builder.getScriptedFields();
        this.runtimeFields = builder.getRuntimeFields();
    }

    public void setSort(@Nullable Sort sort) {
        this.sort = sort;
    }

    @Override
    @Nullable
    public Sort getSort() {
        return this.sort;
    }

    @Override
    public Pageable getPageable() {
        return this.pageable;
    }

    @Override
    public final <T extends Query> T setPageable(Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
        this.pageable = pageable;
        return this.addSort(pageable.getSort());
    }

    @Override
    public void addFields(String ... fields) {
        Collections.addAll(this.fields, fields);
    }

    @Override
    public List<String> getFields() {
        return this.fields;
    }

    @Override
    public void setFields(List<String> fields) {
        Assert.notNull(fields, (String)"fields must not be null");
        this.fields.clear();
        this.fields.addAll(fields);
    }

    @Override
    public void addStoredFields(String ... storedFields) {
        if (storedFields.length == 0) {
            return;
        }
        if (this.storedFields == null) {
            this.storedFields = new ArrayList<String>(storedFields.length);
        }
        Collections.addAll(this.storedFields, storedFields);
    }

    @Override
    @Nullable
    public List<String> getStoredFields() {
        return this.storedFields;
    }

    @Override
    public void setStoredFields(@Nullable List<String> storedFields) {
        this.storedFields = storedFields;
    }

    @Override
    public void addSourceFilter(SourceFilter sourceFilter) {
        this.sourceFilter = sourceFilter;
    }

    @Override
    @Nullable
    public SourceFilter getSourceFilter() {
        return this.sourceFilter;
    }

    @Override
    public final <T extends Query> T addSort(@Nullable Sort sort) {
        if (sort == null || sort.isUnsorted()) {
            return (T)this;
        }
        this.sort = this.sort == null ? sort : this.sort.and(sort);
        return (T)this;
    }

    @Override
    public float getMinScore() {
        return this.minScore;
    }

    public void setMinScore(float minScore) {
        this.minScore = minScore;
    }

    public void setIds(@Nullable Collection<String> ids) {
        this.ids = ids;
    }

    @Override
    @Nullable
    public Collection<String> getIds() {
        return this.ids;
    }

    @Override
    public List<Query.IdWithRouting> getIdsWithRouting() {
        if (!CollectionUtils.isEmpty(this.idsWithRouting)) {
            return Collections.unmodifiableList(this.idsWithRouting);
        }
        if (!CollectionUtils.isEmpty(this.ids)) {
            return this.ids.stream().map(id -> new Query.IdWithRouting((String)id, this.route)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public void setIdsWithRouting(List<Query.IdWithRouting> idsWithRouting) {
        Assert.notNull(idsWithRouting, (String)"idsWithRouting must not be null");
        this.idsWithRouting = idsWithRouting;
    }

    @Override
    @Nullable
    public String getRoute() {
        return this.route;
    }

    public void setRoute(String route) {
        this.route = route;
    }

    public void setSearchType(@Nullable Query.SearchType searchType) {
        this.searchType = searchType;
    }

    @Override
    @Nullable
    public Query.SearchType getSearchType() {
        return this.searchType;
    }

    @Override
    @Nullable
    public IndicesOptions getIndicesOptions() {
        return this.indicesOptions;
    }

    public void setIndicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
    }

    @Override
    public boolean getTrackScores() {
        return this.trackScores;
    }

    public void setTrackScores(boolean trackScores) {
        this.trackScores = trackScores;
    }

    @Override
    @Nullable
    public String getPreference() {
        return this.preference;
    }

    @Override
    public void setPreference(String preference) {
        this.preference = preference;
    }

    @Override
    public boolean isLimiting() {
        return this.maxResults != null;
    }

    @Override
    @Nullable
    public Integer getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    @Override
    public void setHighlightQuery(HighlightQuery highlightQuery) {
        this.highlightQuery = highlightQuery;
    }

    @Override
    public Optional<HighlightQuery> getHighlightQuery() {
        return Optional.ofNullable(this.highlightQuery);
    }

    @Override
    public void setTrackTotalHits(@Nullable Boolean trackTotalHits) {
        this.trackTotalHits = trackTotalHits;
    }

    @Override
    @Nullable
    public Boolean getTrackTotalHits() {
        return this.trackTotalHits;
    }

    @Override
    public void setTrackTotalHitsUpTo(@Nullable Integer trackTotalHitsUpTo) {
        this.trackTotalHitsUpTo = trackTotalHitsUpTo;
    }

    @Override
    @Nullable
    public Integer getTrackTotalHitsUpTo() {
        return this.trackTotalHitsUpTo;
    }

    @Override
    @Nullable
    public Duration getScrollTime() {
        return this.scrollTime;
    }

    @Override
    public void setScrollTime(@Nullable Duration scrollTime) {
        this.scrollTime = scrollTime;
    }

    @Override
    @Nullable
    public Duration getTimeout() {
        return this.timeout;
    }

    public void setTimeout(@Nullable Duration timeout) {
        this.timeout = timeout;
    }

    @Override
    public boolean getExplain() {
        return this.explain;
    }

    public void setExplain(boolean explain) {
        this.explain = explain;
    }

    @Override
    public void setSearchAfter(@Nullable List<Object> searchAfter) {
        this.searchAfter = searchAfter;
    }

    @Override
    @Nullable
    public List<Object> getSearchAfter() {
        return this.searchAfter;
    }

    @Override
    public void addRescorerQuery(RescorerQuery rescorerQuery) {
        Assert.notNull((Object)rescorerQuery, (String)"rescorerQuery must not be null");
        this.rescorerQueries.add(rescorerQuery);
    }

    @Override
    public void setRescorerQueries(List<RescorerQuery> rescorerQueryList) {
        Assert.notNull(this.rescorerQueries, (String)"rescorerQueries must not be null");
        this.rescorerQueries.clear();
        this.rescorerQueries.addAll(rescorerQueryList);
    }

    @Override
    public List<RescorerQuery> getRescorerQueries() {
        return this.rescorerQueries;
    }

    @Override
    public void setRequestCache(@Nullable Boolean value) {
        this.requestCache = value;
    }

    @Override
    @Nullable
    public Boolean getRequestCache() {
        return this.requestCache;
    }

    @Override
    public void addRuntimeField(RuntimeField runtimeField) {
        Assert.notNull((Object)runtimeField, (String)"runtimeField must not be null");
        this.runtimeFields.add(runtimeField);
    }

    @Override
    public List<RuntimeField> getRuntimeFields() {
        return this.runtimeFields;
    }

    @Override
    @Nullable
    public List<IndexBoost> getIndicesBoost() {
        return this.indicesBoost;
    }

    @Override
    @Nullable
    public Query.PointInTime getPointInTime() {
        return this.pointInTime;
    }

    public void setPointInTime(@Nullable Query.PointInTime pointInTime) {
        this.pointInTime = pointInTime;
    }

    public boolean queryIsUpdatedByConverter() {
        return this.queryIsUpdatedByConverter;
    }

    public void setQueryIsUpdatedByConverter(boolean queryIsUpdatedByConverter) {
        this.queryIsUpdatedByConverter = queryIsUpdatedByConverter;
    }

    @Override
    public Integer getReactiveBatchSize() {
        return this.reactiveBatchSize != null ? this.reactiveBatchSize : 500;
    }

    public void setReactiveBatchSize(Integer reactiveBatchSize) {
        this.reactiveBatchSize = reactiveBatchSize;
    }

    @Override
    @Nullable
    public Boolean getAllowNoIndices() {
        return this.allowNoIndices;
    }

    @Override
    public EnumSet<IndicesOptions.WildcardStates> getExpandWildcards() {
        return this.expandWildcards;
    }

    @Override
    public List<DocValueField> getDocValueFields() {
        return this.docValueFields;
    }

    public void setDocValueFields(List<DocValueField> docValueFields) {
        Assert.notNull(docValueFields, (String)"getDocValueFields must not be null");
        this.docValueFields = docValueFields;
    }

    public void addScriptedField(ScriptedField scriptedField) {
        Assert.notNull((Object)scriptedField, (String)"scriptedField must not be null");
        this.scriptedFields.add(scriptedField);
    }

    @Override
    public List<ScriptedField> getScriptedFields() {
        return this.scriptedFields;
    }

    @Override
    public Integer getRequestSize() {
        Pageable pageable = this.getPageable();
        Integer requestSize = null;
        requestSize = pageable.isPaged() && pageable != UNSET_PAGE ? (!this.isLimiting() ? Integer.valueOf(pageable.getPageSize()) : Integer.valueOf(Math.min(pageable.getPageSize(), this.getMaxResults()))) : (pageable == UNSET_PAGE ? (this.isLimiting() ? this.getMaxResults() : Integer.valueOf(10)) : (!this.isLimiting() ? Integer.valueOf(10000) : Integer.valueOf(Math.min(10000, this.getMaxResults()))));
        if (requestSize == null) {
            requestSize = 10;
        }
        return requestSize;
    }
}

