/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.site;

import java.util.HashMap;
import java.util.Map;

public enum SiteType {
    SITE("site"),
    SPACE("space"),
    DASHBOARD("dashboard");

    private final String name;
    private static final Map<String, SiteType> MAP;

    private SiteType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static SiteType forName(String name) {
        return MAP.get(name);
    }

    static {
        HashMap<String, SiteType> map = new HashMap<String, SiteType>();
        for (SiteType type : SiteType.values()) {
            String name = type.getName();
            if (name == null) continue;
            map.put(name, type);
        }
        MAP = map;
    }
}

