/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.crowdin.gamification.plugin;

import io.meeds.crowdin.gamification.model.Event;
import io.meeds.crowdin.gamification.plugin.CrowdinTriggerPlugin;
import io.meeds.crowdin.gamification.services.CrowdinTriggerService;
import io.meeds.crowdin.gamification.utils.Utils;
import io.meeds.gamification.model.RealizationDTO;
import io.meeds.gamification.service.RealizationService;
import jakarta.annotation.PostConstruct;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SuggestionAddedTriggerPlugin
extends CrowdinTriggerPlugin {
    @Autowired
    private CrowdinTriggerService crowdinTriggerService;
    @Autowired
    private RealizationService realizationService;

    @PostConstruct
    public void init() {
        this.crowdinTriggerService.addPlugin(this);
    }

    @Override
    public List<Event> getEvents(String trigger, Map<String, Object> payload) {
        String objectId = Utils.constructObjectIdAsJsonString(payload, "translation");
        if (trigger.equals("suggestion.added")) {
            return Collections.singletonList(new Event("suggestionAdded", Utils.extractSubItem(payload, "translation", "user", "username"), Utils.extractSubItem(payload, "translation", "user", "username"), objectId, "translation", this.getProjectId(payload), Utils.extractSubItem(payload, "translation", "targetLanguage", "id"), Utils.extractSubItem(payload, "translation", "provider") == null, Utils.extractSubItem(payload, "translation", "string", "file", "directoryId"), false));
        }
        if (trigger.equals("suggestion.deleted")) {
            List realizations = this.realizationService.findRealizationsByObjectIdAndObjectType(objectId, "translation");
            if (CollectionUtils.isEmpty((Collection)realizations)) {
                return Collections.emptyList();
            }
            String earnerId = ((RealizationDTO)realizations.get(0)).getEarnerId();
            return Collections.singletonList(new Event("suggestionAdded", earnerId, earnerId, objectId, "translation", this.getProjectId(payload), Utils.extractSubItem(payload, "translation", "targetLanguage", "id"), Utils.extractSubItem(payload, "translation", "provider") == null, Utils.extractSubItem(payload, "translation", "string", "file", "directoryId"), true));
        }
        return Collections.emptyList();
    }

    @Override
    public String getEventName() {
        return "suggestion.added";
    }

    @Override
    public String getCancellingEventName() {
        return "suggestion.deleted";
    }

    @Override
    public String getProjectId(Map<String, Object> payload) {
        return Utils.extractSubItem(payload, "translation", "string", "project", "id");
    }
}

