/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.crowdin.gamification.storage;

import io.meeds.crowdin.gamification.exception.CrowdinConnectionException;
import io.meeds.crowdin.gamification.model.RemoteApproval;
import io.meeds.crowdin.gamification.model.RemoteDirectory;
import io.meeds.crowdin.gamification.model.RemoteLanguage;
import io.meeds.crowdin.gamification.model.RemoteProject;
import io.meeds.crowdin.gamification.model.WebHook;
import io.meeds.crowdin.gamification.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class CrowdinConsumerStorage {
    public static final String TOKEN_EXPIRED_OR_INVALID = "crowdin.tokenExpiredOrInvalid";
    private HttpClient client;
    private static final Log LOG = ExoLogger.getLogger(CrowdinConsumerStorage.class);

    public List<RemoteProject> getProjects(String accessToken) throws IllegalAccessException {
        try {
            URI uri = URI.create("https://api.crowdin.com/api/v2/projects/?hasManagerAccess=1");
            String response = this.processGet(uri, accessToken);
            JSONArray jsonArray = new JSONObject(response).getJSONArray("data");
            ArrayList<RemoteProject> projects = new ArrayList<RemoteProject>();
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObjectData = jsonArray.getJSONObject(i);
                JSONObject jsonObject = jsonObjectData.getJSONObject("data");
                RemoteProject project = new RemoteProject();
                project.setId(jsonObject.getInt("id"));
                project.setName(jsonObject.getString("name"));
                project.setIdentifier(jsonObject.getString("identifier"));
                projects.add(project);
            }
            return projects;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e);
        }
        catch (CrowdinConnectionException e) {
            throw new IllegalAccessException(TOKEN_EXPIRED_OR_INVALID);
        }
    }

    public WebHook createWebhook(long projectId, String[] triggers, String accessToken) throws IllegalAccessException {
        try {
            URI uri = URI.create("https://api.crowdin.com/api/v2/projects/" + projectId + "/webhooks");
            String secret = Utils.generateRandomSecret(8);
            JSONArray events = new JSONArray();
            Arrays.stream(triggers).forEach(arg_0 -> ((JSONArray)events).put(arg_0));
            JSONObject requestJson = new JSONObject();
            requestJson.put("name", (Object)"Meeds");
            requestJson.put("url", (Object)(CommonsUtils.getCurrentDomain() + "/gamification-crowdin/rest/crowdin/webhooks"));
            requestJson.put("events", (Object)events);
            requestJson.put("requestType", (Object)"POST");
            requestJson.put("isActive", true);
            requestJson.put("batchingEnabled", true);
            requestJson.put("contentType", (Object)"application/json");
            JSONObject headers = new JSONObject();
            headers.put("Authorization", (Object)("Bearer " + secret));
            requestJson.put("headers", (Object)headers);
            HashMap<String, String> fileMap = new HashMap<String, String>();
            fileMap.put("id", "{{fileId}}");
            fileMap.put("directoryId", "{{directoryId}}");
            HashMap<String, String> projectMap = new HashMap<String, String>();
            projectMap.put("id", "{{projectId}}");
            projectMap.put("sourceLanguageId", "{{projectSourceLanguageId}}");
            projectMap.put("identifier", "{{projectIdentifier}}");
            HashMap<String, Object> stringMap = new HashMap<String, Object>();
            stringMap.put("id", "{{stringId}}");
            stringMap.put("text", "{{stringText}}");
            stringMap.put("file", fileMap);
            stringMap.put("project", projectMap);
            HashMap<String, String> userMap = new HashMap<String, String>();
            userMap.put("id", "{{userId}}");
            userMap.put("username", "{{userUsername}}");
            userMap.put("fullName", "{{userFullName}}");
            userMap.put("avatarUrl", "{{userAvatarUrl}}");
            HashMap<String, String> languageMap = new HashMap<String, String>();
            languageMap.put("id", "{{targetLanguageId}}");
            HashMap<String, Object> translationMap = new HashMap<String, Object>();
            translationMap.put("id", "{{translationId}}");
            translationMap.put("provider", "{{translationProvider}}");
            translationMap.put("targetLanguage", languageMap);
            translationMap.put("user", userMap);
            translationMap.put("string", stringMap);
            HashMap<String, Object> commentMap = new HashMap<String, Object>();
            commentMap.put("id", "{{commentId}}");
            commentMap.put("targetLanguage", languageMap);
            commentMap.put("user", userMap);
            commentMap.put("string", stringMap);
            HashMap<String, Object> translationEventMap = new HashMap<String, Object>();
            translationEventMap.put("event", "{{event}}");
            translationEventMap.put("translation", translationMap);
            HashMap<String, Object> commentEventMap = new HashMap<String, Object>();
            commentEventMap.put("event", "{{event}}");
            commentEventMap.put("comment", commentMap);
            HashMap payload = new HashMap();
            Arrays.stream(Utils.CROWDIN_EVENTS).forEach(event -> {
                if (List.of("stringComment.created", "stringComment.deleted").contains(event)) {
                    payload.put(event, commentEventMap);
                } else {
                    payload.put(event, translationEventMap);
                }
            });
            requestJson.put("payload", payload);
            String response = this.processPost(uri, requestJson.toString(), accessToken);
            JSONObject responseJson = new JSONObject(response);
            JSONObject dataJson = responseJson.getJSONObject("data");
            WebHook localWebHook = new WebHook();
            localWebHook.setWebhookId(dataJson.getLong("id"));
            localWebHook.setProjectId(dataJson.getLong("projectId"));
            localWebHook.setTriggers(List.of(triggers));
            localWebHook.setToken(accessToken);
            localWebHook.setSecret(secret);
            return localWebHook;
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)e);
            throw new IllegalArgumentException(e);
        }
        catch (CrowdinConnectionException e) {
            LOG.error((Object)e);
            throw new IllegalAccessException(TOKEN_EXPIRED_OR_INVALID);
        }
    }

    private String processGet(URI uri, String accessToken) throws CrowdinConnectionException {
        HttpClient httpClient = this.getHttpClient();
        HttpGet request = new HttpGet(uri);
        try {
            request.setHeader("Authorization", "Bearer " + accessToken);
            return this.processRequest(httpClient, (HttpRequestBase)request);
        }
        catch (IOException e) {
            throw new CrowdinConnectionException("crowdin.connectionError", e);
        }
    }

    private String processPost(URI uri, String jsonString, String accessToken) throws CrowdinConnectionException {
        HttpClient httpClient = this.getHttpClient();
        HttpPost request = new HttpPost(uri);
        StringEntity entity = new StringEntity(jsonString, ContentType.APPLICATION_JSON);
        try {
            request.setHeader("Content-Type", "application/json");
            request.setHeader("Authorization", "Bearer " + accessToken);
            request.setEntity((HttpEntity)entity);
            return this.processRequest(httpClient, (HttpRequestBase)request);
        }
        catch (IOException e) {
            throw new CrowdinConnectionException("crowdin.connectionError", e);
        }
    }

    private String processDelete(URI uri, String accessToken) throws CrowdinConnectionException {
        HttpClient httpClient = this.getHttpClient();
        HttpDelete request = new HttpDelete(uri);
        try {
            request.setHeader("Authorization", "Bearer " + accessToken);
            return this.processRequest(httpClient, (HttpRequestBase)request);
        }
        catch (IOException e) {
            throw new CrowdinConnectionException("crowdin.connectionError", e);
        }
    }

    private String processRequest(HttpClient httpClient, HttpRequestBase request) throws IOException, CrowdinConnectionException {
        boolean isSuccess;
        HttpResponse response = httpClient.execute((HttpUriRequest)request);
        boolean bl = isSuccess = response != null && response.getStatusLine().getStatusCode() >= 200 && response.getStatusLine().getStatusCode() < 300;
        if (isSuccess) {
            return this.processSuccessResponse(response);
        }
        if (response != null && response.getStatusLine().getStatusCode() == 404) {
            return null;
        }
        this.processErrorResponse(response);
        return null;
    }

    private String processSuccessResponse(HttpResponse response) throws IOException {
        if (response.getStatusLine().getStatusCode() == 204) {
            return String.valueOf(204);
        }
        if ((response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 200) && response.getEntity() != null && response.getEntity().getContentLength() != 0L) {
            try (InputStream is = response.getEntity().getContent();){
                String string = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                return string;
            }
        }
        return null;
    }

    private void processErrorResponse(HttpResponse response) throws CrowdinConnectionException, IOException {
        if (response == null) {
            throw new CrowdinConnectionException("Error when connecting crowdin");
        }
        if (response.getEntity() != null) {
            InputStream is = response.getEntity().getContent();
            try {
                String errorMessage = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                if (StringUtils.contains((CharSequence)errorMessage, (CharSequence)"")) {
                    throw new CrowdinConnectionException(errorMessage);
                }
                throw new CrowdinConnectionException("crowdin.connectionError" + errorMessage);
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        throw new CrowdinConnectionException("crowdin.connectionError" + response.getStatusLine().getStatusCode());
    }

    private HttpClient getHttpClient() {
        if (this.client == null) {
            HttpClientConnectionManager clientConnectionManager = this.getClientConnectionManager();
            HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager(clientConnectionManager).setConnectionReuseStrategy((ConnectionReuseStrategy)new DefaultConnectionReuseStrategy());
            this.client = httpClientBuilder.build();
        }
        return this.client;
    }

    private HttpClientConnectionManager getClientConnectionManager() {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(10);
        return connectionManager;
    }

    public RemoteProject retrieveRemoteProject(long projectRemoteId, boolean includeLanguages, String accessToken) throws IllegalAccessException {
        try {
            URI uri = URI.create("https://api.crowdin.com/api/v2/projects/" + projectRemoteId);
            String response = this.processGet(uri, accessToken);
            if (response == null) {
                return null;
            }
            return CrowdinConsumerStorage.getRemoteProject(response, includeLanguages);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e);
        }
        catch (CrowdinConnectionException e) {
            throw new IllegalAccessException(TOKEN_EXPIRED_OR_INVALID);
        }
    }

    private static RemoteProject getRemoteProject(String response, boolean includeLanguages) {
        JSONObject responseJson = new JSONObject(response);
        JSONObject jsonObject = responseJson.getJSONObject("data");
        RemoteProject project = new RemoteProject();
        project.setId(jsonObject.getInt("id"));
        project.setName(jsonObject.getString("name"));
        project.setIdentifier(jsonObject.getString("identifier"));
        if (jsonObject.get("logo") instanceof String) {
            project.setAvatarUrl(jsonObject.getString("logo"));
        }
        if (includeLanguages) {
            JSONArray languages = jsonObject.getJSONArray("targetLanguages");
            ArrayList<RemoteLanguage> remoteLanguages = new ArrayList<RemoteLanguage>();
            for (int i = 0; i < languages.length(); ++i) {
                JSONObject language = languages.getJSONObject(i);
                RemoteLanguage remoteLanguage = new RemoteLanguage();
                remoteLanguage.setId(language.getString("id"));
                remoteLanguage.setName(language.getString("name"));
                remoteLanguages.add(remoteLanguage);
            }
            project.setLanguages(remoteLanguages);
        }
        return project;
    }

    public String deleteWebhook(WebHook webHook) {
        URI uri = URI.create("https://api.crowdin.com/api/v2/projects/" + webHook.getProjectId() + "/webhooks/" + webHook.getWebhookId());
        try {
            return this.processDelete(uri, webHook.getToken());
        }
        catch (CrowdinConnectionException e) {
            throw new IllegalStateException("Unable to delete Crowdin hook");
        }
    }

    public List<RemoteDirectory> getProjectDirectories(long remoteProjectId, int offset, int limit, String accessToken) throws IllegalAccessException {
        try {
            URI uri = URI.create("https://api.crowdin.com/api/v2/projects/" + remoteProjectId + "/directories?offset=" + offset + "&limit=" + limit);
            String response = this.processGet(uri, accessToken);
            JSONArray jsonArray = new JSONObject(response).getJSONArray("data");
            ArrayList<RemoteDirectory> directories = new ArrayList<RemoteDirectory>();
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObjectData = jsonArray.getJSONObject(i);
                JSONObject jsonObject = jsonObjectData.getJSONObject("data");
                RemoteDirectory directory = new RemoteDirectory();
                directory.setId(jsonObject.getInt("id"));
                directory.setProjectId(jsonObject.getLong("projectId"));
                directory.setPath(jsonObject.getString("path"));
                directories.add(directory);
            }
            return directories;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e);
        }
        catch (CrowdinConnectionException e) {
            throw new IllegalAccessException(TOKEN_EXPIRED_OR_INVALID);
        }
    }

    public RemoteApproval getApproval(String accessToken, String projectId, String translationId) {
        try {
            URI uri = URI.create("https://api.crowdin.com/api/v2/projects/" + projectId + "/approvals/?translationId=" + translationId);
            String response = this.processGet(uri, accessToken);
            JSONArray jsonArray = new JSONObject(response).getJSONArray("data");
            if (jsonArray.isEmpty()) {
                LOG.warn("Return empty approvals response for crowdin translation with id {}.", new Object[]{translationId});
                return null;
            }
            JSONObject jsonObject = jsonArray.getJSONObject(0).getJSONObject("data");
            RemoteApproval remoteApproval = new RemoteApproval();
            JSONObject userJsonObject = jsonObject.getJSONObject("user");
            remoteApproval.setId(jsonObject.getInt("id"));
            remoteApproval.setUserName(userJsonObject.getString("username"));
            remoteApproval.setTranslationId(jsonObject.getString("translationId"));
            remoteApproval.setLanguageId(jsonObject.getString("languageId"));
            remoteApproval.setStringId(jsonObject.getString("stringId"));
            remoteApproval.setLanguageId(jsonObject.getString("languageId"));
            return remoteApproval;
        }
        catch (CrowdinConnectionException e) {
            LOG.warn("Unable to retrieve approval for crowdin translation with id {}.", new Object[]{translationId, e});
            return null;
        }
    }

    public void clearCache() {
    }
}

