/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.crowdin.gamification.plugin;

import io.meeds.crowdin.gamification.model.Event;
import io.meeds.crowdin.gamification.model.RemoteApproval;
import io.meeds.crowdin.gamification.plugin.CrowdinTriggerPlugin;
import io.meeds.crowdin.gamification.services.CrowdinTriggerService;
import io.meeds.crowdin.gamification.services.WebhookService;
import io.meeds.crowdin.gamification.utils.Utils;
import io.meeds.gamification.service.RealizationService;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SuggestionApprovedTriggerPlugin
extends CrowdinTriggerPlugin {
    @Autowired
    private CrowdinTriggerService crowdinTriggerService;
    @Autowired
    private RealizationService realizationService;
    @Autowired
    private WebhookService webhookService;

    @PostConstruct
    public void init() {
        this.crowdinTriggerService.addPlugin(this);
    }

    @Override
    public List<Event> getEvents(String trigger, Map<String, Object> payload) {
        String objectId = Utils.constructObjectIdAsJsonString(payload, "translation");
        ArrayList<Event> eventList = new ArrayList<Event>();
        eventList.add(new Event("suggestionApproved", Utils.extractSubItem(payload, "translation", "user", "username"), Utils.extractSubItem(payload, "translation", "user", "username"), objectId, "translation", this.getProjectId(payload), Utils.extractSubItem(payload, "translation", "targetLanguage", "id"), Utils.extractSubItem(payload, "translation", "provider") == null, Utils.extractSubItem(payload, "translation", "string", "file", "directoryId"), trigger.equals("suggestion.disapproved"), Utils.countWords(Utils.extractSubItem(payload, "translation", "string", "text"))));
        String translationId = Utils.extractSubItem(payload, "translation", "id");
        RemoteApproval remoteApproval = this.webhookService.getApproval(this.getProjectId(payload), translationId);
        if (remoteApproval != null) {
            eventList.add(new Event("approveSuggestion", remoteApproval.getUserName(), remoteApproval.getUserName(), objectId, "translation", this.getProjectId(payload), Utils.extractSubItem(payload, "translation", "targetLanguage", "id"), Utils.extractSubItem(payload, "translation", "provider") == null, Utils.extractSubItem(payload, "translation", "string", "file", "directoryId"), trigger.equals("suggestion.disapproved"), Utils.countWords(Utils.extractSubItem(payload, "translation", "string", "text"))));
        }
        return eventList;
    }

    @Override
    public String getEventName() {
        return "suggestion.approved";
    }

    @Override
    public String getCancellingEventName() {
        return "suggestion.disapproved";
    }

    @Override
    public String getProjectId(Map<String, Object> payload) {
        return Utils.extractSubItem(payload, "translation", "string", "project", "id");
    }
}

