/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.crowdin.gamification.storage;

import io.meeds.crowdin.gamification.dao.WebHookDAO;
import io.meeds.crowdin.gamification.entity.WebhookEntity;
import io.meeds.crowdin.gamification.model.WebHook;
import io.meeds.crowdin.gamification.storage.mapper.WebHookMapper;
import java.util.Date;
import java.util.List;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Repository;

@Repository
public class WebHookStorage {
    @Autowired
    private WebHookDAO webHookDAO;

    public WebHook saveWebHook(WebHook webHook) throws ObjectAlreadyExistsException {
        WebHook existsWebHook = this.getWebhookByProjectId(webHook.getProjectId());
        if (existsWebHook == null) {
            WebhookEntity webhookEntity = WebHookMapper.toEntity(webHook);
            webhookEntity.setWatchedDate(new Date());
            webhookEntity.setUpdatedDate(new Date());
            webhookEntity.setRefreshDate(new Date());
            webhookEntity.setEnabled(true);
            webhookEntity = (WebhookEntity)this.webHookDAO.save(webhookEntity);
            return WebHookMapper.fromEntity(webhookEntity);
        }
        throw new ObjectAlreadyExistsException((Object)existsWebHook);
    }

    public void updateWebHookAccessToken(long webhookId, String accessToken) {
        WebhookEntity webhookEntity = this.webHookDAO.findById(webhookId).orElse(null);
        if (webhookEntity != null) {
            webhookEntity.setToken(accessToken);
            this.webHookDAO.save(webhookEntity);
        }
    }

    public WebHook getWebHookById(Long id) {
        return WebHookMapper.fromEntity(this.webHookDAO.findById(id).orElse(null));
    }

    public List<WebHook> getWebhooks(int offset, int limit) {
        if (limit > 0) {
            PageRequest pageable = PageRequest.of((int)Math.toIntExact(offset / limit), (int)limit, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"id"}));
            return this.webHookDAO.findAll((Pageable)pageable).getContent().stream().map(WebHookMapper::fromEntity).toList();
        }
        return this.webHookDAO.findAll().stream().map(WebHookMapper::fromEntity).toList();
    }

    public WebHook getWebhookByProjectId(long projectId) {
        WebhookEntity connectorHookEntity = this.webHookDAO.findWebhookEntityByProjectId(projectId);
        return WebHookMapper.fromEntity(connectorHookEntity);
    }

    public WebHook deleteWebHook(long projectId) {
        WebhookEntity webhookEntity = this.webHookDAO.findWebhookEntityByProjectId(projectId);
        if (webhookEntity != null) {
            this.webHookDAO.delete(webhookEntity);
        }
        return WebHookMapper.fromEntity(webhookEntity);
    }
}

