/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.crowdin.gamification.service;

import io.meeds.crowdin.gamification.model.RemoteProject;
import io.meeds.crowdin.gamification.model.WebHook;
import io.meeds.crowdin.gamification.services.WebhookService;
import io.meeds.crowdin.gamification.storage.CrowdinConsumerStorage;
import io.meeds.crowdin.gamification.storage.WebHookStorage;
import io.meeds.crowdin.gamification.utils.Utils;
import java.util.Arrays;
import java.util.List;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={WebhookService.class})
class WebhookServiceTest {
    private static final String ADMIN_USER = "root";
    private static final String USER = "user";
    @MockBean
    private CrowdinConsumerStorage crowdinConsumerStorage;
    @MockBean
    private WebHookStorage webHookStorage;
    @Autowired
    private WebhookService webhookService;

    WebhookServiceTest() {
    }

    @Test
    void testCreateWebhook() throws Exception {
        Throwable exception = Assert.assertThrows(IllegalAccessException.class, () -> this.webhookService.createWebhook(1L, "organizationName", "accessToken", USER));
        Assertions.assertEquals((Object)"The user is not authorized to create Crowdin hook", (Object)exception.getMessage());
        WebHook existsWebHook = new WebHook();
        Mockito.when((Object)this.webHookStorage.getWebhookByProjectId(2L)).thenReturn((Object)existsWebHook);
        Assert.assertThrows(ObjectAlreadyExistsException.class, () -> this.webhookService.createWebhook(2L, "organizationName", "accessToken", ADMIN_USER));
        WebHook webhook = new WebHook();
        webhook.setId(1L);
        webhook.setWebhookId(1245L);
        webhook.setProjectId(11245L);
        webhook.setProjectName("projectName");
        webhook.setTriggers(Arrays.asList(Utils.CROWDIN_EVENTS));
        webhook.setEnabled(Boolean.valueOf(true));
        webhook.setToken("accessToken");
        webhook.setSecret("secret");
        WebHook createdWebHook = this.webhookService.createWebhook(11245L, "organizationName", "accessToken", ADMIN_USER);
        Assertions.assertNull((Object)createdWebHook);
        Mockito.when((Object)this.crowdinConsumerStorage.createWebhook(11245L, Utils.CROWDIN_EVENTS, "accessToken")).thenReturn((Object)webhook);
        webhook.setWatchedBy(ADMIN_USER);
        Mockito.when((Object)this.webHookStorage.saveWebHook(webhook)).thenReturn((Object)webhook);
        createdWebHook = this.webhookService.createWebhook(11245L, "organizationName", "accessToken", ADMIN_USER);
        Assertions.assertNotNull((Object)createdWebHook);
    }

    @Test
    void testGetWebhookId() throws Exception {
        Throwable exception = Assert.assertThrows(IllegalAccessException.class, () -> this.webhookService.getWebhookId(1245L, USER));
        Assertions.assertEquals((Object)"The user is not authorized to access crowdin Hooks", (Object)exception.getMessage());
        exception = Assert.assertThrows(IllegalArgumentException.class, () -> this.webhookService.getWebhookId(-1245L, ADMIN_USER));
        Assertions.assertEquals((Object)"Webhook id is mandatory", (Object)exception.getMessage());
        exception = Assert.assertThrows(ObjectNotFoundException.class, () -> this.webhookService.getWebhookId(1245L, ADMIN_USER));
        Assertions.assertEquals((Object)"Webhook doesn't exist", (Object)exception.getMessage());
        WebHook webhook = new WebHook();
        webhook.setWebhookId(1245L);
        webhook.setProjectId(11245L);
        webhook.setProjectName("projectName");
        webhook.setTriggers(Arrays.asList(Utils.CROWDIN_EVENTS));
        webhook.setEnabled(Boolean.valueOf(true));
        webhook.setToken("accessToken");
        webhook.setSecret("secret");
        Mockito.when((Object)this.webHookStorage.getWebHookById(Long.valueOf(1245L))).thenReturn((Object)webhook);
        this.webhookService.getWebhookId(1245L, ADMIN_USER);
        ((WebHookStorage)Mockito.verify((Object)this.webHookStorage, (VerificationMode)Mockito.times((int)2))).getWebHookById(Long.valueOf(1245L));
    }

    @Test
    void testGetWebhooks() throws Exception {
        Throwable exception = Assert.assertThrows(IllegalAccessException.class, () -> this.webhookService.getWebhooks(USER, 0, -1, false));
        Assertions.assertEquals((Object)"The user is not authorized to access crowdin Hooks", (Object)exception.getMessage());
        WebHook webhook = new WebHook();
        webhook.setWebhookId(1245L);
        webhook.setProjectId(11245L);
        webhook.setProjectName("projectName");
        webhook.setTriggers(Arrays.asList(Utils.CROWDIN_EVENTS));
        webhook.setEnabled(Boolean.valueOf(true));
        webhook.setToken("accessToken");
        webhook.setSecret("secret");
        WebHook webhook1 = new WebHook();
        webhook1.setWebhookId(222545L);
        webhook1.setProjectId(888655L);
        webhook1.setProjectName("projectName1");
        webhook1.setTriggers(Arrays.asList(Utils.CROWDIN_EVENTS));
        webhook1.setEnabled(Boolean.valueOf(true));
        webhook1.setToken("accessToken");
        webhook1.setSecret("secret");
        Mockito.when((Object)this.crowdinConsumerStorage.createWebhook(11245L, Utils.CROWDIN_EVENTS, "accessToken")).thenReturn((Object)webhook);
        webhook.setWatchedBy(ADMIN_USER);
        Mockito.when((Object)this.webHookStorage.saveWebHook(webhook)).thenReturn((Object)webhook);
        Mockito.when((Object)this.crowdinConsumerStorage.createWebhook(888655L, Utils.CROWDIN_EVENTS, "accessToken")).thenReturn((Object)webhook1);
        WebHook webHook = this.webhookService.createWebhook(11245L, "projectName", "accessToken", ADMIN_USER);
        this.webhookService.createWebhook(888655L, "projectName1", "accessToken", ADMIN_USER);
        Assertions.assertNotNull((Object)this.webhookService.getWebhooks(ADMIN_USER, 0, 10, false));
        exception = Assert.assertThrows(IllegalAccessException.class, () -> this.webhookService.deleteWebhook(webHook.getProjectId(), USER));
        Assertions.assertEquals((Object)"The user is not authorized to delete Crowdin hook", (Object)exception.getMessage());
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.webhookService.deleteWebhook(1000L, ADMIN_USER));
        Mockito.when((Object)this.crowdinConsumerStorage.deleteWebhook(webHook)).thenReturn((Object)"response");
        Mockito.when((Object)this.webHookStorage.deleteWebHook(11245L)).thenReturn((Object)webHook);
        Mockito.when((Object)this.webHookStorage.getWebhookByProjectId(11245L)).thenReturn((Object)webHook);
        WebHook deletedWebhook = this.webhookService.deleteWebhook(webHook.getProjectId(), ADMIN_USER);
        Assertions.assertNotNull((Object)deletedWebhook);
    }

    @Test
    void testGetProjects() throws Exception {
        Throwable exception = Assert.assertThrows(ObjectNotFoundException.class, () -> this.webhookService.getProjectsFromWebhookId(1L));
        Assertions.assertEquals((Object)"webhook with id : 1 wasn't found", (Object)exception.getMessage());
        WebHook webhook = new WebHook();
        webhook.setWebhookId(1245L);
        webhook.setProjectId(11245L);
        webhook.setProjectName("projectName");
        webhook.setTriggers(Arrays.asList(Utils.CROWDIN_EVENTS));
        webhook.setEnabled(Boolean.valueOf(true));
        webhook.setToken("accessToken");
        webhook.setSecret("secret");
        RemoteProject remoteProject = new RemoteProject(11245L, "remoteProject", "remoteProject", "remoteProject", "avatarUrl", null);
        RemoteProject remoteProject1 = new RemoteProject(888655L, "remoteProject1", "remoteProject1", "remoteProject1", "avatarUrl1", null);
        Mockito.when((Object)this.webHookStorage.getWebHookById(Long.valueOf(1245L))).thenReturn((Object)webhook);
        Mockito.when((Object)this.crowdinConsumerStorage.getProjects("accessToken")).thenReturn(List.of(remoteProject, remoteProject1));
        Assertions.assertNotNull((Object)this.webhookService.getProjectsFromWebhookId(1245L));
        Assertions.assertNotNull((Object)this.webhookService.getProjects("accessToken"));
    }

    @Test
    void testUpdateWebHookAccessToken() {
        Throwable exception = Assert.assertThrows(IllegalAccessException.class, () -> this.webhookService.updateWebHookAccessToken(1L, "accessToken", USER));
        Assertions.assertEquals((Object)"The user is not authorized to access crowdin Hooks", (Object)exception.getMessage());
        exception = Assert.assertThrows(IllegalArgumentException.class, () -> this.webhookService.updateWebHookAccessToken(-1L, "accessToken", ADMIN_USER));
        Assertions.assertEquals((Object)"webHook id must be positive", (Object)exception.getMessage());
        exception = Assert.assertThrows(ObjectNotFoundException.class, () -> this.webhookService.updateWebHookAccessToken(2L, "accessToken", ADMIN_USER));
        Assertions.assertEquals((Object)"webhook with id : 2 wasn't found", (Object)exception.getMessage());
        WebHook webhook = new WebHook();
        webhook.setWebhookId(1245L);
        webhook.setProjectId(11245L);
        webhook.setProjectName("projectName");
        webhook.setTriggers(Arrays.asList(Utils.CROWDIN_EVENTS));
        webhook.setEnabled(Boolean.valueOf(true));
        webhook.setToken("accessToken");
        webhook.setSecret("secret");
    }

    @Test
    void testGetProjectDirectories() throws Exception {
        Throwable exception = Assert.assertThrows(IllegalAccessException.class, () -> this.webhookService.getProjectDirectories(11245L, USER, 0, 10));
        Assertions.assertEquals((Object)"The user is not authorized to access project directories", (Object)exception.getMessage());
        exception = Assert.assertThrows(ObjectNotFoundException.class, () -> this.webhookService.getProjectDirectories(11245L, ADMIN_USER, 0, 10));
        Assertions.assertEquals((Object)"Webhook with project id '11245' doesn't exist", (Object)exception.getMessage());
        WebHook webhook = new WebHook();
        webhook.setWebhookId(1245L);
        webhook.setProjectId(11245L);
        webhook.setProjectName("projectName");
        webhook.setTriggers(Arrays.asList(Utils.CROWDIN_EVENTS));
        webhook.setEnabled(Boolean.valueOf(true));
        webhook.setToken("accessToken");
        webhook.setSecret("secret");
        Mockito.when((Object)this.webHookStorage.getWebhookByProjectId(11245L)).thenReturn((Object)webhook);
        this.webhookService.getProjectDirectories(11245L, ADMIN_USER, 0, 10);
        ((CrowdinConsumerStorage)Mockito.verify((Object)this.crowdinConsumerStorage, (VerificationMode)Mockito.times((int)1))).getProjectDirectories(11245L, 0, 10, "accessToken");
    }
}

