/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.evm.gamification.plugin;

import io.meeds.evm.gamification.utils.Utils;
import io.meeds.gamification.model.RealizationDTO;
import io.meeds.gamification.plugin.EventPlugin;
import io.meeds.gamification.service.EventService;
import jakarta.annotation.PostConstruct;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.listener.ListenerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EvmEventPlugin
extends EventPlugin {
    public static final String EVENT_TYPE = "evm";
    @Autowired
    private EventService eventService;
    @Autowired
    ListenerService listenerService;

    @PostConstruct
    public void init() {
        this.eventService.addPlugin((EventPlugin)this);
    }

    public String getEventType() {
        return EVENT_TYPE;
    }

    public List<String> getTriggers() {
        return List.of("sendToken", "receiveToken", "holdToken");
    }

    public boolean isValidEvent(Map<String, String> eventProperties, String triggerDetails) {
        String desiredContractAddress = eventProperties.get("contractAddress").toLowerCase();
        String desiredTargetAddress = eventProperties.get("targetAddress");
        String minAmount = eventProperties.get("minAmount");
        String desiredNetwork = eventProperties.get("blockchainNetwork");
        String tokenDecimals = eventProperties.get("tokenDecimals");
        Map<String, String> triggerDetailsMop = Utils.stringToMap(triggerDetails);
        Long sentDate = Long.parseLong(triggerDetailsMop.get("sentDate"));
        if (!desiredNetwork.equals(triggerDetailsMop.get("blockchainNetwork")) || !desiredContractAddress.equals(triggerDetailsMop.get("contractAddress").toLowerCase())) {
            return false;
        }
        boolean isValidFilters = true;
        if (StringUtils.isNotBlank((CharSequence)desiredTargetAddress)) {
            boolean bl = isValidFilters = isValidFilters && this.isValidTargetAddress(desiredTargetAddress, triggerDetailsMop.get("targetAddress"));
        }
        if (StringUtils.isNotBlank((CharSequence)eventProperties.get("duration"))) {
            isValidFilters = isValidFilters && this.isValidAmountAndDuration(new BigInteger(triggerDetailsMop.get("tokenBalance")), minAmount, tokenDecimals, sentDate, Long.parseLong(eventProperties.get("duration")), Long.parseLong(triggerDetailsMop.get("duration")));
        } else if (StringUtils.isNotBlank((CharSequence)minAmount) && StringUtils.isNotBlank((CharSequence)tokenDecimals)) {
            isValidFilters = this.isValidMinAmount(minAmount, new BigInteger(triggerDetailsMop.get("minAmount")), tokenDecimals);
        }
        return isValidFilters;
    }

    public String getLink(RealizationDTO realization) {
        if (StringUtils.isNotBlank((CharSequence)realization.getObjectId())) {
            String transactionHash;
            String[] transactionDetails = realization.getObjectId().split("#");
            int networkId = Integer.parseInt(transactionDetails[0]);
            String string = transactionHash = transactionDetails.length > 1 ? transactionDetails[1] : "";
            if (transactionHash.isEmpty()) {
                return "";
            }
            return switch (networkId) {
                case 1 -> "https://etherscan.io/tx/" + transactionHash;
                case 137 -> "https://polygonscan.com/tx/" + transactionHash;
                case 80002 -> "https://amoy.polygonscan.com/tx/" + transactionHash;
                case 11155111 -> "https://sepolia.etherscan.io/tx/" + transactionHash;
                default -> "";
            };
        }
        return "";
    }

    private boolean isValidMinAmount(String minAmount, BigInteger amountTransferred, String tokenDecimals) {
        BigInteger base = new BigInteger("10");
        BigInteger desiredMinAmount = new BigInteger(minAmount);
        if (StringUtils.isNotBlank((CharSequence)tokenDecimals)) {
            Integer decimals = Integer.parseInt(tokenDecimals);
            desiredMinAmount = base.pow(decimals).multiply(new BigInteger(minAmount));
        }
        return amountTransferred.compareTo(desiredMinAmount) >= 0;
    }

    private boolean isValidTargetAddress(String desiredTargetAddress, String targetAddress) {
        return desiredTargetAddress.toLowerCase().equals(targetAddress.toLowerCase());
    }

    private boolean isValidAmountAndDuration(BigInteger tokenBalance, String minAmount, String tokenDecimals, Long sentDate, Long duration, Long desiredDuration) {
        if (duration.compareTo(desiredDuration) != 0) {
            return false;
        }
        Long holdingDuration = System.currentTimeMillis() - sentDate;
        BigInteger base = new BigInteger("10");
        BigInteger desiredMinAmount = new BigInteger(minAmount);
        if (StringUtils.isNotBlank((CharSequence)tokenDecimals)) {
            Integer decimals = Integer.parseInt(tokenDecimals);
            desiredMinAmount = base.pow(decimals).multiply(new BigInteger(minAmount));
        }
        return tokenBalance.compareTo(desiredMinAmount) >= 0 && holdingDuration.compareTo(duration) >= 0;
    }
}

