/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.evm.gamification.service;

import io.meeds.evm.gamification.model.EvmTransaction;
import io.meeds.evm.gamification.model.EvmTrigger;
import io.meeds.evm.gamification.service.EvmBlockchainService;
import io.meeds.evm.gamification.service.EvmTransactionService;
import io.meeds.evm.gamification.service.EvmTriggerService;
import io.meeds.evm.gamification.utils.Utils;
import io.meeds.gamification.constant.DateFilterType;
import io.meeds.gamification.constant.EntityStatusType;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.model.filter.RuleFilter;
import io.meeds.gamification.service.RuleService;
import io.meeds.wallet.service.WalletAccountService;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.web3j.abi.datatypes.Event;

@Service
public class EvmContractTransferService {
    private static final Log LOG = ExoLogger.getLogger(EvmContractTransferService.class);
    private static final Scope SETTING_SCOPE = Scope.APPLICATION.id("GAMIFICATION_EVM_HOLD_EVENT");
    private static final Context SETTING_CONTEXT = Context.GLOBAL.id("GAMIFICATION_EVM_HOLD_EVENT");
    private static final String SETTING_LAST_TIME_CHECK_KEY = "lastRewardTimeCheck";
    @Autowired
    private EvmTransactionService evmTransactionService;
    @Autowired
    private EvmTriggerService evmTriggerService;
    @Autowired
    private EvmBlockchainService evmBlockchainService;
    @Autowired
    private RuleService ruleService;
    @Autowired
    private WalletAccountService walletAccountService;
    @Autowired
    private SettingService settingService;

    public void scanForContractTransactions(RuleDTO rule) {
        String trigger = rule.getEvent().getTrigger();
        String blockchainNetwork = (String)rule.getEvent().getProperties().get("blockchainNetwork");
        String contractAddress = ((String)rule.getEvent().getProperties().get("contractAddress")).toLowerCase();
        long networkId = Long.parseLong((String)rule.getEvent().getProperties().get("networkId"));
        List<String> walletsAddresses = this.evmTriggerService.getWalletAddresses(rule.getProgram().getSpaceId());
        if (CollectionUtils.isNotEmpty(walletsAddresses)) {
            walletsAddresses.forEach(walletAddress -> {
                Event event = Utils.TRANSFER_EVENT_ERC20;
                if (this.evmBlockchainService.isERC1155(blockchainNetwork, contractAddress)) {
                    event = Utils.TRANSFERSINGLE_EVENT;
                } else if (this.evmBlockchainService.isERC721(blockchainNetwork, contractAddress)) {
                    event = Utils.TRANSFER_EVENT_ER721;
                }
                long lastRewardTime = this.getLastRewardTime((String)walletAddress, rule.getId());
                List<EvmTransaction> transactions = this.evmTransactionService.getFilteredTransactionsByWalletAddress(contractAddress, networkId, (String)walletAddress, Utils.convertDateStringToTimestamp(rule.getCreatedDate()), lastRewardTime, trigger);
                if (trigger.equals("holdToken")) {
                    long duration = Long.parseLong((String)rule.getEvent().getProperties().get("duration"));
                    if (System.currentTimeMillis() - lastRewardTime >= duration) {
                        this.handleHoldEvent(blockchainNetwork, contractAddress, (String)walletAddress, networkId, duration, rule, event, trigger, transactions);
                    }
                } else if (CollectionUtils.isNotEmpty(transactions)) {
                    transactions.forEach(transaction -> {
                        try {
                            this.handleEvmTrigger(rule, (EvmTransaction)transaction, trigger, contractAddress, networkId, blockchainNetwork, (String)walletAddress);
                        }
                        catch (Exception e) {
                            LOG.warn("Error broadcasting EVM event for transaction {} and trigger {}", new Object[]{transaction.getTransactionHash(), trigger, e});
                        }
                    });
                }
            });
        }
    }

    public void handleWithEvmTansactions(String blockchainNetwork, String contractAddress, String walletAddress, Long networkId, Event event, long fromBlock, long toBlock, long duration, List<EvmTransaction> evmTransactions, List<EvmTransaction> toAddressEvmTransactions, RuleDTO rule, String trigger) {
        List fromAddressEvmTransactions;
        if (evmTransactions.isEmpty()) {
            evmTransactions = this.evmBlockchainService.getEvmTransactions(fromBlock, toBlock, contractAddress, blockchainNetwork, event);
            toAddressEvmTransactions = evmTransactions.stream().filter(transaction -> StringUtils.equals((CharSequence)transaction.getToAddress(), (CharSequence)walletAddress)).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(fromAddressEvmTransactions = evmTransactions.stream().filter(transaction -> StringUtils.equals((CharSequence)transaction.getFromAddress(), (CharSequence)walletAddress)).collect(Collectors.toList()))) {
            if (this.evmBlockchainService.isERC1155(blockchainNetwork, contractAddress)) {
                ArrayList tokenIds = new ArrayList();
                toAddressEvmTransactions.forEach(toAddressTransaction -> {
                    if (!tokenIds.contains(toAddressTransaction.getTokenId().toString())) {
                        EvmTransaction transaction = new EvmTransaction();
                        tokenIds.add(toAddressTransaction.getTokenId().toString());
                        transaction.setTransactionHash("");
                        transaction.setAmount(new BigInteger((String)rule.getEvent().getProperties().get("minAmount")));
                        transaction.setToAddress(walletAddress);
                        transaction.setTransactionDate(System.currentTimeMillis() - duration);
                        transaction.setTokenId(toAddressTransaction.getTokenId());
                        transaction.setNetworkId(networkId);
                        transaction.setContractAddress(contractAddress);
                        this.handleTriggerForHoldEvent(rule, transaction, walletAddress);
                    }
                });
            } else {
                EvmTransaction transaction2 = new EvmTransaction();
                transaction2.setTransactionHash("");
                transaction2.setAmount(new BigInteger((String)rule.getEvent().getProperties().get("minAmount")));
                transaction2.setToAddress(walletAddress);
                transaction2.setTransactionDate(System.currentTimeMillis() - duration);
                transaction2.setNetworkId(networkId);
                transaction2.setContractAddress(contractAddress);
                this.handleTriggerForHoldEvent(rule, transaction2, walletAddress);
            }
        } else if (this.evmBlockchainService.isERC1155(blockchainNetwork, contractAddress)) {
            ArrayList tokenIds = new ArrayList();
            evmTransactions.forEach(transaction -> {
                if (!tokenIds.contains(transaction.getTokenId().toString())) {
                    tokenIds.add(transaction.getTokenId().toString());
                    transaction.setNetworkId(networkId);
                    transaction.setContractAddress(contractAddress);
                    transaction.setTransactionDate(System.currentTimeMillis());
                    this.handleEvmTrigger(rule, (EvmTransaction)transaction, trigger, contractAddress, networkId, blockchainNetwork, walletAddress);
                }
            });
        } else {
            this.handleEvmTrigger(rule, evmTransactions.get(evmTransactions.size() - 1), trigger, contractAddress, networkId, blockchainNetwork, walletAddress);
        }
    }

    public void handleHoldEvent(String blockchainNetwork, String contractAddress, String walletAddress, long networkId, long duration, RuleDTO rule, Event event, String trigger, List<EvmTransaction> transactions) {
        List<EvmTransaction> toAddressEvmTransactions;
        boolean isBalanceOfEnough;
        long toBlock = this.evmBlockchainService.getLastBlock(blockchainNetwork);
        long fromBlock = toBlock - duration / 1000L / (long)Utils.BLOCK_TIME_AVERAGE.intValue();
        ArrayList<EvmTransaction> evmTransactions = new ArrayList();
        this.saveLastRewardTime(walletAddress, rule.getId());
        if (this.evmBlockchainService.isERC1155(blockchainNetwork, contractAddress)) {
            evmTransactions = this.evmBlockchainService.getEvmTransactions(fromBlock, toBlock, contractAddress, blockchainNetwork, event);
        }
        if (isBalanceOfEnough = this.evmBlockchainService.isBalanceEnough(contractAddress, blockchainNetwork, walletAddress, rule, toAddressEvmTransactions = evmTransactions.stream().filter(transaction -> StringUtils.equals((CharSequence)transaction.getToAddress(), (CharSequence)walletAddress)).collect(Collectors.toList()))) {
            if (CollectionUtils.isEmpty(transactions)) {
                this.handleWithEvmTansactions(blockchainNetwork, contractAddress, walletAddress, networkId, event, fromBlock, toBlock, duration, evmTransactions, toAddressEvmTransactions, rule, trigger);
            } else {
                this.handleEvmTrigger(rule, transactions.get(transactions.size() - 1), trigger, contractAddress, networkId, blockchainNetwork, walletAddress);
            }
        }
    }

    public List<RuleDTO> getEnabledEvmRules() {
        RuleFilter ruleFilter = new RuleFilter(true);
        ruleFilter.setEventType("evm");
        ruleFilter.setStatus(EntityStatusType.ENABLED);
        ruleFilter.setProgramStatus(EntityStatusType.ENABLED);
        ruleFilter.setDateFilterType(DateFilterType.STARTED);
        List rules = this.ruleService.getRules(ruleFilter, 0, -1);
        return rules.stream().filter(r -> !r.getEvent().getProperties().isEmpty() && StringUtils.isNotBlank((CharSequence)((CharSequence)r.getEvent().getProperties().get("contractAddress")))).toList();
    }

    public List<RuleDTO> getEvmRules() {
        RuleFilter ruleFilter = new RuleFilter(true);
        ruleFilter.setEventType("evm");
        ruleFilter.setDateFilterType(DateFilterType.STARTED);
        List rules = this.ruleService.getRules(ruleFilter, 0, -1);
        return rules.stream().filter(r -> !r.getEvent().getProperties().isEmpty() && StringUtils.isNotBlank((CharSequence)((CharSequence)r.getEvent().getProperties().get("contractAddress")))).toList();
    }

    public List<RuleDTO> getEnabledHoldEventEvmRules() {
        RuleFilter ruleFilter = new RuleFilter(true);
        ruleFilter.setEventType("evm");
        ruleFilter.setStatus(EntityStatusType.ENABLED);
        ruleFilter.setProgramStatus(EntityStatusType.ENABLED);
        ruleFilter.setDateFilterType(DateFilterType.STARTED);
        List rules = this.ruleService.getRules(ruleFilter, 0, -1);
        return rules.stream().filter(r -> !r.getEvent().getProperties().isEmpty() && StringUtils.isNotBlank((CharSequence)((CharSequence)r.getEvent().getProperties().get("contractAddress"))) && r.getEvent().getTrigger().equals("holdToken")).toList();
    }

    public void handleTriggerForHoldEvent(RuleDTO rule, EvmTransaction transaction, String walletAddress) {
        Long duration = Long.parseLong((String)rule.getEvent().getProperties().get("duration"));
        String trigger = rule.getEvent().getTrigger();
        String contractAddress = (String)rule.getEvent().getProperties().get("contractAddress");
        String blockchainNetwork = (String)rule.getEvent().getProperties().get("blockchainNetwork");
        Long networkId = Long.parseLong((String)rule.getEvent().getProperties().get("networkId"));
        EvmTrigger evmTrigger = this.newEvmTrigger(transaction, trigger, contractAddress, blockchainNetwork, networkId, duration, walletAddress, null);
        this.evmTriggerService.handleTriggerAsync(evmTrigger);
    }

    private void handleEvmTrigger(RuleDTO rule, EvmTransaction transaction, String trigger, String contractAddress, Long networkId, String blockchainNetwork, String walletAddress) {
        Boolean isSendTokenEvent = trigger.equals("sendToken");
        Boolean isReceiveTokenEvent = trigger.equals("receiveToken");
        if (isSendTokenEvent.booleanValue() || isReceiveTokenEvent.booleanValue()) {
            EvmTrigger evmTrigger = isSendTokenEvent != false ? this.newEvmTrigger(transaction, trigger, contractAddress, blockchainNetwork, networkId, null, transaction.getFromAddress(), transaction.getToAddress()) : this.newEvmTrigger(transaction, trigger, contractAddress, blockchainNetwork, networkId, null, transaction.getToAddress(), transaction.getFromAddress());
            this.evmTriggerService.handleTriggerAsync(evmTrigger);
            this.saveLastRewardTime(walletAddress, rule.getId());
        }
        if (trigger.equals("holdToken") && Utils.isValidDurationHoldingToken(transaction, Long.parseLong((String)rule.getEvent().getProperties().get("duration"))).booleanValue()) {
            this.handleTriggerForHoldEvent(rule, transaction, walletAddress);
        }
    }

    private EvmTrigger newEvmTrigger(EvmTransaction transaction, String trigger, String contractAddress, String blockchainNetwork, Long networkId, Long duration, String walletAddress, String targetAddress) {
        EvmTrigger evmTrigger = new EvmTrigger();
        HashMap<String, String> funcParams = new HashMap<String, String>();
        evmTrigger.setTrigger(trigger);
        evmTrigger.setType("evm");
        evmTrigger.setTransactionHash(transaction.getTransactionHash());
        evmTrigger.setContractAddress(contractAddress);
        evmTrigger.setBlockchainNetwork(blockchainNetwork);
        evmTrigger.setAmount(transaction.getAmount());
        evmTrigger.setNetworkId(networkId.toString());
        evmTrigger.setSentDate(transaction.getTransactionDate());
        evmTrigger.setDuration(duration);
        evmTrigger.setWalletAddress(walletAddress);
        evmTrigger.setTargetAddress(targetAddress);
        funcParams.put("owner", walletAddress);
        if (trigger.equals("holdToken") && transaction.getTokenId() != null) {
            funcParams.put("tokenId", transaction.getTokenId().toString());
        }
        evmTrigger.setTokenBalance(this.evmBlockchainService.balanceOf(contractAddress, blockchainNetwork, funcParams));
        return evmTrigger;
    }

    public long getLastRewardTime(String walletAddress, Long ruleId) {
        long lastRewardTime = 0L;
        SettingValue settingValue = this.settingService.get(SETTING_CONTEXT, SETTING_SCOPE, SETTING_LAST_TIME_CHECK_KEY + ruleId.toString() + "#" + walletAddress.toLowerCase());
        if (settingValue != null && settingValue.getValue() != null) {
            lastRewardTime = Long.parseLong(settingValue.getValue().toString());
        }
        return lastRewardTime;
    }

    public void saveLastRewardTime(String walletAddress, Long ruleId) {
        this.settingService.set(SETTING_CONTEXT, SETTING_SCOPE, SETTING_LAST_TIME_CHECK_KEY + ruleId.toString() + "#" + walletAddress.toLowerCase(), SettingValue.create((Long)System.currentTimeMillis()));
    }
}

