/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.evm.gamification.service;

import io.meeds.evm.gamification.model.EvmTransaction;
import io.meeds.evm.gamification.storage.EvmTransactionStorage;
import io.meeds.evm.gamification.utils.Utils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EvmTransactionService {
    @Autowired
    private EvmTransactionStorage evmTransactionStorage;

    public void saveTransaction(EvmTransaction transaction) {
        this.evmTransactionStorage.saveEvmTransaction(transaction);
    }

    public List<String> getDistinctWalletAddresses(String contractAddress, String ruleCreationDate, Long networkId) {
        long convertedDate = Utils.convertDateStringToTimestamp(ruleCreationDate);
        return this.evmTransactionStorage.getDistinctWalletAddresses(contractAddress, convertedDate, networkId);
    }

    public List<EvmTransaction> getFilteredTransactionsByWalletAddress(String contractAddress, Long networkId, String walletAddress, Long creationActionTime, Long lastRewardTime, String trigger) {
        long lastTimeToCompare = creationActionTime.compareTo(lastRewardTime) >= 0 ? creationActionTime.longValue() : lastRewardTime.longValue();
        if (trigger.equals("receiveToken")) {
            return this.evmTransactionStorage.getToAddressFilteredTransactions(contractAddress, networkId, lastTimeToCompare, walletAddress);
        }
        if (trigger.equals("sendToken")) {
            return this.evmTransactionStorage.getFromAddressFilteredTransactions(contractAddress, networkId, lastTimeToCompare, walletAddress);
        }
        return this.evmTransactionStorage.getFromAddressFilteredTransactions(contractAddress, networkId, lastTimeToCompare, walletAddress);
    }

    public EvmTransaction getLastScannedTransactionByWalletAddress(String contractAddress, Long networkId, String walletAddress) {
        return this.evmTransactionStorage.getLastScannedTransactionByWalletAddress(contractAddress, networkId, walletAddress);
    }
}

