/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.evm.gamification.listener;

import io.meeds.evm.gamification.listener.WalletCheckForHoldEventListener$AjcClosure1;
import io.meeds.evm.gamification.model.EvmTransaction;
import io.meeds.evm.gamification.service.EvmBlockchainService;
import io.meeds.evm.gamification.service.EvmContractTransferService;
import io.meeds.evm.gamification.service.EvmTransactionService;
import io.meeds.evm.gamification.utils.Utils;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.wallet.model.Wallet;
import jakarta.annotation.PostConstruct;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WalletCheckForHoldEventListener
extends Listener<Wallet, String> {
    private static final List<String> SUPPORTED_EVENTS;
    @Autowired
    private ListenerService listenerService;
    @Autowired
    private EvmContractTransferService evmContractTransferService;
    @Autowired
    private EvmBlockchainService evmBlockchainService;
    @Autowired
    private EvmTransactionService evmTransactionService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @PostConstruct
    public void init() {
        for (String eventName : SUPPORTED_EVENTS) {
            this.listenerService.addListener(eventName, (ListenerBase)this);
        }
    }

    @ExoTransactional
    public void onEvent(Event<Wallet, String> event) {
        Event<Wallet, String> event2 = event;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), event2);
        Object[] objectArray = new Object[]{this, event2, joinPoint};
        WalletCheckForHoldEventListener$AjcClosure1 walletCheckForHoldEventListener$AjcClosure1 = new WalletCheckForHoldEventListener$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(walletCheckForHoldEventListener$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    static {
        WalletCheckForHoldEventListener.ajc$preClinit();
        SUPPORTED_EVENTS = Arrays.asList("exo.wallet.addressAssociation.new", "exo.wallet.addressAssociation.modification");
    }

    static final /* synthetic */ void onEvent_aroundBody0(WalletCheckForHoldEventListener ajc$this, Event event, JoinPoint joinPoint) {
        List<RuleDTO> holdEventEvmRules = ajc$this.evmContractTransferService.getEnabledHoldEventEvmRules();
        if (CollectionUtils.isNotEmpty(holdEventEvmRules)) {
            Wallet wallet = (Wallet)event.getSource();
            String walletAddress = wallet.getAddress();
            ArrayList rules = new ArrayList();
            holdEventEvmRules.forEach(holdEventEvmRule -> {
                boolean isRuleExists = false;
                if (rules != null) {
                    isRuleExists = rules.stream().anyMatch(rule -> ((String)rule.getEvent().getProperties().get("networkId")).compareTo((String)holdEventEvmRule.getEvent().getProperties().get("networkId")) == 0 && StringUtils.equals((CharSequence)((String)rule.getEvent().getProperties().get("contractAddress")).toLowerCase(), (CharSequence)((String)holdEventEvmRule.getEvent().getProperties().get("contractAddress")).toLowerCase()));
                }
                if (!isRuleExists) {
                    BigInteger minAmount = new BigInteger((String)holdEventEvmRule.getEvent().getProperties().get("minAmount"));
                    String trigger = holdEventEvmRule.getEvent().getTrigger();
                    String contractAddress = ((String)holdEventEvmRule.getEvent().getProperties().get("contractAddress")).toLowerCase();
                    String blockchainNetwork = (String)holdEventEvmRule.getEvent().getProperties().get("blockchainNetwork");
                    Long networkId = Long.parseLong((String)holdEventEvmRule.getEvent().getProperties().get("networkId"));
                    Long duration = Long.parseLong((String)holdEventEvmRule.getEvent().getProperties().get("duration"));
                    ArrayList<EvmTransaction> evmTransactions = new ArrayList();
                    org.web3j.abi.datatypes.Event blockchainEvent = Utils.TRANSFER_EVENT_ERC20;
                    long lastRewardTime = this.evmContractTransferService.getLastRewardTime(walletAddress, holdEventEvmRule.getId());
                    if (System.currentTimeMillis() - lastRewardTime >= duration) {
                        List<EvmTransaction> toAddressEvmTransactions;
                        boolean isBalanceOfEnough;
                        long toBlock = this.evmBlockchainService.getLastBlock(blockchainNetwork);
                        long fromBlock = toBlock - duration / 1000L / (long)Utils.BLOCK_TIME_AVERAGE.intValue();
                        this.evmContractTransferService.saveLastRewardTime(walletAddress, holdEventEvmRule.getId());
                        if (this.evmBlockchainService.isERC1155(blockchainNetwork, contractAddress)) {
                            blockchainEvent = Utils.TRANSFERSINGLE_EVENT;
                            evmTransactions = this.evmBlockchainService.getEvmTransactions(fromBlock, toBlock, contractAddress, blockchainNetwork, blockchainEvent);
                        }
                        if (isBalanceOfEnough = this.evmBlockchainService.isBalanceEnough(contractAddress, blockchainNetwork, walletAddress, (RuleDTO)holdEventEvmRule, toAddressEvmTransactions = evmTransactions.stream().filter(transaction -> StringUtils.equals((CharSequence)transaction.getToAddress(), (CharSequence)walletAddress)).collect(Collectors.toList()))) {
                            List<EvmTransaction> transactions = this.evmTransactionService.getFilteredTransactionsByWalletAddress(contractAddress, networkId, walletAddress, Utils.convertDateStringToTimestamp(holdEventEvmRule.getCreatedDate()), lastRewardTime, trigger);
                            if (CollectionUtils.isEmpty(transactions)) {
                                this.evmContractTransferService.handleWithEvmTansactions(blockchainNetwork, contractAddress, walletAddress, networkId, blockchainEvent, fromBlock, toBlock, duration, (List<EvmTransaction>)evmTransactions, toAddressEvmTransactions, (RuleDTO)holdEventEvmRule, trigger);
                                rules.add(holdEventEvmRule);
                            } else if (Utils.isValidDurationHoldingToken(transactions.get(transactions.size() - 1), duration).booleanValue()) {
                                this.evmContractTransferService.handleTriggerForHoldEvent((RuleDTO)holdEventEvmRule, transactions.get(transactions.size() - 1), walletAddress);
                                rules.add(holdEventEvmRule);
                            }
                        }
                    }
                }
            });
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WalletCheckForHoldEventListener.java", WalletCheckForHoldEventListener.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onEvent", "io.meeds.evm.gamification.listener.WalletCheckForHoldEventListener", "org.exoplatform.services.listener.Event", "event", "", "void"), 71);
    }
}

