/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.github.gamification.services.impl;

import io.meeds.gamification.model.filter.RuleFilter;
import io.meeds.gamification.service.RuleService;
import io.meeds.gamification.utils.Utils;
import io.meeds.github.gamification.model.RemoteOrganization;
import io.meeds.github.gamification.model.RemoteRepository;
import io.meeds.github.gamification.model.TokenStatus;
import io.meeds.github.gamification.model.WebHook;
import io.meeds.github.gamification.services.GithubConsumerService;
import io.meeds.github.gamification.services.WebhookService;
import io.meeds.github.gamification.storage.WebHookStorage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class WebhookServiceImpl
implements WebhookService {
    private static final Log LOG = ExoLogger.getLogger(WebhookServiceImpl.class);
    private static final Context GITHUB_WEBHOOK_CONTEXT = Context.GLOBAL.id("githubWebhook");
    private static final Scope WATCH_LIMITED_SCOPE = Scope.APPLICATION.id("watchLimited");
    private static final Scope DISABLED_REPOS_SCOPE = Scope.APPLICATION.id("disabledRepos");
    @Autowired
    private SettingService settingService;
    @Autowired
    private WebHookStorage webHookStorage;
    @Autowired
    private GithubConsumerService githubServiceConsumer;
    @Autowired
    private RuleService ruleService;

    @Override
    public Page<WebHook> getWebhooks(String currentUser, Pageable pageable) throws IllegalAccessException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to access gitHub Hooks");
        }
        return this.getWebhooks(pageable);
    }

    @Override
    public WebHook getWebhookId(long webhookId, String username) throws IllegalAccessException, ObjectNotFoundException {
        if (!Utils.isRewardingManager((String)username)) {
            throw new IllegalAccessException("The user is not authorized to access gitHub Hooks");
        }
        WebHook webHook = this.getWebhookId(webhookId);
        if (webHook == null) {
            throw new ObjectNotFoundException("Webhook doesn't exist");
        }
        return webHook;
    }

    @Override
    public WebHook getWebhookId(long webhookId) {
        if (webhookId <= 0L) {
            throw new IllegalArgumentException("Webhook id is mandatory");
        }
        return this.webHookStorage.getWebHookById(webhookId);
    }

    public Page<WebHook> getWebhooks(Pageable pageable) {
        return this.webHookStorage.getWebhooks(pageable);
    }

    @Override
    public WebHook createWebhook(String organizationName, String accessToken, String currentUser) throws ObjectAlreadyExistsException, IllegalAccessException, ObjectNotFoundException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to create GitHub hook");
        }
        TokenStatus tokenStatus = this.githubServiceConsumer.checkGitHubTokenStatus(accessToken);
        if (!tokenStatus.isValid()) {
            throw new IllegalAccessException("github.tokenExpiredOrInvalid");
        }
        if (tokenStatus.getRemaining() == 0L) {
            throw new IllegalAccessException("github.tokenRateLimitReached");
        }
        RemoteOrganization remoteOrganization = this.githubServiceConsumer.retrieveRemoteOrganization(organizationName, accessToken);
        WebHook existsWebHook = this.webHookStorage.getWebhookByOrganizationId(remoteOrganization.getId());
        if (existsWebHook != null) {
            throw new ObjectAlreadyExistsException((Object)existsWebHook);
        }
        WebHook webHook = this.githubServiceConsumer.createWebhook(organizationName, io.meeds.github.gamification.utils.Utils.GITHUB_TRIGGERS, accessToken);
        if (webHook != null) {
            webHook.setOrganizationId(remoteOrganization.getId());
            webHook.setWatchedBy(currentUser);
            return this.webHookStorage.saveWebHook(webHook);
        }
        return null;
    }

    @Override
    public void updateWebHookAccessToken(long webHookId, String accessToken, String currentUser) throws IllegalAccessException, ObjectNotFoundException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to access gitHub Hooks");
        }
        if (webHookId <= 0L) {
            throw new IllegalArgumentException("webHook id must be positive");
        }
        WebHook webHook = this.webHookStorage.getWebHookById(webHookId);
        if (webHook == null) {
            throw new ObjectNotFoundException("webhook with id : " + webHookId + " wasn't found");
        }
        this.webHookStorage.updateWebHookAccessToken(webHookId, io.meeds.github.gamification.utils.Utils.encode(accessToken));
    }

    @Override
    public void deleteWebhook(long organizationId, String currentUser) throws IllegalAccessException, ObjectNotFoundException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to delete GitHub hook");
        }
        WebHook webHook = this.webHookStorage.getWebhookByOrganizationId(organizationId);
        if (webHook == null) {
            throw new ObjectNotFoundException("Github hook for organization id : " + organizationId + " wasn't found");
        }
        String response = this.githubServiceConsumer.deleteWebhook(webHook);
        if (response != null) {
            this.deleteWebhook(organizationId);
        }
    }

    public void deleteWebhook(long organizationId) {
        this.webHookStorage.deleteWebHook(organizationId);
        RuleFilter ruleFilter = new RuleFilter(true);
        ruleFilter.setEventType("github");
        ruleFilter.setIncludeDeleted(true);
        List rules = this.ruleService.getRules(ruleFilter, 0, -1);
        rules.stream().filter(r -> !r.getEvent().getProperties().isEmpty() && ((String)r.getEvent().getProperties().get("organizationId")).equals(String.valueOf(organizationId))).forEach(rule -> {
            try {
                rule.setEnabled(false);
                this.ruleService.updateRule(rule);
            }
            catch (ObjectNotFoundException e) {
                LOG.warn("Error while automatically switching rule status. Rule = {} ", new Object[]{rule, e});
            }
        });
    }

    @Override
    public boolean verifyWebhookSecret(String payload, String signature) {
        JSONObject jsonPayload = new JSONObject(payload);
        JSONObject organization = jsonPayload.getJSONObject("organization");
        long organizationId = organization.getLong("id");
        WebHook webHook = this.webHookStorage.getWebhookByOrganizationId(organizationId);
        if (webHook != null) {
            return io.meeds.github.gamification.utils.Utils.verifySignature(webHook.getSecret(), payload, signature);
        }
        return false;
    }

    @Override
    public boolean isWebHookRepositoryEnabled(String payload) {
        Map<String, Object> payloadMap = io.meeds.github.gamification.utils.Utils.fromJsonStringToMap(payload);
        String organizationId = io.meeds.github.gamification.utils.Utils.extractSubItem(payloadMap, "organization", "id");
        String repositoryId = io.meeds.github.gamification.utils.Utils.extractSubItem(payloadMap, "repository", "id");
        if (organizationId != null && repositoryId != null) {
            return this.isWebHookRepositoryEnabled(Long.parseLong(organizationId), Long.parseLong(repositoryId));
        }
        return true;
    }

    @Override
    public boolean isWebHookRepositoryEnabled(long organizationId, long repositoryId) {
        List<Object> disabledRepositoryList = new ArrayList();
        SettingValue settingValue = this.settingService.get(GITHUB_WEBHOOK_CONTEXT, DISABLED_REPOS_SCOPE, String.valueOf(organizationId));
        if (settingValue != null && settingValue.getValue() != null && StringUtils.isNotBlank((CharSequence)settingValue.getValue().toString())) {
            disabledRepositoryList = Arrays.stream(settingValue.getValue().toString().split(":")).map(Long::parseLong).toList();
        }
        return !disabledRepositoryList.contains(repositoryId);
    }

    @Override
    public void setWebHookRepositoryEnabled(long organizationId, long repositoryId, boolean enabled, String currentUser) throws IllegalAccessException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to update repository status");
        }
        List<Long> disabledRepositoryList = new ArrayList<Long>();
        SettingValue settingValue = this.settingService.get(GITHUB_WEBHOOK_CONTEXT, DISABLED_REPOS_SCOPE, String.valueOf(organizationId));
        if (settingValue != null && settingValue.getValue() != null && StringUtils.isNotBlank((CharSequence)settingValue.getValue().toString())) {
            disabledRepositoryList = Arrays.stream(settingValue.getValue().toString().split(":")).map(Long::parseLong).collect(Collectors.toList());
        }
        if (!enabled) {
            if (!disabledRepositoryList.contains(repositoryId)) {
                disabledRepositoryList.add(repositoryId);
            }
        } else {
            disabledRepositoryList.remove(repositoryId);
        }
        String disabledRepositories = disabledRepositoryList.stream().map(String::valueOf).collect(Collectors.joining(":"));
        this.settingService.set(GITHUB_WEBHOOK_CONTEXT, DISABLED_REPOS_SCOPE, String.valueOf(organizationId), SettingValue.create((String)disabledRepositories));
    }

    @Override
    public boolean isWebHookWatchLimitEnabled(long organizationId) {
        SettingValue settingValue = this.settingService.get(GITHUB_WEBHOOK_CONTEXT, WATCH_LIMITED_SCOPE, String.valueOf(organizationId));
        if (settingValue != null && settingValue.getValue() != null && StringUtils.isNotBlank((CharSequence)settingValue.getValue().toString())) {
            return Boolean.parseBoolean(settingValue.getValue().toString());
        }
        return true;
    }

    @Override
    public List<RemoteRepository> retrieveOrganizationRepos(long organizationRemoteId, String currentUser, int page, int perPage, String keyword) throws IllegalAccessException, ObjectNotFoundException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to access organization repositories");
        }
        WebHook webHook = this.webHookStorage.getWebhookByOrganizationId(organizationRemoteId);
        if (webHook == null) {
            throw new ObjectNotFoundException("webhook with organization id '" + organizationRemoteId + "' doesn't exist");
        }
        List<RemoteRepository> remoteRepositories = this.githubServiceConsumer.retrieveOrganizationRepos(webHook, page, perPage, keyword);
        remoteRepositories.forEach(remoteRepository -> remoteRepository.setEnabled(this.isWebHookRepositoryEnabled(webHook.getOrganizationId(), remoteRepository.getId())));
        return remoteRepositories;
    }

    @Override
    public void forceUpdateWebhooks() {
        List<WebHook> webHook = this.webHookStorage.getWebhooks();
        webHook.forEach(this::forceUpdateWebhook);
    }

    private void forceUpdateWebhook(WebHook webHook) {
        TokenStatus tokenStatus = this.githubServiceConsumer.checkGitHubTokenStatus(webHook.getToken());
        if (!tokenStatus.isValid() || tokenStatus.getRemaining() == 0L) {
            return;
        }
        String response = this.githubServiceConsumer.forceUpdateWebhook(webHook);
        if (response == null) {
            this.webHookStorage.deleteWebHook(webHook.getOrganizationId());
        } else {
            Map<String, Object> resultMap = io.meeds.github.gamification.utils.Utils.fromJsonStringToMap(response);
            List events = (List)resultMap.get("events");
            if (!CollectionUtils.isEqualCollection((Collection)events, webHook.getTriggers())) {
                webHook.setTriggers(events);
                this.webHookStorage.updateWebHook(webHook, true);
            }
        }
    }
}

