/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.github.gamification.plugin;

import io.meeds.github.gamification.model.Event;
import io.meeds.github.gamification.plugin.GithubTriggerPlugin;
import io.meeds.github.gamification.services.GithubTriggerService;
import io.meeds.github.gamification.utils.Utils;
import jakarta.annotation.PostConstruct;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssueTriggerPlugin
extends GithubTriggerPlugin {
    private static final String NAME = "issues";
    @Autowired
    private GithubTriggerService githubTriggerService;

    @PostConstruct
    public void init() {
        this.githubTriggerService.addPlugin(this);
    }

    public String getName() {
        return NAME;
    }

    @Override
    public List<Event> getEvents(Map<String, Object> payload) {
        String issueState = Utils.extractSubItem(payload, "action");
        Object objectId = Utils.extractSubItem(payload, "issue", "html_url");
        String userId = Utils.extractSubItem(payload, "sender", "login");
        if (Objects.equals(issueState, "opened")) {
            return Collections.singletonList(new Event("createIssue", userId, userId, (String)objectId, "githubIssue", Utils.extractSubItem(payload, "organization", "id"), Utils.extractSubItem(payload, "repository", "id")));
        }
        if (Objects.equals(issueState, "closed")) {
            if (Objects.equals(Utils.extractSubItem(payload, "issue", "state_reason"), "not_planned")) {
                return Collections.singletonList(new Event("closeIssue", userId, userId, (String)objectId, "githubIssue", Utils.extractSubItem(payload, "organization", "id"), Utils.extractSubItem(payload, "repository", "id")));
            }
            return Collections.emptyList();
        }
        if (Objects.equals(issueState, "labeled")) {
            objectId = (String)objectId + "?label=" + Utils.extractSubItem(payload, "label", "name");
            return Collections.singletonList(new Event("addIssueLabel", userId, userId, (String)objectId, "githubIssue", Utils.extractSubItem(payload, "organization", "id"), Utils.extractSubItem(payload, "repository", "id")));
        }
        if (Objects.equals(issueState, "unlabeled")) {
            objectId = (String)objectId + "?label=" + Utils.extractSubItem(payload, "label", "name");
            return Collections.singletonList(new Event("deleteIssueLabel", userId, userId, (String)objectId, "githubIssue", Utils.extractSubItem(payload, "organization", "id"), Utils.extractSubItem(payload, "repository", "id")));
        }
        return Collections.emptyList();
    }
}

