/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.github.gamification.plugin;

import io.meeds.github.gamification.model.Event;
import io.meeds.github.gamification.plugin.GithubTriggerPlugin;
import io.meeds.github.gamification.services.GithubTriggerService;
import io.meeds.github.gamification.utils.Utils;
import jakarta.annotation.PostConstruct;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommentPullRequestTriggerPlugin
extends GithubTriggerPlugin {
    private static final String NAME = "pull_request_review_comment";
    @Autowired
    private GithubTriggerService githubTriggerService;

    @PostConstruct
    public void init() {
        this.githubTriggerService.addPlugin(this);
    }

    public String getName() {
        return NAME;
    }

    @Override
    public List<Event> getEvents(Map<String, Object> payload) {
        return Collections.singletonList(new Event("pullRequestReviewComment", null, Utils.extractSubItem(payload, "comment", "user", "login"), Utils.extractSubItem(payload, "comment", "_links", "html", "href"), "githubReviewComment", Utils.extractSubItem(payload, "organization", "id"), Utils.extractSubItem(payload, "repository", "id")));
    }
}

