/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.github.gamification.plugin;

import io.meeds.github.gamification.plugin.GithubEventPlugin;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.boot.test.context.SpringBootTest;

@SpringBootTest(classes={GithubEventPlugin.class})
public class GithubEventPluginTest {
    @Test
    public void testIsValidEvent() {
        GithubEventPlugin githubEventPlugin = new GithubEventPlugin();
        Assert.assertEquals((Object)"github", (Object)githubEventPlugin.getEventType());
        Assert.assertEquals(List.of("addIssueLabel", "pushCode", "pullRequestValidated", "reviewPullRequest", "validatePullRequest", "creatPullRequest", "pullRequestReviewComment", "commentPullRequest", "createIssue", "addIssueLabel", "requestReviewForPullRequest", "commentIssue"), (Object)githubEventPlugin.getTriggers());
        HashMap<String, String> eventProperties = new HashMap<String, String>();
        eventProperties.put("organizationId", "132452");
        eventProperties.put("repositoryIds", "1115454,2225454");
        Assert.assertFalse((boolean)githubEventPlugin.isValidEvent(eventProperties, "{organizationId: 132452, repositoryId: 221545}"));
        Assert.assertFalse((boolean)githubEventPlugin.isValidEvent(eventProperties, "{organizationId: 132453, repositoryId: 221545}"));
        Assert.assertTrue((boolean)githubEventPlugin.isValidEvent(eventProperties, "{organizationId: 132452, repositoryId: 2225454}"));
        Assert.assertTrue((boolean)githubEventPlugin.isValidEvent(eventProperties, "{organizationId: 132452, repositoryId: 1115454}"));
    }
}

