/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.github.gamification.listener;

import io.meeds.github.gamification.listener.GithubEventsListener;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerService;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={GithubEventsListener.class})
class GithubEventsListenerTest {
    @MockBean
    private ListenerService listenerService;
    @MockBean
    private Event<Map<String, String>, String> event;
    @Autowired
    private GithubEventsListener githubEventsListener;

    GithubEventsListenerTest() {
    }

    @Test
    void createEvent() {
        HashMap<String, String> source = new HashMap<String, String>();
        source.put("objectId", "objectId");
        source.put("objectType", "objectType");
        source.put("ruleTitle", "ruleTitle");
        source.put("senderId", "senderId");
        source.put("receiverId", "receiverId");
        source.put("eventDetails", "eventDetails");
        Mockito.when((Object)((Map)this.event.getSource())).thenReturn(source);
        Mockito.when((Object)this.event.getEventName()).thenReturn((Object)"github.action.event");
        this.githubEventsListener.onEvent(this.event);
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast("exo.gamification.generic.action", source, (Object)"");
        Mockito.when((Object)this.event.getEventName()).thenReturn((Object)"github.cancel.action.event");
        this.githubEventsListener.onEvent(this.event);
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast("gamification.cancel.event.action", source, (Object)"");
    }
}

