/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.github.gamification.storage;

import io.meeds.github.gamification.dao.WebHookDAO;
import io.meeds.github.gamification.entity.WebhookEntity;
import io.meeds.github.gamification.model.WebHook;
import io.meeds.github.gamification.storage.WebHookStorage;
import java.util.List;
import java.util.Optional;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.web.security.codec.CodecInitializer;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

@SpringBootTest(classes={WebHookStorage.class})
@ExtendWith(value={MockitoExtension.class})
class WebHookStorageTest {
    private static final Long ID = 2L;
    private static final Long ORGANIZATION_ID = 1232L;
    private static final Pageable PAGEABLE = Pageable.ofSize((int)2);
    @Autowired
    private WebHookStorage webHookStorage;
    @MockBean
    private WebHookDAO webHookDAO;
    @MockBean
    private SettingService settingService;
    @MockBean
    private CodecInitializer codecInitializer;

    WebHookStorageTest() {
    }

    @BeforeEach
    void setup() {
        Mockito.when((Object)this.webHookDAO.save((Object)((WebhookEntity)Mockito.any()))).thenAnswer(invocation -> {
            WebhookEntity entity = (WebhookEntity)invocation.getArgument(0);
            if (entity.getId() == null) {
                entity.setId(ID);
            }
            Mockito.when((Object)this.webHookDAO.findById((Object)ID)).thenReturn(Optional.of(entity));
            Mockito.when((Object)this.webHookDAO.findWebhookEntityByOrganizationId(ORGANIZATION_ID.longValue())).thenReturn((Object)entity);
            Mockito.when((Object)this.webHookDAO.findAll(PAGEABLE)).thenReturn((Object)new PageImpl(List.of(entity)));
            Mockito.when((Object)this.webHookDAO.count()).thenReturn((Object)1L);
            return entity;
        });
        ((WebHookDAO)Mockito.doAnswer(invocation -> {
            WebhookEntity entity = (WebhookEntity)invocation.getArgument(0);
            Mockito.when((Object)this.webHookDAO.findById((Object)entity.getId())).thenReturn(Optional.empty());
            return null;
        }).when((Object)this.webHookDAO)).delete((Object)((WebhookEntity)Mockito.any()));
    }

    @Test
    void testAddWebHook() throws Exception {
        WebHook webHook = this.createWebHookInstance();
        WebHook createdWebHook = this.webHookStorage.saveWebHook(webHook);
        Assertions.assertNotNull((Object)createdWebHook);
        Assertions.assertEquals((Object)createdWebHook.getEnabled(), (Object)webHook.getEnabled());
        Assertions.assertEquals((Object)createdWebHook.getOrganizationName(), (Object)webHook.getOrganizationName());
        Assertions.assertEquals((long)createdWebHook.getOrganizationId(), (long)webHook.getOrganizationId());
        Assert.assertThrows(ObjectAlreadyExistsException.class, () -> this.webHookStorage.saveWebHook(webHook));
    }

    @Test
    void testGetWebHooks() throws Exception {
        WebHook webHook = this.createWebHookInstance();
        WebHook createdWebHook = this.webHookStorage.saveWebHook(webHook);
        Assertions.assertNotNull((Object)createdWebHook);
        Assertions.assertEquals((Object)new PageImpl(List.of(createdWebHook)), (Object)this.webHookStorage.getWebhooks(PAGEABLE));
        Assertions.assertEquals((long)1L, (long)this.webHookStorage.countWebhooks());
    }

    protected WebHook createWebHookInstance() {
        return new WebHook(0L, 1234L, ORGANIZATION_ID.longValue(), "organizationName", List.of("trigger"), Boolean.valueOf(true), "watchedDate", null, "updatedDate", "refreshDate", "token", "secret");
    }
}

