/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.twitter.storage;

import io.meeds.gamification.twitter.dao.TwitterAccountDAO;
import io.meeds.gamification.twitter.entity.TwitterAccountEntity;
import io.meeds.gamification.twitter.model.TwitterAccount;
import io.meeds.gamification.twitter.storage.mapper.TwitterAccountMapper;
import java.util.Date;
import java.util.List;
import org.exoplatform.commons.ObjectAlreadyExistsException;

public class TwitterAccountStorage {
    private final TwitterAccountDAO twitterAccountDAO;

    public TwitterAccountStorage(TwitterAccountDAO twitterAccountDAO) {
        this.twitterAccountDAO = twitterAccountDAO;
    }

    public TwitterAccount addTwitterAccount(TwitterAccount twitterAccount) throws ObjectAlreadyExistsException {
        TwitterAccount existsAccount = this.getTwitterAccountByRemoteId(twitterAccount.getRemoteId());
        if (existsAccount == null) {
            TwitterAccountEntity twitterAccountEntity = TwitterAccountMapper.toEntity(twitterAccount);
            twitterAccountEntity.setWatchedDate(new Date());
            twitterAccountEntity.setUpdatedDate(new Date());
            twitterAccountEntity.setRefreshDate(new Date());
            twitterAccountEntity = (TwitterAccountEntity)this.twitterAccountDAO.create(twitterAccountEntity);
            return TwitterAccountMapper.fromEntity(twitterAccountEntity);
        }
        throw new ObjectAlreadyExistsException((Object)existsAccount);
    }

    public TwitterAccount getTwitterAccountById(Long id) {
        return TwitterAccountMapper.fromEntity((TwitterAccountEntity)this.twitterAccountDAO.find(id));
    }

    public List<Long> getTwitterAccountIds(int offset, int limit) {
        return this.twitterAccountDAO.getAccountsIds(offset, limit);
    }

    public int countTwitterAccounts() {
        return this.twitterAccountDAO.count().intValue();
    }

    public TwitterAccount getTwitterAccountByRemoteId(long remoteId) {
        TwitterAccountEntity twitterAccountEntity = this.twitterAccountDAO.getAccountByRemoteId(remoteId);
        return TwitterAccountMapper.fromEntity(twitterAccountEntity);
    }

    public TwitterAccount updateAccountLastMentionTweetId(long accountId, long lastMentionTweetId) {
        TwitterAccountEntity twitterAccountEntity = (TwitterAccountEntity)this.twitterAccountDAO.find(Long.valueOf(accountId));
        twitterAccountEntity.setLastMentionTweetId(lastMentionTweetId);
        return TwitterAccountMapper.fromEntity((TwitterAccountEntity)this.twitterAccountDAO.update(twitterAccountEntity));
    }

    public TwitterAccount deleteTwitterAccount(long accountId) {
        TwitterAccountEntity twitterAccountEntity = (TwitterAccountEntity)this.twitterAccountDAO.find(Long.valueOf(accountId));
        if (twitterAccountEntity != null) {
            this.twitterAccountDAO.delete(twitterAccountEntity);
        }
        return TwitterAccountMapper.fromEntity(twitterAccountEntity);
    }
}

