/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.twitter.scheduled;

import io.meeds.gamification.twitter.model.Tweet;
import io.meeds.gamification.twitter.model.TwitterAccount;
import io.meeds.gamification.twitter.model.TwitterTrigger;
import io.meeds.gamification.twitter.scheduled.TwitterRemoteUpdateJob$AjcClosure1;
import io.meeds.gamification.twitter.service.TwitterConsumerService;
import io.meeds.gamification.twitter.service.TwitterService;
import io.meeds.gamification.twitter.service.TwitterTriggerService;
import io.meeds.gamification.twitter.utils.Utils;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;

@DisallowConcurrentExecution
public class TwitterRemoteUpdateJob
implements Job {
    private static final Log LOG;
    private final TwitterConsumerService twitterConsumerService;
    private final TwitterService twitterAccountService;
    private final TwitterTriggerService twitterTriggerService = (TwitterTriggerService)ExoContainerContext.getService(TwitterTriggerService.class);
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public TwitterRemoteUpdateJob() {
        this.twitterConsumerService = (TwitterConsumerService)ExoContainerContext.getService(TwitterConsumerService.class);
        this.twitterAccountService = (TwitterService)ExoContainerContext.getService(TwitterService.class);
    }

    @ExoTransactional
    public void execute(JobExecutionContext context) {
        JobExecutionContext jobExecutionContext = context;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)jobExecutionContext);
        Object[] objectArray = new Object[]{this, jobExecutionContext, joinPoint};
        TwitterRemoteUpdateJob$AjcClosure1 twitterRemoteUpdateJob$AjcClosure1 = new TwitterRemoteUpdateJob$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(twitterRemoteUpdateJob$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private void processTwitterAccount(TwitterAccount twitterAccount, String bearerToken) {
        try {
            List<TwitterTrigger> mentionTriggers = this.twitterConsumerService.getMentionEvents(twitterAccount, twitterAccount.getLastMentionTweetId(), bearerToken);
            if (CollectionUtils.isNotEmpty(mentionTriggers)) {
                this.processMentionTriggers(mentionTriggers, twitterAccount);
            }
        }
        catch (ObjectNotFoundException e) {
            LOG.warn("Error while updating twitter account {}", new Object[]{twitterAccount.getId(), e});
        }
    }

    private void processMentionTriggers(List<TwitterTrigger> mentionTriggers, TwitterAccount twitterAccount) throws ObjectNotFoundException {
        for (TwitterTrigger trigger : mentionTriggers) {
            this.twitterTriggerService.handleTriggerAsync(trigger);
        }
        this.twitterAccountService.updateAccountLastMentionTweetId(twitterAccount.getId(), mentionTriggers.get(0).getTweetId());
    }

    private void processTweetReactionsUpdate(Tweet tweet, String bearerToken) {
        Set<String> tweetLikers = this.twitterConsumerService.retrieveTweetLikers(tweet.getTweetLink(), bearerToken);
        Set<String> tweetRetweeters = this.twitterConsumerService.retrieveTweetRetweeters(tweet.getTweetLink(), bearerToken);
        if (!CollectionUtils.isEqualCollection(tweetLikers, tweet.getLikers())) {
            tweetLikers.stream().filter(liker -> !tweet.getLikers().contains(liker)).forEach(liker -> {
                TwitterTrigger twitterTrigger = new TwitterTrigger();
                twitterTrigger.setType("tweet");
                twitterTrigger.setTrigger("likeTweet");
                twitterTrigger.setTwitterUsername((String)liker);
                String tweetId = Utils.extractTweetId(tweet.getTweetLink());
                if (StringUtils.isNotBlank((CharSequence)tweetId)) {
                    twitterTrigger.setTweetId(Long.parseLong(tweetId));
                }
                this.twitterTriggerService.handleTriggerAsync(twitterTrigger);
            });
        }
        if (!CollectionUtils.isEqualCollection(tweetRetweeters, tweet.getRetweeters())) {
            tweetRetweeters.stream().filter(retweeter -> !tweet.getRetweeters().contains(retweeter)).forEach(retweeter -> {
                TwitterTrigger twitterTrigger = new TwitterTrigger();
                twitterTrigger.setType("tweet");
                twitterTrigger.setTrigger("retweet");
                twitterTrigger.setTwitterUsername((String)retweeter);
                String tweetId = Utils.extractTweetId(tweet.getTweetLink());
                if (StringUtils.isNotBlank((CharSequence)tweetId)) {
                    twitterTrigger.setTweetId(Long.parseLong(tweetId));
                }
                this.twitterTriggerService.handleTriggerAsync(twitterTrigger);
            });
        }
        if (!CollectionUtils.isEqualCollection(tweetLikers, tweet.getLikers()) || !CollectionUtils.isEqualCollection(tweetRetweeters, tweet.getRetweeters())) {
            try {
                this.twitterAccountService.updateTweetReactions(tweet.getTweetId(), tweetLikers, tweetRetweeters);
            }
            catch (ObjectNotFoundException e) {
                LOG.warn("Error while updating tweet reactions {}", new Object[]{tweet.getTweetId(), e});
            }
        }
    }

    static {
        TwitterRemoteUpdateJob.ajc$preClinit();
        LOG = ExoLogger.getLogger(TwitterRemoteUpdateJob.class);
    }

    static /* synthetic */ void execute_aroundBody0(TwitterRemoteUpdateJob ajc$this, JobExecutionContext context, JoinPoint joinPoint) {
        List<Tweet> tweets;
        String bearerToken = ajc$this.twitterAccountService.getTwitterBearerToken();
        if (StringUtils.isBlank((CharSequence)bearerToken)) {
            return;
        }
        List<TwitterAccount> twitterAccounts = ajc$this.twitterAccountService.getTwitterAccounts(0, -1);
        if (CollectionUtils.isNotEmpty(twitterAccounts)) {
            twitterAccounts.forEach(twitterAccount -> this.processTwitterAccount((TwitterAccount)twitterAccount, bearerToken));
        }
        if (CollectionUtils.isNotEmpty(tweets = ajc$this.twitterAccountService.getTweets(0, -1))) {
            tweets.forEach(tweet -> this.processTweetReactionsUpdate((Tweet)tweet, bearerToken));
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TwitterRemoteUpdateJob.java", TwitterRemoteUpdateJob.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "execute", "io.meeds.gamification.twitter.scheduled.TwitterRemoteUpdateJob", "org.quartz.JobExecutionContext", "context", "", "void"), 66);
    }
}

