/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.twitter;

import io.meeds.gamification.service.ConnectorService;
import io.meeds.gamification.service.EventService;
import io.meeds.gamification.service.RuleService;
import io.meeds.gamification.service.TriggerService;
import io.meeds.gamification.twitter.dao.TwitterAccountDAO;
import io.meeds.gamification.twitter.dao.TwitterTweetDAO;
import io.meeds.gamification.twitter.service.TwitterConsumerService;
import io.meeds.gamification.twitter.service.TwitterService;
import io.meeds.gamification.twitter.service.TwitterTriggerService;
import io.meeds.gamification.twitter.service.impl.TwitterServiceImpl;
import io.meeds.gamification.twitter.service.impl.TwitterTriggerServiceImpl;
import io.meeds.gamification.twitter.storage.TwitterAccountStorage;
import io.meeds.gamification.twitter.storage.TwitterTweetStorage;
import java.util.Collections;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.testing.BaseExoTestCase;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.web.security.codec.CodecInitializer;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/twitter-test-configuration.xml")})
public abstract class BaseTwitterTest
extends BaseExoTestCase {
    protected TwitterService twitterService;
    protected TwitterTriggerService twitterTriggerService;
    protected TwitterAccountDAO twitterAccountDAO;
    protected SettingService settingService;
    protected TwitterAccountStorage twitterAccountStorage;
    protected TwitterTweetStorage twitterTweetStorage;
    @Mock
    protected TwitterConsumerService twitterConsumerService;
    @Mock
    protected RuleService ruleService;
    @Mock
    protected ConnectorService connectorService;
    @Mock
    protected TriggerService triggerService;
    @Mock
    protected ListenerService listenerService;
    @Mock
    protected EventService eventService;
    protected CodecInitializer codecInitializer;
    protected TwitterTweetDAO twitterTweetDAO;
    protected IdentityManager identityManager;
    protected IdentityRegistry identityRegistry;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        ExoContainerContext.setCurrentContainer((ExoContainer)this.getContainer());
        this.twitterAccountDAO = (TwitterAccountDAO)ExoContainerContext.getService(TwitterAccountDAO.class);
        this.twitterTweetDAO = (TwitterTweetDAO)ExoContainerContext.getService(TwitterTweetDAO.class);
        this.settingService = (SettingService)ExoContainerContext.getService(SettingService.class);
        this.twitterAccountStorage = (TwitterAccountStorage)ExoContainerContext.getService(TwitterAccountStorage.class);
        this.twitterTweetStorage = (TwitterTweetStorage)ExoContainerContext.getService(TwitterTweetStorage.class);
        this.codecInitializer = (CodecInitializer)ExoContainerContext.getService(CodecInitializer.class);
        this.identityRegistry = (IdentityRegistry)ExoContainerContext.getService(IdentityRegistry.class);
        this.identityManager = (IdentityManager)ExoContainerContext.getService(IdentityManager.class);
        this.twitterTriggerService = new TwitterTriggerServiceImpl(this.listenerService, this.connectorService, this.identityManager, this.eventService, this.triggerService);
        this.twitterService = new TwitterServiceImpl(this.settingService, this.twitterConsumerService, this.twitterAccountStorage, this.twitterTweetStorage, this.ruleService, this.codecInitializer);
        this.resetUserSession();
        this.begin();
    }

    @After
    public void tearDown() {
        this.restartTransaction();
        this.twitterTweetDAO.deleteAll();
        this.twitterAccountDAO.deleteAll();
        this.end();
    }

    protected void resetUserSession() {
        ConversationState.setCurrent(null);
    }

    protected Identity registerAdministratorUser(String user) {
        Identity identity = new Identity(user, Collections.singletonList(new MembershipEntry("/platform/rewarding")));
        this.identityRegistry.register(identity);
        return identity;
    }

    protected Identity registerInternalUser(String username) {
        Identity identity = new Identity(username, Collections.singletonList(new MembershipEntry("/platform/users")));
        this.identityRegistry.register(identity);
        return identity;
    }
}

