/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.twitter.service;

import io.meeds.gamification.model.EventDTO;
import io.meeds.gamification.twitter.BaseTwitterTest;
import io.meeds.gamification.twitter.model.TwitterTrigger;
import java.util.ArrayList;
import java.util.HashMap;
import org.exoplatform.services.listener.ListenerService;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TwitterTriggerServiceTest
extends BaseTwitterTest {
    private static final String ADMIN_USER = "root1";
    private static final String USER = "root";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.registerAdministratorUser(ADMIN_USER);
        this.registerInternalUser(USER);
    }

    @Test
    public void testHandleTriggerAsync() throws Exception {
        TwitterTrigger twitterTrigger = new TwitterTrigger();
        twitterTrigger.setType("tweet");
        twitterTrigger.setTrigger("likeTweet");
        twitterTrigger.setTwitterUsername("liker");
        twitterTrigger.setTweetId(11112222L);
        Mockito.when((Object)this.triggerService.isTriggerEnabledForAccount(twitterTrigger.getTrigger(), twitterTrigger.getAccountId())).thenReturn((Object)true);
        Mockito.when((Object)this.connectorService.getAssociatedUsername("twitter", twitterTrigger.getTwitterUsername())).thenReturn((Object)ADMIN_USER);
        ArrayList<EventDTO> events = new ArrayList<EventDTO>();
        EventDTO eventDTO = new EventDTO(1L, "likeTweet", "twitter", "likeTweet", null, null);
        EventDTO eventDTO1 = new EventDTO(2L, "likeTweet", "twitter", "likeTweet", null, null);
        events.add(eventDTO);
        events.add(eventDTO1);
        Mockito.when((Object)this.eventService.getEventsByTitle(twitterTrigger.getTrigger(), 0, -1)).thenReturn(events);
        this.twitterTriggerService.handleTriggerAsyncInternal(twitterTrigger);
        String eventDetails = "{accountId: " + twitterTrigger.getAccountId() + ", tweetId: " + twitterTrigger.getTweetId() + "}";
        HashMap<String, Object> gam = new HashMap<String, Object>();
        gam.put("senderId", ADMIN_USER);
        gam.put("receiverId", ADMIN_USER);
        gam.put("objectId", "11112222");
        gam.put("objectType", "tweet");
        gam.put("ruleTitle", "likeTweet");
        gam.put("eventDetails", eventDetails);
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast("exo.gamification.generic.action", gam, (Object)"");
    }
}

