/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.twitter.rest;

import io.meeds.gamification.twitter.model.TokenStatus;
import io.meeds.gamification.twitter.model.Tweet;
import io.meeds.gamification.twitter.model.TwitterAccount;
import io.meeds.gamification.twitter.rest.builder.TwitterAccountBuilder;
import io.meeds.gamification.twitter.rest.model.EntityList;
import io.meeds.gamification.twitter.rest.model.TwitterAccountRestEntity;
import io.meeds.gamification.twitter.service.TwitterConsumerService;
import io.meeds.gamification.twitter.service.TwitterService;
import io.meeds.gamification.utils.Utils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;

@Path(value="/gamification/connectors/twitter")
public class TwitterServiceRest
implements ResourceContainer {
    public static final String TWITTER_ACCOUNT_NOT_FOUND = "The TWitter account doesn't exit";
    private final TwitterService twitterService;
    private final TwitterConsumerService twitterConsumerService;

    public TwitterServiceRest(TwitterService twitterAccountService, TwitterConsumerService twitterConsumerService) {
        this.twitterService = twitterAccountService;
        this.twitterConsumerService = twitterConsumerService;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="account")
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieves the list of twitter watched accounts", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation")})
    public Response getWatchedAccounts(@QueryParam(value="offset") int offset, @Parameter(description="Query results limit", required=true) @QueryParam(value="limit") int limit, @Parameter(description="Force update accounts") @Schema(defaultValue="false") @QueryParam(value="forceUpdate") boolean forceUpdate, @Parameter(description="Watched accounts total size") @Schema(defaultValue="false") @QueryParam(value="returnSize") boolean returnSize) {
        String currentUser = Utils.getCurrentUser();
        try {
            EntityList<TwitterAccountRestEntity> accountEntityList = new EntityList<TwitterAccountRestEntity>();
            List<TwitterAccountRestEntity> twitterAccountRestEntities = this.getTwitterAccountRestEntities(currentUser, offset, limit, forceUpdate);
            accountEntityList.setEntities(twitterAccountRestEntities);
            accountEntityList.setOffset(offset);
            accountEntityList.setLimit(limit);
            if (returnSize) {
                int twitterAccountsSize = this.twitterService.countTwitterAccounts(currentUser);
                accountEntityList.setSize(twitterAccountsSize);
            }
            return Response.ok(accountEntityList).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="account/{accountId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieves a twitter watched account by its technical identifier", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getWatchedAccountById(@Parameter(description="Account technical identifier", required=true) @PathParam(value="accountId") long accountId) {
        if (accountId == 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Account Id must be not null").build();
        }
        String currentUser = Utils.getCurrentUser();
        try {
            TwitterAccount twitterAccount = this.twitterService.getTwitterAccountById(accountId, currentUser);
            return Response.ok((Object)twitterAccount).build();
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="account")
    @RolesAllowed(value={"users"})
    @Operation(summary="Create a watched Twitter account.", description="Create a watched Twitter account.", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response createWatchedAccount(@Parameter(description="Twitter username", required=true) @FormParam(value="twitterUsername") String twitterUsername) {
        if (StringUtils.isBlank((CharSequence)twitterUsername)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'twitterUsername' parameter is mandatory").build();
        }
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        try {
            this.twitterService.addTwitterAccount(twitterUsername, currentUser);
            return Response.status((Response.Status)Response.Status.CREATED).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (ObjectAlreadyExistsException e) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)e.getMessage()).build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
    }

    @DELETE
    @Path(value="account/{accountId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Deletes watched Twitter account.", description="Deletes watched Twitter account.", method="DELETE")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteWatchedAccount(@Parameter(description="Twitter account id", required=true) @PathParam(value="accountId") long accountId) {
        if (accountId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'accountId' parameter is mandatory").build();
        }
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        try {
            this.twitterService.deleteTwitterAccount(accountId, currentUser);
            return Response.noContent().build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).type("text/plain").build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)TWITTER_ACCOUNT_NOT_FOUND).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="tweet")
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieves the list of twitter watched tweet", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation")})
    public Response getWatchedTweets(@QueryParam(value="offset") int offset, @Parameter(description="Query results limit", required=true) @QueryParam(value="limit") int limit, @Parameter(description="Watched tweet total size") @Schema(defaultValue="false") @QueryParam(value="returnSize") boolean returnSize) {
        List<Tweet> tweet = this.twitterService.getTweets(offset, limit);
        EntityList<Tweet> tweetEntityList = new EntityList<Tweet>();
        tweetEntityList.setEntities(tweet);
        tweetEntityList.setOffset(offset);
        tweetEntityList.setLimit(limit);
        if (returnSize) {
            tweetEntityList.setSize(this.twitterService.countTweets());
        }
        return Response.ok(tweetEntityList).build();
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/bearerToken")
    @RolesAllowed(value={"users"})
    @Operation(summary="Saves a Twitter bearer token.", description="Saves a Twitter bearer token.", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response saveBearerToken(@Parameter(description="Twitter bearer token", required=true) @FormParam(value="bearerToken") String bearerToken) {
        if (StringUtils.isBlank((CharSequence)bearerToken)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'bearerToken' parameter is mandatory").build();
        }
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        try {
            this.twitterService.saveTwitterBearerToken(bearerToken, currentUser);
            return Response.status((Response.Status)Response.Status.CREATED).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
    }

    @DELETE
    @Path(value="/bearerToken")
    @RolesAllowed(value={"users"})
    @Operation(summary="Deletes Twitter bearer token.", description="Deletes Twitter bearer token.", method="DELETE")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteTwitterBearerToken() {
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        try {
            this.twitterService.deleteTwitterBearerToken(currentUser);
            return Response.noContent().build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).type("text/plain").build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/bearerToken")
    @RolesAllowed(value={"users"})
    @Operation(summary="Checks if a twitter bearer token is stored", description="This returns if twitter bearer token is stored or not", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="404", description="Resource not found"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response checkTwitterTokenStatus() {
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        try {
            String bearerToken = this.twitterService.getTwitterBearerToken(currentUser);
            TokenStatus tokenStatus = this.twitterConsumerService.checkTwitterTokenStatus(bearerToken);
            return Response.ok((Object)tokenStatus).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
    }

    private List<TwitterAccountRestEntity> getTwitterAccountRestEntities(String username, int offset, int limit, boolean forceUpdate) throws IllegalAccessException {
        List<TwitterAccount> twitterAccounts = this.twitterService.getTwitterAccounts(username, offset, limit, forceUpdate);
        return TwitterAccountBuilder.toRestEntities(this.twitterService, this.twitterConsumerService, twitterAccounts);
    }
}

