/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.twitter.gamification.plugin;

import io.meeds.twitter.gamification.plugin.TwitterEventPlugin;
import java.lang.invoke.StringConcatFactory;
import java.util.HashMap;
import java.util.List;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.springframework.boot.test.context.SpringBootTest;

@SpringBootTest(classes={TwitterEventPlugin.class})
public class TwitterEventPluginTest {
    @Test
    public void testIsValidEvent() {
        TwitterEventPlugin twitterEventPlugin = new TwitterEventPlugin();
        Assertions.assertEquals((Object)"twitter", (Object)twitterEventPlugin.getEventType());
        Assertions.assertEquals(List.of("mentionAccount", "likeTweet", "retweet"), (Object)twitterEventPlugin.getTriggers());
        HashMap<String, String> eventProperties = new HashMap<String, String>();
        eventProperties.put("accountId", "132452");
        Assertions.assertFalse((boolean)twitterEventPlugin.isValidEvent(eventProperties, (String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"{accountId: 13245258, tweetId: null}"}))));
        Assertions.assertTrue((boolean)twitterEventPlugin.isValidEvent(eventProperties, (String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"{accountId: 132452, tweetId: null}"}))));
        eventProperties = new HashMap();
        eventProperties.put("tweetLink", "https://twitter.com/IoMeeds/status/1760291687425798481");
        Assertions.assertFalse((boolean)twitterEventPlugin.isValidEvent(eventProperties, (String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"{accountId: null, tweetId: 1760291687425798482}"}))));
        Assertions.assertTrue((boolean)twitterEventPlugin.isValidEvent(eventProperties, (String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"{accountId: null, tweetId: 1760291687425798481}"}))));
    }
}

