/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.twitter.gamification.rest;

import io.meeds.twitter.gamification.model.Tweet;
import io.meeds.twitter.gamification.service.TwitterService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"tweets"})
@Tag(name="twitter/tweets", description="Manage and access twitter watched tweets")
public class TwitterTweetRest {
    @Autowired
    private TwitterService twitterService;

    @GetMapping
    @Secured(value={"users"})
    @Operation(summary="Retrieves the list of twitter watched tweet", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation")})
    public PagedModel<EntityModel<Tweet>> getWatchedTweets(Pageable pageable, PagedResourcesAssembler<Tweet> assembler) {
        Page<Tweet> tweets = this.twitterService.getTweets(pageable);
        return assembler.toModel(tweets);
    }
}

