/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.twitter.gamification.rest;

import io.meeds.spring.web.security.PortalAuthenticationManager;
import io.meeds.spring.web.security.WebSecurityConfiguration;
import io.meeds.twitter.gamification.model.TwitterAccount;
import io.meeds.twitter.gamification.rest.TwitterAccountRest;
import io.meeds.twitter.gamification.service.TwitterConsumerService;
import io.meeds.twitter.gamification.service.TwitterService;
import jakarta.servlet.Filter;
import java.util.List;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureWebMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.http.MediaType;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.test.web.servlet.request.SecurityMockMvcRequestPostProcessors;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@SpringBootTest(classes={TwitterAccountRest.class, PortalAuthenticationManager.class})
@ContextConfiguration(classes={WebSecurityConfiguration.class})
@AutoConfigureWebMvc
@AutoConfigureMockMvc(addFilters=false)
@ExtendWith(value={MockitoExtension.class})
class TwitterAccountRestTest {
    private static final String REST_PATH = "/accounts";
    private static final String SIMPLE_USER = "simple";
    private static final String TEST_PASSWORD = "testPassword";
    private static final Pageable PAGEABLE = Pageable.ofSize((int)2);
    @MockBean
    private TwitterService twitterService;
    @MockBean
    private TwitterConsumerService twitterConsumerService;
    @Autowired
    private SecurityFilterChain filterChain;
    @Autowired
    private WebApplicationContext context;
    private MockMvc mockMvc;

    TwitterAccountRestTest() {
    }

    @BeforeEach
    void setup() {
        this.mockMvc = ((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).addFilters(this.filterChain.getFilters().toArray(new Filter[0]))).build();
    }

    @Test
    void getWatchedAccountsAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)REST_PATH, (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void getWatchedAccountsSimpleUser() throws Exception {
        Mockito.when((Object)this.twitterService.getTwitterAccounts((String)ArgumentMatchers.eq((Object)SIMPLE_USER), (Pageable)ArgumentMatchers.any())).thenReturn((Object)new PageImpl(List.of(this.newWatchedAccount())));
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)REST_PATH, (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((TwitterService)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalAccessException()}).when((Object)this.twitterService)).getTwitterAccounts((String)ArgumentMatchers.eq((Object)SIMPLE_USER), (Pageable)ArgumentMatchers.any());
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)REST_PATH, (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    void getWatchedAccountByIdAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/accounts/1", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void getWatchedAccountByIdSimpleUser() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/accounts/1", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/accounts/0", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
        ((TwitterService)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalAccessException()}).when((Object)this.twitterService)).getTwitterAccountById(1L, SIMPLE_USER);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/accounts/1", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isUnauthorized());
        ((TwitterService)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalArgumentException()}).when((Object)this.twitterService)).getTwitterAccountById(1L, SIMPLE_USER);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/accounts/1", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
        ((TwitterService)Mockito.doThrow((Throwable[])new Throwable[]{new ObjectNotFoundException("Twitter account doesn't exist")}).when((Object)this.twitterService)).getTwitterAccountById(1L, SIMPLE_USER);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/accounts/1", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    void createWatchedAccountAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)REST_PATH, (Object[])new Object[0]).param("twitterUsername", new String[]{"twitterUsername"}).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void createWatchedAccountSimpleUser() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)REST_PATH, (Object[])new Object[0]).param("twitterUsername", new String[]{""}).with(this.testSimpleUser()).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)REST_PATH, (Object[])new Object[0]).param("twitterUsername", new String[]{"twitterUsername"}).with(this.testSimpleUser()).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((TwitterService)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalAccessException()}).when((Object)this.twitterService)).addTwitterAccount("twitterUsername", SIMPLE_USER);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)REST_PATH, (Object[])new Object[0]).param("twitterUsername", new String[]{"twitterUsername"}).with(this.testSimpleUser()).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isUnauthorized());
        ((TwitterService)Mockito.doThrow((Throwable[])new Throwable[]{new ObjectAlreadyExistsException((Object)new TwitterAccount())}).when((Object)this.twitterService)).addTwitterAccount("twitterUsername", SIMPLE_USER);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)REST_PATH, (Object[])new Object[0]).param("twitterUsername", new String[]{"twitterUsername"}).with(this.testSimpleUser()).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isConflict());
        ((TwitterService)Mockito.doThrow((Throwable[])new Throwable[]{new ObjectNotFoundException("twitter.accountNotFound")}).when((Object)this.twitterService)).addTwitterAccount("twitterUsername", SIMPLE_USER);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)REST_PATH, (Object[])new Object[0]).param("twitterUsername", new String[]{"twitterUsername"}).with(this.testSimpleUser()).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    void deleteTwitterBearerTokenAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/accounts/1", (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void deleteTwitterBearerTokenSimpleUser() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/accounts/1", (Object[])new Object[0]).with(this.testSimpleUser()).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((TwitterService)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalAccessException()}).when((Object)this.twitterService)).deleteTwitterAccount(1L, SIMPLE_USER);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/accounts/1", (Object[])new Object[0]).with(this.testSimpleUser()).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isUnauthorized());
        ((TwitterService)Mockito.doThrow((Throwable[])new Throwable[]{new ObjectNotFoundException("Twitter account doesn't exist")}).when((Object)this.twitterService)).deleteTwitterAccount(1L, SIMPLE_USER);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/accounts/1", (Object[])new Object[0]).with(this.testSimpleUser()).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    private RequestPostProcessor testSimpleUser() {
        return SecurityMockMvcRequestPostProcessors.user((String)SIMPLE_USER).password(TEST_PASSWORD).authorities(new GrantedAuthority[]{new SimpleGrantedAuthority("users")});
    }

    private TwitterAccount newWatchedAccount() {
        return new TwitterAccount(1L, 12314L, "identifier", "name", "watchedDate", "watchedBy", "updatedDate", "refreshDate", 1234L);
    }
}

