/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.analytics;

import io.meeds.analytics.listener.social.BaseAttachmentAnalyticsListener;
import io.meeds.analytics.model.StatisticData;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.service.RuleService;
import jakarta.annotation.PostConstruct;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.attachment.model.ObjectAttachmentId;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Asynchronous
@Component
public class RuleAttachmentAnalyticsListener
extends BaseAttachmentAnalyticsListener {
    private static final List<String> SUPPORTED_OBJECT_TYPES = Collections.singletonList("rule");
    private static final List<String> EVENT_NAMES = Arrays.asList("attachment.created", "attachment.deleted");
    @Autowired
    private RuleService ruleService;
    @Autowired
    private AttachmentService attachmentService;
    @Autowired
    private SpaceService spaceService;
    @Autowired
    private ListenerService listenerService;

    @PostConstruct
    public void init() {
        EVENT_NAMES.forEach(name -> this.listenerService.addListener(name, (ListenerBase)this));
    }

    protected void extendStatisticData(StatisticData statisticData, ObjectAttachmentId objectAttachment) {
        RuleDTO rule = this.ruleService.findRuleById(Long.parseLong(objectAttachment.getObjectId()));
        if (rule != null) {
            ProgramDTO program = rule.getProgram();
            if (program != null) {
                statisticData.addParameter("programTitle", (Object)rule.getProgram().getTitle());
            }
            statisticData.addParameter("ruleTitle", (Object)rule.getTitle());
        }
    }

    protected String getModule(ObjectAttachmentId objectAttachment) {
        return "gamification";
    }

    protected String getSubModule(ObjectAttachmentId objectAttachment) {
        return "rule";
    }

    protected List<String> getSupportedObjectType() {
        return SUPPORTED_OBJECT_TYPES;
    }

    public AttachmentService getAttachmentService() {
        return this.attachmentService;
    }

    public SpaceService getSpaceService() {
        return this.spaceService;
    }
}

