/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.analytics;

import io.meeds.analytics.model.StatisticData;
import io.meeds.analytics.utils.AnalyticsUtils;
import io.meeds.gamification.analytics.AnalyticsProgramListener;
import io.meeds.gamification.constant.EntityType;
import io.meeds.gamification.model.ProgramDTO;
import java.util.HashSet;
import org.exoplatform.services.listener.Event;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AnalyticsProgramListenerTest {
    private static final long AUDIENCE_ID = 1L;
    private static final String USER_NAME = "userName";
    private static final long USER_IDENTITY_ID = 2L;
    private static final int SCORE = 1200;
    private static final String PROGRAM_DESCRIPTION = "programDescription";
    private static final String PROGRAM_TITLE = "programTitle";
    private static MockedStatic<AnalyticsUtils> ANALYTICS_UTILS;
    @Mock
    private IdentityManager identityManager;
    @Mock
    private SpaceService spaceService;
    @Mock
    private Event<ProgramDTO, String> event;
    @Mock
    private Identity userIdentity;
    @Mock
    private Space space;
    private ProgramDTO program;
    private AnalyticsProgramListener programListener;

    @BeforeClass
    public static void initClassContext() {
        ANALYTICS_UTILS = Mockito.mockStatic(AnalyticsUtils.class);
    }

    @AfterClass
    public static void endClassContext() {
        ANALYTICS_UTILS.close();
    }

    @Before
    public void setup() {
        this.program = this.newProgram();
        ANALYTICS_UTILS.reset();
        ANALYTICS_UTILS.when(() -> AnalyticsUtils.addSpaceStatistics((StatisticData)((StatisticData)ArgumentMatchers.any()), (Space)((Space)ArgumentMatchers.any()))).thenCallRealMethod();
        Mockito.when((Object)((ProgramDTO)this.event.getSource())).thenReturn((Object)this.program);
        Mockito.when((Object)((String)this.event.getData())).thenReturn((Object)USER_NAME);
        this.programListener = new AnalyticsProgramListener(this.identityManager, this.spaceService);
    }

    @Test
    public void testThrowExceptionWhenUnhandledEvent() {
        Mockito.when((Object)this.event.getEventName()).thenReturn((Object)"UNHANDLED");
        Assert.assertThrows(IllegalArgumentException.class, () -> this.programListener.onEvent(this.event));
    }

    @Test
    public void testHandleCreateRuleEvent() throws Exception {
        this.assertCollectedOperation("program.created", "createProgram");
    }

    @Test
    public void testHandleUpdateRuleEvent() throws Exception {
        this.assertCollectedOperation("program.updated", "updateProgram");
    }

    @Test
    public void testHandleDeleteRuleEvent() throws Exception {
        this.assertCollectedOperation("program.deleted", "deleteProgram");
    }

    @Test
    public void testHandleEnableRuleEvent() throws Exception {
        this.assertCollectedOperation("program.enabled", "enableProgram");
    }

    @Test
    public void testHandleDisableRuleEvent() throws Exception {
        this.assertCollectedOperation("program.disabled", "disableProgram");
    }

    private void assertCollectedOperation(String eventName, String expectedOperation) throws Exception {
        Mockito.when((Object)this.event.getEventName()).thenReturn((Object)eventName);
        String identityId = String.valueOf(2L);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(USER_NAME)).thenReturn((Object)this.userIdentity);
        Mockito.when((Object)this.userIdentity.getId()).thenReturn((Object)identityId);
        String spaceId = String.valueOf(1L);
        Mockito.when((Object)this.spaceService.getSpaceById(spaceId)).thenReturn((Object)this.space);
        Mockito.when((Object)this.space.getId()).thenReturn((Object)spaceId);
        this.programListener.onEvent(this.event);
        ANALYTICS_UTILS.verify(() -> AnalyticsUtils.addStatisticData((StatisticData)((StatisticData)ArgumentMatchers.argThat(statisticData -> {
            Assert.assertEquals((Object)"gamification", (Object)statisticData.getModule());
            Assert.assertEquals((Object)"program", (Object)statisticData.getSubModule());
            Assert.assertEquals((Object)expectedOperation, (Object)statisticData.getOperation());
            Assert.assertEquals((long)2L, (long)statisticData.getUserId());
            Assert.assertEquals((long)1L, (long)statisticData.getSpaceId());
            Assert.assertEquals((Object)String.valueOf(this.program.getId()), (Object)String.valueOf(statisticData.getParameters().get("programId")));
            Assert.assertEquals((Object)String.valueOf(this.program.getTitle()), (Object)String.valueOf(statisticData.getParameters().get(PROGRAM_TITLE)));
            Assert.assertEquals((Object)String.valueOf(this.program.getBudget()), (Object)String.valueOf(statisticData.getParameters().get("programBudget")));
            Assert.assertEquals((Object)String.valueOf(this.program.getType()), (Object)String.valueOf(statisticData.getParameters().get("programType")));
            Assert.assertEquals((Object)String.valueOf(this.program.getCoverFileId()), (Object)String.valueOf(statisticData.getParameters().get("programCoverFileId")));
            Assert.assertEquals((Object)String.valueOf(this.program.getOwnerIds()), (Object)String.valueOf(statisticData.getListParameters().get("programOwners")));
            return true;
        }))), Mockito.times((int)1));
    }

    private ProgramDTO newProgram() {
        ProgramDTO program = new ProgramDTO();
        program.setTitle(PROGRAM_TITLE);
        program.setDescription(PROGRAM_DESCRIPTION);
        program.setBudget(1200L);
        program.setDeleted(false);
        program.setEnabled(true);
        program.setCoverFileId(2L);
        program.setType(EntityType.AUTOMATIC.name());
        program.setSpaceId(1L);
        HashSet<Long> owners = new HashSet<Long>();
        owners.add(1L);
        program.setOwnerIds(owners);
        return program;
    }
}

