/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.listener;

import io.meeds.gamification.listener.GamificationSpaceListener;
import io.meeds.gamification.service.RuleService;
import java.util.Map;
import java.util.function.BiConsumer;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleListener;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class GamificationSpaceListenerTest {
    private static final MockedStatic<CommonsUtils> COMMONS_UTILS_UTIL = Mockito.mockStatic(CommonsUtils.class);
    @Mock
    private RuleService ruleService;
    @Mock
    private IdentityManager identityManager;
    @Mock
    private SpaceService spaceService;
    @Mock
    private ListenerService listenerService;

    @Before
    public void setUp() {
        COMMONS_UTILS_UTIL.when(() -> CommonsUtils.getService(IdentityManager.class)).thenReturn((Object)this.identityManager);
        ConversationState state = new ConversationState(new Identity("root"));
        ConversationState.setCurrent((ConversationState)state);
    }

    @AfterClass
    public static void tearDown() {
        COMMONS_UTILS_UTIL.close();
    }

    @Test
    public void testSpaceJoin() throws Exception {
        this.testEventTrigger("joinSpace", SpaceLifeCycleListener::joined);
    }

    @Test
    public void testSpaceLeave() throws Exception {
        this.testEventTrigger("joinSpace", SpaceLifeCycleListener::left, true);
    }

    @Test
    public void testAddAppLicationSpace() throws Exception {
        this.testEventTrigger("updateSpaceApplications", SpaceLifeCycleListener::applicationAdded);
    }

    @Test
    public void testRemoveAppLicationSpace() throws Exception {
        this.testEventTrigger("updateSpaceApplications", SpaceLifeCycleListener::applicationRemoved);
    }

    @Test
    public void testSpaceBannerEdited() throws Exception {
        this.testEventTrigger("updateSpaceBanner", SpaceLifeCycleListener::spaceBannerEdited);
    }

    @Test
    public void testSpaceAvatarEdited() throws Exception {
        this.testEventTrigger("updateSpaceAvatar", SpaceLifeCycleListener::spaceAvatarEdited);
    }

    @Test
    public void testCreateSpace() throws Exception {
        this.testEventTrigger("addSpace", SpaceLifeCycleListener::spaceCreated);
    }

    @Test
    public void testUpdateSpaceDescription() throws Exception {
        this.testEventTrigger("updateSpaceDescription", SpaceLifeCycleListener::spaceDescriptionEdited);
    }

    @Test
    public void testBecomeSpaceManager() throws Exception {
        this.testEventTrigger("becomeSpaceManager", SpaceLifeCycleListener::grantedLead);
    }

    @Test
    public void testAddInvitedUser() throws Exception {
        this.testEventTrigger("inviteUserToSpace", SpaceLifeCycleListener::addInvitedUser);
    }

    @Test
    public void testRemoveInvitedUser() throws Exception {
        this.testEventTrigger("inviteUserToSpace", SpaceLifeCycleListener::removeInvitedUser, true);
    }

    private void testEventTrigger(String expectedGamifiedEvent, BiConsumer<GamificationSpaceListener, SpaceLifeCycleEvent> consumer) throws Exception {
        this.testEventTrigger(expectedGamifiedEvent, consumer, false);
    }

    private void testEventTrigger(String expectedGamifiedEvent, BiConsumer<GamificationSpaceListener, SpaceLifeCycleEvent> consumer, boolean canceled) throws Exception {
        GamificationSpaceListener gamificationSpaceListener = new GamificationSpaceListener(this.ruleService, this.identityManager, this.spaceService, this.listenerService);
        org.exoplatform.social.core.identity.model.Identity userIdentity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Mockito.when((Object)userIdentity.getId()).thenReturn((Object)"1");
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity("root")).thenReturn((Object)userIdentity);
        Space space = new Space();
        space.setDisplayName("space1");
        space.setPrettyName(space.getDisplayName());
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Mockito.when((Object)spaceIdentity.getId()).thenReturn((Object)"2");
        Mockito.when((Object)this.identityManager.getOrCreateSpaceIdentity("space1")).thenReturn((Object)spaceIdentity);
        SpaceLifeCycleEvent spaceLifeCycleEvent = new SpaceLifeCycleEvent(space, "root", null);
        consumer.accept(gamificationSpaceListener, spaceLifeCycleEvent);
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)2))).broadcast((String)ArgumentMatchers.eq((Object)(canceled ? "gamification.cancel.event.action" : "exo.gamification.generic.action")), (Object)((Map)ArgumentMatchers.argThat(source -> ((String)source.get("eventId")).equals(expectedGamifiedEvent))), ArgumentMatchers.eq(null));
    }
}

