/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.service;

import io.meeds.gamification.constant.EntityType;
import io.meeds.gamification.model.Announcement;
import io.meeds.gamification.model.AnnouncementActivity;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.rest.model.RealizationValidityContext;
import io.meeds.gamification.service.RealizationService;
import io.meeds.gamification.service.RuleService;
import io.meeds.gamification.service.impl.AnnouncementServiceImpl;
import io.meeds.gamification.storage.AnnouncementStorage;
import io.meeds.gamification.utils.Utils;
import java.util.Date;
import java.util.HashMap;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.testing.BaseExoTestCase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class AnnouncementServiceTest
extends BaseExoTestCase {
    private static MockedStatic<Utils> UTILS;
    @Mock
    private AnnouncementStorage announcementStorage;
    @Mock
    private RuleService ruleService;
    @Mock
    private RealizationService realizationService;
    @Mock
    private ListenerService listenerService;
    @Mock
    private IdentityManager identityManager;
    @Mock
    private ActivityManager activityManager;
    private AnnouncementServiceImpl announcementService;

    @BeforeClass
    public static void initClassContext() {
        UTILS = Mockito.mockStatic(Utils.class);
    }

    @AfterClass
    public static void cleanClassContext() {
        UTILS.close();
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        UTILS.reset();
        this.announcementService = new AnnouncementServiceImpl(this.announcementStorage, this.ruleService, this.realizationService, this.identityManager, this.activityManager, this.listenerService);
    }

    @Test
    public void testCreateAnnouncement() throws ObjectNotFoundException, IllegalAccessException {
        RuleDTO rule = this.newRule();
        Announcement announcement = new Announcement(0L, rule.getId(), rule.getTitle(), Long.valueOf(1L), "announcement comment", Long.valueOf(1L), Utils.toSimpleDateFormat((Date)new Date()), null);
        Announcement createdAnnouncement = new Announcement(1L, rule.getId(), rule.getTitle(), Long.valueOf(1L), "announcement comment", Long.valueOf(1L), Utils.toSimpleDateFormat((Date)new Date()), null);
        Identity spaceIdentity = new Identity();
        spaceIdentity.setId("1");
        spaceIdentity.setProviderId("space");
        spaceIdentity.setRemoteId("space150");
        Identity rootIdentity = new Identity();
        rootIdentity.setId("1");
        rootIdentity.setProviderId("organization");
        rootIdentity.setRemoteId("root");
        Mockito.when((Object)this.identityManager.getOrCreateIdentity("organization", "root")).thenReturn((Object)rootIdentity);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity("root")).thenReturn((Object)rootIdentity);
        Mockito.when((Object)this.announcementStorage.createAnnouncement(announcement)).thenReturn((Object)createdAnnouncement);
        Mockito.when((Object)this.announcementStorage.getAnnouncementById(createdAnnouncement.getId())).thenReturn((Object)createdAnnouncement);
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)identity.isEnable()).thenReturn((Object)true);
        UTILS.when(() -> Utils.getIdentityByTypeAndId((String)((String)ArgumentMatchers.any()), (String)((String)ArgumentMatchers.any()))).thenReturn((Object)identity);
        Mockito.when((Object)identity.getId()).thenReturn((Object)"1");
        HashMap templateParams = new HashMap();
        Assert.assertThrows(IllegalArgumentException.class, () -> this.announcementService.createAnnouncement(null, templateParams, "root"));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.announcementService.createAnnouncement(createdAnnouncement, templateParams, "root"));
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.announcementService.createAnnouncement(announcement, templateParams, "root"));
        long activityId = 125L;
        Mockito.when((Object)this.ruleService.findRuleById(rule.getId().longValue(), "root")).thenAnswer(invocation -> {
            rule.setActivityId(activityId);
            return rule;
        });
        ExoSocialActivity activity = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)activity.getId()).thenReturn((Object)String.valueOf(activityId));
        Mockito.when((Object)this.activityManager.getActivity(String.valueOf(activityId))).thenReturn((Object)activity);
        Assert.assertThrows(IllegalStateException.class, () -> this.announcementService.createAnnouncement(announcement, templateParams, "root"));
        rule.setType(EntityType.MANUAL);
        RealizationValidityContext validityContext = new RealizationValidityContext();
        validityContext.setValidAudience(false);
        Mockito.when((Object)this.realizationService.getRealizationValidityContext(rule, identity.getId())).thenReturn((Object)validityContext);
        Assert.assertThrows(IllegalAccessException.class, () -> this.announcementService.createAnnouncement(announcement, templateParams, "root"));
        Mockito.when((Object)this.identityManager.getIdentity("1")).thenReturn((Object)identity);
        Assert.assertThrows(IllegalAccessException.class, () -> this.announcementService.createAnnouncement(announcement, templateParams, "root"));
        ((ActivityManager)Mockito.doAnswer(invocation -> {
            ExoSocialActivity comment = (ExoSocialActivity)invocation.getArgument(1);
            comment.setId("comment25");
            return null;
        }).when((Object)this.activityManager)).saveComment((ExoSocialActivity)ArgumentMatchers.eq((Object)activity), (ExoSocialActivity)ArgumentMatchers.any());
        validityContext.setValidAudience(true);
        Announcement newAnnouncement = this.announcementService.createAnnouncement(announcement, templateParams, "root");
        AnnouncementServiceTest.assertNotNull((Object)newAnnouncement);
        AnnouncementServiceTest.assertEquals((long)1L, (long)newAnnouncement.getId());
        AnnouncementServiceTest.assertNotNull((Object)newAnnouncement.getActivityId());
        AnnouncementServiceTest.assertEquals((long)25L, (long)newAnnouncement.getActivityId());
    }

    @Test
    public void testCreateAnnouncementActivity() throws ObjectNotFoundException, IllegalAccessException {
        String userIdentityId = "3";
        String commentId = "9";
        int announcementId = 56;
        RuleDTO rule = this.newRule();
        rule.setType(EntityType.MANUAL);
        Identity userIdentity = new Identity();
        userIdentity.setId(userIdentityId);
        userIdentity.setProviderId("organization");
        userIdentity.setRemoteId("root");
        userIdentity.setEnable(true);
        Announcement announcement = new Announcement(0L, rule.getId(), rule.getTitle(), Long.valueOf(Long.parseLong(userIdentityId)), "announcement comment", Long.valueOf(1L), Utils.toSimpleDateFormat((Date)new Date()), null);
        Mockito.when((Object)this.identityManager.getOrCreateIdentity("organization", "root")).thenReturn((Object)userIdentity);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity("root")).thenReturn((Object)userIdentity);
        Mockito.when((Object)this.announcementStorage.createAnnouncement(announcement)).thenAnswer(invocation -> {
            announcement.setId((long)announcementId);
            return announcement;
        });
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)identity.isEnable()).thenReturn((Object)true);
        ExoSocialActivity activity = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)activity.getId()).thenReturn((Object)String.valueOf(rule.getActivityId()));
        long activityId = 125L;
        Mockito.when((Object)this.ruleService.findRuleById(rule.getId().longValue(), "root")).thenAnswer(invocation -> {
            rule.setActivityId(activityId);
            return rule;
        });
        Mockito.when((Object)this.activityManager.getActivity(String.valueOf(activityId))).thenReturn((Object)activity);
        UTILS.when(() -> Utils.getIdentityByTypeAndId((String)((String)ArgumentMatchers.any()), (String)((String)ArgumentMatchers.any()))).thenReturn((Object)identity);
        Mockito.when((Object)identity.getId()).thenReturn((Object)"1");
        HashMap templateParams = new HashMap();
        Mockito.when((Object)this.ruleService.findRuleById(ArgumentMatchers.anyLong())).thenReturn((Object)rule);
        Mockito.when((Object)this.identityManager.getIdentity("1")).thenReturn((Object)identity);
        Mockito.when((Object)this.announcementStorage.getAnnouncementById((long)announcementId)).thenReturn((Object)announcement);
        Mockito.when((Object)this.identityManager.getIdentity(userIdentity.getId())).thenReturn((Object)userIdentity);
        Mockito.when((Object)this.ruleService.findRuleById(rule.getId().longValue(), userIdentity.getRemoteId())).thenReturn((Object)rule);
        Mockito.when((Object)this.activityManager.getActivity(String.valueOf(rule.getActivityId()))).thenReturn((Object)activity);
        ((ActivityManager)Mockito.doAnswer(invocation -> {
            ExoSocialActivityImpl comment = (ExoSocialActivityImpl)invocation.getArgument(1);
            comment.setId("comment" + commentId);
            Mockito.when((Object)this.activityManager.getActivity(commentId)).thenReturn((Object)comment);
            return null;
        }).when((Object)this.activityManager)).saveComment((ExoSocialActivity)ArgumentMatchers.any(), (ExoSocialActivity)ArgumentMatchers.any());
        AnnouncementActivity announcementActivity = new AnnouncementActivity(6L, rule.getId(), rule.getTitle(), Long.valueOf(Long.parseLong(userIdentityId)), "announcement comment", Long.valueOf(Long.parseLong(userIdentityId)), Utils.toSimpleDateFormat((Date)new Date()), null, null);
        Mockito.when((Object)this.identityManager.getIdentity(userIdentity.getId())).thenReturn((Object)userIdentity);
        Mockito.when((Object)this.ruleService.findRuleById(rule.getId().longValue(), userIdentity.getRemoteId())).thenReturn((Object)rule);
        ((ActivityManager)Mockito.doAnswer(invocation -> {
            ExoSocialActivityImpl comment = (ExoSocialActivityImpl)invocation.getArgument(1);
            comment.setId(commentId);
            Mockito.when((Object)this.activityManager.getActivity(commentId)).thenReturn((Object)comment);
            return null;
        }).when((Object)this.activityManager)).saveComment((ExoSocialActivity)ArgumentMatchers.any(), (ExoSocialActivity)ArgumentMatchers.any());
        Mockito.when((Object)this.realizationService.getRealizationValidityContext(rule, userIdentity.getId())).thenReturn((Object)new RealizationValidityContext());
        Announcement newAnnouncement = this.announcementService.createAnnouncement(announcement, templateParams, "root");
        AnnouncementServiceTest.assertNotNull((Object)newAnnouncement);
        AnnouncementServiceTest.assertEquals((long)announcementId, (long)newAnnouncement.getId());
        ((ActivityManager)Mockito.verify((Object)this.activityManager, (VerificationMode)Mockito.times((int)1))).saveComment((ExoSocialActivity)ArgumentMatchers.any(ExoSocialActivity.class), (ExoSocialActivity)ArgumentMatchers.argThat(comment -> {
            AnnouncementServiceTest.assertEquals((String)"gamificationActionAnnouncement", (String)comment.getType());
            AnnouncementServiceTest.assertEquals((String)announcementActivity.getComment(), (String)comment.getTitle());
            AnnouncementServiceTest.assertEquals((String)userIdentityId, (String)comment.getUserId());
            AnnouncementServiceTest.assertEquals((String)String.valueOf(announcementId), (String)((String)comment.getTemplateParams().get("announcementId")));
            AnnouncementServiceTest.assertEquals((String)rule.getTitle(), (String)((String)comment.getTemplateParams().get("announcementDescription")));
            return true;
        }));
    }

    @Test
    public void testUpdateAnnouncement() throws ObjectNotFoundException, IllegalAccessException {
        RuleDTO rule = this.newRule();
        Announcement createdAnnouncement = new Announcement(1L, rule.getId(), rule.getTitle(), Long.valueOf(1L), "announcement comment", Long.valueOf(1L), Utils.toSimpleDateFormat((Date)new Date()), null);
        Identity rootIdentity = new Identity();
        rootIdentity.setId("1");
        rootIdentity.setProviderId("organization");
        rootIdentity.setRemoteId("root");
        Mockito.when((Object)this.identityManager.getOrCreateIdentity("organization", "root")).thenReturn((Object)rootIdentity);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity("root")).thenReturn((Object)rootIdentity);
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)identity.isEnable()).thenReturn((Object)true);
        Mockito.when((Object)identity.getId()).thenReturn((Object)"1");
        UTILS.when(() -> Utils.getIdentityByTypeAndId((String)((String)ArgumentMatchers.any()), (String)((String)ArgumentMatchers.any()))).thenReturn((Object)identity);
        Mockito.when((Object)this.announcementStorage.getAnnouncementById(1L)).thenReturn((Object)createdAnnouncement);
        Mockito.when((Object)this.ruleService.findRuleById(rule.getId().longValue(), "root")).thenReturn((Object)rule);
        Mockito.when((Object)this.identityManager.getIdentity("1")).thenReturn((Object)identity);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.announcementService.updateAnnouncementComment(0L, "comment"));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.announcementService.updateAnnouncementComment(2L, null));
        Mockito.when((Object)this.announcementStorage.getAnnouncementById(1L)).thenReturn(null);
        Mockito.when((Object)this.announcementStorage.updateAnnouncementComment(2L, "comment")).thenThrow(new Throwable[]{new ObjectNotFoundException("Fake exception")});
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.announcementService.updateAnnouncementComment(2L, "comment"));
        Mockito.when((Object)this.announcementStorage.updateAnnouncementComment(1L, "comment")).thenReturn((Object)createdAnnouncement);
        Announcement updatedAnnouncement = this.announcementService.updateAnnouncementComment(1L, "comment");
        AnnouncementServiceTest.assertNotNull((Object)updatedAnnouncement);
    }

    @Test
    public void testCancelAnnouncement() throws ObjectNotFoundException, IllegalAccessException {
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)identity.isEnable()).thenReturn((Object)true);
        UTILS.when(() -> Utils.getIdentityByTypeAndId((String)((String)ArgumentMatchers.any()), (String)((String)ArgumentMatchers.any()))).thenReturn((Object)identity);
        Mockito.when((Object)identity.getId()).thenReturn((Object)"1");
        Identity rootIdentity = new Identity();
        rootIdentity.setId("1");
        rootIdentity.setProviderId("organization");
        String username = "root";
        rootIdentity.setRemoteId(username);
        Identity johnIdentity = new Identity();
        johnIdentity.setId("2");
        johnIdentity.setProviderId("organization");
        johnIdentity.setRemoteId("john");
        Mockito.when((Object)this.identityManager.getOrCreateIdentity("organization", username)).thenReturn((Object)rootIdentity);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(username)).thenReturn((Object)rootIdentity);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity("john")).thenReturn((Object)johnIdentity);
        RuleDTO rule = this.newRule();
        Announcement createdAnnouncement = new Announcement(1L, rule.getId(), rule.getTitle(), Long.valueOf(1L), "announcement comment", Long.valueOf(1L), Utils.toSimpleDateFormat((Date)new Date()), Long.valueOf(1L));
        Announcement canceledAnnouncement = new Announcement(1L, rule.getId(), rule.getTitle(), Long.valueOf(1L), "announcement comment", Long.valueOf(1L), Utils.toSimpleDateFormat((Date)new Date()), null);
        Mockito.when((Object)this.ruleService.findRuleById(rule.getId().longValue(), username)).thenReturn((Object)rule);
        Mockito.when((Object)this.identityManager.getIdentity("1")).thenReturn((Object)identity);
        Mockito.when((Object)this.announcementStorage.getAnnouncementById(createdAnnouncement.getId())).thenReturn((Object)createdAnnouncement);
        Mockito.when((Object)this.announcementStorage.deleteAnnouncement(createdAnnouncement.getId())).thenReturn((Object)canceledAnnouncement);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.announcementService.deleteAnnouncement(-1L, username));
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.announcementService.deleteAnnouncement(500L, username));
        Assert.assertThrows(IllegalAccessException.class, () -> this.announcementService.deleteAnnouncement(1L, "john"));
        AnnouncementServiceTest.assertNull((Object)this.announcementService.deleteAnnouncement(createdAnnouncement.getId(), username).getActivityId());
    }

    @Test
    public void testGetAnnouncementById() {
        Announcement announcement = new Announcement(1L, Long.valueOf(1L), "challenge title", Long.valueOf(1L), "announcement comment", Long.valueOf(1L), Utils.toSimpleDateFormat((Date)new Date()), null);
        Mockito.when((Object)this.announcementStorage.getAnnouncementById(announcement.getId())).thenReturn((Object)announcement);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.announcementService.getAnnouncementById(0L));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.announcementService.getAnnouncementById(-1L));
        Announcement savedAnnouncement = this.announcementService.getAnnouncementById(1L);
        AnnouncementServiceTest.assertNotNull((Object)savedAnnouncement);
        AnnouncementServiceTest.assertEquals((long)announcement.getId(), (long)savedAnnouncement.getId());
    }

    private RuleDTO newRule() {
        RuleDTO rule = new RuleDTO();
        rule.setId(Long.valueOf(1L));
        rule.setTitle("new challenge");
        rule.setDescription("challenge description");
        rule.setStartDate(Utils.toSimpleDateFormat((Date)new Date()));
        rule.setEndDate(Utils.toSimpleDateFormat((Date)new Date(System.currentTimeMillis() + 5000L)));
        rule.setProgram(this.newProgram());
        rule.setEnabled(true);
        rule.setScore(10);
        return rule;
    }

    private ProgramDTO newProgram() {
        ProgramDTO program = new ProgramDTO();
        program.setId(1L);
        program.setTitle("gamification");
        program.setSpaceId(1L);
        program.setEnabled(true);
        return program;
    }
}

