/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.listener;

import io.meeds.gamification.constant.EntityType;
import io.meeds.gamification.constant.IdentityType;
import io.meeds.gamification.constant.RealizationStatus;
import io.meeds.gamification.listener.AnnouncementRealizationUpdater;
import io.meeds.gamification.model.Announcement;
import io.meeds.gamification.model.RealizationDTO;
import io.meeds.gamification.service.RealizationService;
import java.util.Date;
import org.exoplatform.services.listener.Event;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class AnnouncementRealizationUpdaterTest {
    @Mock
    private ActivityManager activityManager;
    @Mock
    private RealizationService realizationService;
    @Mock
    private Event<Object, Object> event;

    @Test
    public void testUpdateRealizationStatus() throws Exception {
        AnnouncementRealizationUpdater announcementActivityUpdater = new AnnouncementRealizationUpdater(this.activityManager, this.realizationService);
        Announcement announcement = new Announcement(1L, Long.valueOf(1L), "challenge title", Long.valueOf(1L), "announcement comment", Long.valueOf(1L), new Date().toString(), null);
        Mockito.when((Object)this.event.getSource()).thenReturn((Object)announcement);
        RealizationDTO realization = new RealizationDTO();
        realization.setRuleId(Long.valueOf(1L));
        realization.setEarnerId(String.valueOf(1L));
        realization.setEarnerType(IdentityType.USER.name());
        realization.setType(EntityType.MANUAL);
        realization.setStatus(RealizationStatus.ACCEPTED.name());
        realization.setActivityId(Long.valueOf(1L));
        realization.setReceiver("root");
        ExoSocialActivity activity = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)this.realizationService.getRealizationById(Mockito.anyLong())).thenReturn((Object)realization);
        Mockito.when((Object)this.activityManager.getActivity(Mockito.anyString())).thenReturn((Object)activity);
        announcementActivityUpdater.onEvent(this.event);
        ((ActivityManager)Mockito.verify((Object)this.activityManager, (VerificationMode)Mockito.times((int)1))).updateActivity(activity);
    }
}

