/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.plugin;

import io.meeds.gamification.plugin.EventPlugin;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class ContributionEventPlugin
extends EventPlugin {
    public static final String EVENT_TYPE = "contribution";

    @Override
    public String getEventType() {
        return EVENT_TYPE;
    }

    @Override
    public List<String> getTriggers() {
        return List.of("reviewContribution");
    }

    @Override
    public boolean isValidEvent(Map<String, String> eventProperties, String triggerDetails) {
        List<String> desiredRuleIds = this.getListFromCsv(eventProperties.get("ruleIds"));
        List<String> desiredProgramIds = this.getListFromCsv(eventProperties.get("programIds"));
        Map<String, String> triggerDetailsMap = this.stringToMap(triggerDetails);
        if (CollectionUtils.isNotEmpty(desiredProgramIds)) {
            String programId = triggerDetailsMap.get("programId");
            return programId != null && desiredProgramIds.contains(programId);
        }
        if (CollectionUtils.isNotEmpty(desiredRuleIds)) {
            String ruleId = triggerDetailsMap.get("ruleId");
            return ruleId != null && desiredRuleIds.contains(ruleId);
        }
        return triggerDetailsMap.get("eventReviewed") == null || !triggerDetailsMap.get("eventReviewed").equals("reviewContribution");
    }

    private List<String> getListFromCsv(String csvString) {
        if (csvString == null || csvString.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(csvString.split("\\s*,\\s*"));
    }

    private Map<String, String> stringToMap(String mapAsString) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (mapAsString != null && mapAsString.startsWith("{") && mapAsString.endsWith("}")) {
            String[] pairs;
            mapAsString = mapAsString.substring(1, mapAsString.length() - 1);
            for (String pair : pairs = mapAsString.split(",\\s*")) {
                String[] keyValue = pair.split("\\s*:\\s*", 2);
                if (keyValue.length != 2) continue;
                String key = keyValue[0].trim();
                String value = keyValue[1].trim();
                map.put(key, value);
            }
        }
        return map;
    }
}

