/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.listener;

import io.meeds.gamification.listener.GamificationRelationshipListener;
import io.meeds.gamification.service.RealizationService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.relationship.RelationshipEvent;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class GamificationRelationshipListenerTest {
    @Mock
    protected RealizationService realizationService;

    @Test
    public void testRelationshipConfirmed() {
        GamificationRelationshipListener gamificationRelationshipListener = new GamificationRelationshipListener(this.realizationService);
        Identity sender = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)sender.getId()).thenReturn((Object)"1");
        Identity receiver = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)receiver.getId()).thenReturn((Object)"2");
        Relationship relationship = new Relationship(sender, receiver);
        RelationshipEvent event = new RelationshipEvent(RelationshipEvent.Type.CONFIRM, null, relationship);
        gamificationRelationshipListener.confirmed(event);
        ((RealizationService)Mockito.verify((Object)this.realizationService, (VerificationMode)Mockito.times((int)1))).createRealizationsAsync("sendRelationshipRequest", null, sender.getId(), receiver.getId(), receiver.getId(), "identity");
        ((RealizationService)Mockito.verify((Object)this.realizationService, (VerificationMode)Mockito.times((int)1))).createRealizationsAsync("receiveRelationshipRequest", null, receiver.getId(), sender.getId(), sender.getId(), "identity");
    }
}

