/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.dao;

import io.meeds.gamification.constant.DateFilterType;
import io.meeds.gamification.constant.EntityFilterType;
import io.meeds.gamification.constant.EntityStatusType;
import io.meeds.gamification.constant.EntityType;
import io.meeds.gamification.constant.RecurrenceType;
import io.meeds.gamification.entity.ProgramEntity;
import io.meeds.gamification.entity.RuleEntity;
import io.meeds.gamification.model.filter.RuleFilter;
import io.meeds.gamification.test.AbstractServiceTest;
import io.meeds.gamification.utils.Utils;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.junit.Test;

public class RuleDAOTest
extends AbstractServiceTest {
    @Test
    public void testFindRuleByTitle() {
        RuleDAOTest.assertEquals((int)this.ruleDAO.findAll().size(), (int)0);
        this.newRule();
        RuleDAOTest.assertNotNull((Object)this.ruleDAO.findRuleByTitle("createNewTask"));
    }

    @Test
    public void testFindRuleByEventAndDomain() {
        RuleDAOTest.assertEquals((int)this.ruleDAO.findAll().size(), (int)0);
        RuleEntity ruleEntity = this.newRule();
        long domainId = ruleEntity.getDomainEntity().getId();
        RuleDAOTest.assertNotNull((Object)this.ruleDAO.findActiveRuleByEventAndProgramId(ruleEntity.getEventEntity().getTitle(), domainId));
    }

    @Test
    public void testFindHighestBudgetProgramIds() {
        ProgramEntity firstDomain = this.newDomain("firstDomain");
        ProgramEntity secondDomain = this.newDomain("secondDomain");
        ProgramEntity thirdDomain = this.newDomain("thirdDomain");
        RuleEntity r11 = this.newRule("rule1-1", firstDomain.getId());
        r11.setScore(100);
        this.ruleDAO.update((Object)r11);
        RuleEntity r12 = this.newRule("rule1-2", firstDomain.getId());
        r12.setScore(10);
        this.ruleDAO.update((Object)r12);
        RuleEntity r13 = this.newRule("rule1-3", firstDomain.getId());
        r13.setScore(10);
        this.ruleDAO.update((Object)r13);
        RuleEntity r21 = this.newRule("rule2-1", secondDomain.getId());
        r21.setScore(60);
        this.ruleDAO.update((Object)r21);
        RuleEntity r22 = this.newRule("rule2-2", secondDomain.getId());
        r22.setScore(60);
        this.ruleDAO.update((Object)r22);
        RuleEntity r23 = this.newRule("rule2-3", secondDomain.getId());
        r23.setScore(60);
        this.ruleDAO.update((Object)r23);
        RuleEntity r31 = this.newRule("rule3-1", thirdDomain.getId());
        r31.setScore(20);
        this.ruleDAO.update((Object)r31);
        RuleEntity r32 = this.newRule("rule3-2", thirdDomain.getId());
        r32.setScore(200);
        this.ruleDAO.update((Object)r32);
        RuleEntity r33 = this.newRule("rule3-3", thirdDomain.getId());
        r33.setScore(2);
        this.ruleDAO.update((Object)r33);
        RuleDAOTest.assertEquals((Object)thirdDomain.getId(), this.ruleDAO.findHighestBudgetProgramIds(0, 1).get(0));
        RuleDAOTest.assertEquals((Object)secondDomain.getId(), this.ruleDAO.findHighestBudgetProgramIds(1, 1).get(0));
        RuleDAOTest.assertEquals((Object)firstDomain.getId(), this.ruleDAO.findHighestBudgetProgramIds(2, 1).get(0));
        r32.setEnabled(false);
        this.ruleDAO.update((Object)r32);
        RuleDAOTest.assertEquals((Object)secondDomain.getId(), this.ruleDAO.findHighestBudgetProgramIds(0, 1).get(0));
        RuleDAOTest.assertEquals((Object)firstDomain.getId(), this.ruleDAO.findHighestBudgetProgramIds(1, 1).get(0));
        RuleDAOTest.assertEquals((Object)thirdDomain.getId(), this.ruleDAO.findHighestBudgetProgramIds(2, 1).get(0));
        RuleDAOTest.assertTrue((boolean)this.ruleDAO.findHighestBudgetProgramIdsBySpacesIds(new ArrayList<Long>(Collections.singleton(10L)), 0, 3).isEmpty());
        RuleDAOTest.assertEquals((Object)secondDomain.getId(), this.ruleDAO.findHighestBudgetProgramIdsBySpacesIds(new ArrayList<Long>(Collections.singleton(1L)), 0, 3).get(0));
    }

    @Test
    public void testFindHighestBudgetOpenProgramIds() {
        ProgramEntity firstDomain = this.newOpenProgram("firstDomain");
        ProgramEntity secondDomain = this.newOpenProgram("secondDomain");
        ProgramEntity thirdDomain = this.newOpenProgram("thirdDomain");
        this.newOpenRule(100, "rule1-1", firstDomain.getId());
        this.newOpenRule(10, "rule1-2", firstDomain.getId());
        this.newOpenRule(10, "rule1-3", firstDomain.getId());
        this.newOpenRule(60, "rule2-1", secondDomain.getId());
        this.newOpenRule(60, "rule2-2", secondDomain.getId());
        this.newOpenRule(60, "rule2-3", secondDomain.getId());
        this.newOpenRule(20, "rule3-1", thirdDomain.getId());
        RuleEntity r32 = this.newOpenRule(200, "rule3-2", thirdDomain.getId());
        this.newOpenRule(2, "rule3-3", thirdDomain.getId());
        RuleDAOTest.assertEquals((Object)thirdDomain.getId(), this.ruleDAO.findHighestBudgetProgramIds(0, 1).get(0));
        RuleDAOTest.assertEquals((Object)secondDomain.getId(), this.ruleDAO.findHighestBudgetProgramIds(1, 1).get(0));
        RuleDAOTest.assertEquals((Object)firstDomain.getId(), this.ruleDAO.findHighestBudgetProgramIds(2, 1).get(0));
        r32.setEnabled(false);
        this.ruleDAO.update((Object)r32);
        RuleDAOTest.assertEquals((Object)secondDomain.getId(), this.ruleDAO.findHighestBudgetProgramIds(0, 1).get(0));
        RuleDAOTest.assertEquals((Object)firstDomain.getId(), this.ruleDAO.findHighestBudgetProgramIds(1, 1).get(0));
        RuleDAOTest.assertEquals((Object)thirdDomain.getId(), this.ruleDAO.findHighestBudgetProgramIds(2, 1).get(0));
        List programIds = this.ruleDAO.findHighestBudgetOpenProgramIds(0, 3);
        RuleDAOTest.assertNotNull((Object)programIds);
        RuleDAOTest.assertEquals((int)3, (int)programIds.size());
        RuleDAOTest.assertEquals((Object)secondDomain.getId(), programIds.get(0));
        RuleDAOTest.assertEquals((Object)firstDomain.getId(), programIds.get(1));
        RuleDAOTest.assertEquals((Object)thirdDomain.getId(), programIds.get(2));
    }

    @Test
    public void testGetRulesTotalScoreByDomain() {
        ProgramEntity firstDomain = this.newDomain("firstDomain");
        ProgramEntity secondDomain = this.newDomain("secondDomain");
        RuleEntity r1 = this.newRule("rule1", firstDomain.getId());
        RuleEntity r2 = this.newRule("rule2", firstDomain.getId());
        RuleEntity r3 = this.newRule("rule3", secondDomain.getId());
        r1.setScore(100);
        this.ruleDAO.update((Object)r1);
        r2.setScore(60);
        this.ruleDAO.update((Object)r2);
        r3.setScore(20);
        this.ruleDAO.update((Object)r3);
        RuleDAOTest.assertEquals((long)160L, (long)this.ruleDAO.getRulesTotalScoreByProgramId(firstDomain.getId().longValue()));
        RuleDAOTest.assertEquals((long)20L, (long)this.ruleDAO.getRulesTotalScoreByProgramId(secondDomain.getId().longValue()));
        r1.setEnabled(false);
        this.ruleDAO.update((Object)r1);
        RuleDAOTest.assertEquals((long)60L, (long)this.ruleDAO.getRulesTotalScoreByProgramId(firstDomain.getId().longValue()));
    }

    @Test
    public void testExcludRuleIds() {
        RuleFilter filter = new RuleFilter();
        ProgramEntity domainEntity = this.newDomain();
        filter.setDateFilterType(DateFilterType.ALL);
        RuleEntity ruleEntity1 = this.newRule("rule1", domainEntity.getId());
        filter.setProgramId(ruleEntity1.getDomainEntity().getId().longValue());
        filter.setSpaceIds(Collections.singletonList(1L));
        RuleDAOTest.assertEquals((int)1, (int)this.ruleDAO.findRulesIdsByFilter(filter, 0, 10).size());
        this.newRule("rule2", domainEntity.getId());
        RuleDAOTest.assertEquals((int)2, (int)this.ruleDAO.findRulesIdsByFilter(filter, 0, 10).size());
        ArrayList<Long> excludedIds = new ArrayList<Long>();
        excludedIds.add(ruleEntity1.getId());
        filter.setExcludedRuleIds(excludedIds);
        RuleDAOTest.assertEquals((int)1, (int)this.ruleDAO.findRulesIdsByFilter(filter, 0, 10).size());
    }

    @Test
    public void testFindRulesIdsByFilter() {
        RuleFilter filter = new RuleFilter();
        ProgramEntity domainEntity1 = this.newDomain();
        ProgramEntity domainEntity3 = this.newDomain();
        filter.setDateFilterType(DateFilterType.ALL);
        RuleDAOTest.assertEquals((int)0, (int)this.ruleDAO.findRulesIdsByFilter(filter, 0, 10).size());
        RuleEntity ruleEntity1 = this.newManualRule("rule1", domainEntity1.getId());
        filter.setProgramId(ruleEntity1.getDomainEntity().getId().longValue());
        filter.setSpaceIds(Collections.singletonList(1L));
        RuleDAOTest.assertEquals((int)1, (int)this.ruleDAO.findRulesIdsByFilter(filter, 0, 10).size());
        this.newManualRule("rule2", domainEntity1.getId());
        RuleDAOTest.assertEquals((int)2, (int)this.ruleDAO.findRulesIdsByFilter(filter, 0, 10).size());
        this.newManualRule("rule3", domainEntity3.getId());
        RuleDAOTest.assertEquals((int)2, (int)this.ruleDAO.findRulesIdsByFilter(filter, 0, 10).size());
        filter.setDateFilterType(DateFilterType.STARTED);
        filter.setType(EntityFilterType.AUTOMATIC);
        RuleDAOTest.assertEquals((int)0, (int)this.ruleDAO.findRulesIdsByFilter(filter, 0, 10).size());
        filter.setType(EntityFilterType.MANUAL);
        RuleDAOTest.assertEquals((int)2, (int)this.ruleDAO.findRulesIdsByFilter(filter, 0, 10).size());
        RuleEntity ruleEntityNotStarted = new RuleEntity();
        ruleEntityNotStarted.setScore(Integer.parseInt("50"));
        ruleEntityNotStarted.setTitle("ruleEntityNotStarted");
        ruleEntityNotStarted.setDescription("ruleEntityNotStarted Description");
        ruleEntityNotStarted.setEnabled(true);
        ruleEntityNotStarted.setDeleted(false);
        ruleEntityNotStarted.setEventEntity(this.newEvent("ruleEntityNotStarted"));
        ruleEntityNotStarted.setCreatedBy("1");
        ruleEntityNotStarted.setLastModifiedBy("1");
        ruleEntityNotStarted.setLastModifiedDate(new Date());
        ruleEntityNotStarted.setDomainEntity(domainEntity1);
        ruleEntityNotStarted.setType(EntityType.MANUAL);
        ruleEntityNotStarted.setRecurrence(RecurrenceType.NONE);
        ruleEntityNotStarted.setEndDate(Utils.parseSimpleDate((String)Utils.toRFC3339Date((Date)new Date(System.currentTimeMillis() + 864000000L))));
        ruleEntityNotStarted.setStartDate(Utils.parseSimpleDate((String)Utils.toRFC3339Date((Date)new Date(System.currentTimeMillis() + 172800000L))));
        this.ruleDAO.create((Object)ruleEntityNotStarted);
        filter.setDateFilterType(DateFilterType.UPCOMING);
        RuleDAOTest.assertEquals((int)1, (int)this.ruleDAO.findRulesIdsByFilter(filter, 0, 10).size());
        filter.setDateFilterType(DateFilterType.ACTIVE);
        RuleDAOTest.assertEquals((int)3, (int)this.ruleDAO.findRulesIdsByFilter(filter, 0, 10).size());
        RuleEntity ruleEntityEnded = new RuleEntity();
        ruleEntityEnded.setScore(Integer.parseInt("50"));
        ruleEntityEnded.setTitle("ruleEntityEnded");
        ruleEntityEnded.setDescription("ruleEntityEnded Description");
        ruleEntityEnded.setEnabled(true);
        ruleEntityEnded.setDeleted(false);
        ruleEntityEnded.setEventEntity(this.newEvent("ruleEntityEnded"));
        ruleEntityEnded.setCreatedBy("1");
        ruleEntityEnded.setLastModifiedBy("1");
        ruleEntityEnded.setLastModifiedDate(new Date());
        ruleEntityEnded.setDomainEntity(domainEntity1);
        ruleEntityEnded.setType(EntityType.MANUAL);
        ruleEntityEnded.setRecurrence(RecurrenceType.NONE);
        ruleEntityEnded.setEndDate(Utils.parseSimpleDate((String)Utils.toRFC3339Date((Date)new Date())));
        ruleEntityEnded.setStartDate(Utils.parseSimpleDate((String)Utils.toRFC3339Date((Date)new Date(System.currentTimeMillis() - 432000000L))));
        ruleEntityEnded = (RuleEntity)this.ruleDAO.create((Object)ruleEntityEnded);
        filter.setDateFilterType(DateFilterType.ENDED);
        RuleDAOTest.assertEquals((int)1, (int)this.ruleDAO.findRulesIdsByFilter(filter, 0, 10).size());
        filter.setDateFilterType(DateFilterType.ALL);
        filter.setStatus(EntityStatusType.DISABLED);
        RuleDAOTest.assertEquals((int)0, (int)this.ruleDAO.findRulesIdsByFilter(filter, 0, 10).size());
        filter.setStatus(EntityStatusType.ENABLED);
        RuleDAOTest.assertEquals((int)4, (int)this.ruleDAO.findRulesIdsByFilter(filter, 0, 10).size());
        filter.setDateFilterType(DateFilterType.ENDED);
        RuleDAOTest.assertEquals((int)1, (int)this.ruleDAO.findRulesIdsByFilter(filter, 0, 10).size());
        filter.setDateFilterType(DateFilterType.STARTED_WITH_END);
        RuleDAOTest.assertEquals((int)2, (int)this.ruleDAO.findRulesIdsByFilter(filter, 0, 10).size());
        filter.setDateFilterType(DateFilterType.STARTED);
        RuleDAOTest.assertEquals((int)2, (int)this.ruleDAO.findRulesIdsByFilter(filter, 0, 10).size());
        filter.setDateFilterType(DateFilterType.ALL);
        ruleEntityEnded.setEnabled(false);
        this.ruleDAO.update((Object)ruleEntityEnded);
        filter.setStatus(EntityStatusType.ENABLED);
        RuleDAOTest.assertEquals((int)3, (int)this.ruleDAO.findRulesIdsByFilter(filter, 0, 10).size());
        filter.setStatus(EntityStatusType.DISABLED);
        RuleDAOTest.assertEquals((int)1, (int)this.ruleDAO.findRulesIdsByFilter(filter, 0, 10).size());
    }

    @Test
    public void testSortRulesByFilter() {
        RuleFilter filter = new RuleFilter();
        filter.setAllSpaces(true);
        ProgramEntity domainEntity1 = this.newDomain();
        ProgramEntity domainEntity2 = this.newDomain();
        List rules = this.ruleDAO.findRulesIdsByFilter(filter, 0, 10);
        RuleDAOTest.assertEquals((int)0, (int)rules.size());
        RuleEntity rule1 = this.newRule("rule1", domainEntity1.getId());
        rule1.setScore(10);
        rule1.setStartDate(Date.from(LocalDate.now().atStartOfDay().plusDays(1L).toInstant(ZoneOffset.UTC)));
        rule1.setEndDate(null);
        this.ruleDAO.update((Object)rule1);
        RuleEntity rule2 = this.newRule("rule2", domainEntity1.getId());
        rule2.setScore(5);
        rule2.setStartDate(Date.from(LocalDate.now().atStartOfDay().toInstant(ZoneOffset.UTC)));
        rule2.setEndDate(Date.from(LocalDate.now().atStartOfDay().plusDays(5L).toInstant(ZoneOffset.UTC)));
        this.ruleDAO.update((Object)rule2);
        RuleEntity rule3 = this.newRule("rule3", domainEntity2.getId());
        rule3.setScore(50);
        rule3.setStartDate(Date.from(LocalDate.now().atStartOfDay().minusDays(1L).toInstant(ZoneOffset.UTC)));
        rule3.setEndDate(Date.from(LocalDate.now().atStartOfDay().plusDays(3L).toInstant(ZoneOffset.UTC)));
        this.ruleDAO.update((Object)rule3);
        rules = this.ruleDAO.findRulesIdsByFilter(filter, 0, 10);
        RuleDAOTest.assertEquals((int)3, (int)rules.size());
        RuleDAOTest.assertEquals((Object)rule3.getId(), rules.get(0));
        RuleDAOTest.assertEquals((Object)rule1.getId(), rules.get(1));
        RuleDAOTest.assertEquals((Object)rule2.getId(), rules.get(2));
        filter.setSortBy("Score");
        rules = this.ruleDAO.findRulesIdsByFilter(filter, 0, 10);
        RuleDAOTest.assertEquals((int)3, (int)rules.size());
        RuleDAOTest.assertEquals((Object)rule3.getId(), rules.get(0));
        RuleDAOTest.assertEquals((Object)rule1.getId(), rules.get(1));
        RuleDAOTest.assertEquals((Object)rule2.getId(), rules.get(2));
        filter.setSortBy("Score");
        filter.setSortDescending(false);
        rules = this.ruleDAO.findRulesIdsByFilter(filter, 0, 10);
        RuleDAOTest.assertEquals((int)3, (int)rules.size());
        RuleDAOTest.assertEquals((Object)rule2.getId(), rules.get(0));
        RuleDAOTest.assertEquals((Object)rule1.getId(), rules.get(1));
        RuleDAOTest.assertEquals((Object)rule3.getId(), rules.get(2));
        filter.setSortBy("createdDate");
        filter.setSortDescending(true);
        rules = this.ruleDAO.findRulesIdsByFilter(filter, 0, 10);
        RuleDAOTest.assertEquals((int)3, (int)rules.size());
        RuleDAOTest.assertEquals((Object)rule3.getId(), rules.get(0));
        RuleDAOTest.assertEquals((Object)rule2.getId(), rules.get(1));
        RuleDAOTest.assertEquals((Object)rule1.getId(), rules.get(2));
        filter.setSortBy("createdDate");
        filter.setSortDescending(false);
        rules = this.ruleDAO.findRulesIdsByFilter(filter, 0, 10);
        RuleDAOTest.assertEquals((int)3, (int)rules.size());
        RuleDAOTest.assertEquals((Object)rule1.getId(), rules.get(0));
        RuleDAOTest.assertEquals((Object)rule2.getId(), rules.get(1));
        RuleDAOTest.assertEquals((Object)rule3.getId(), rules.get(2));
        filter.setSortBy("startDate");
        filter.setSortDescending(true);
        rules = this.ruleDAO.findRulesIdsByFilter(filter, 0, 10);
        RuleDAOTest.assertEquals((int)3, (int)rules.size());
        RuleDAOTest.assertEquals((Object)rule1.getId(), rules.get(0));
        RuleDAOTest.assertEquals((Object)rule2.getId(), rules.get(1));
        RuleDAOTest.assertEquals((Object)rule3.getId(), rules.get(2));
        filter.setSortBy("startDate");
        filter.setSortDescending(false);
        rules = this.ruleDAO.findRulesIdsByFilter(filter, 0, 10);
        RuleDAOTest.assertEquals((int)3, (int)rules.size());
        RuleDAOTest.assertEquals((Object)rule3.getId(), rules.get(0));
        RuleDAOTest.assertEquals((Object)rule2.getId(), rules.get(1));
        RuleDAOTest.assertEquals((Object)rule1.getId(), rules.get(2));
        filter.setSortBy("endDate");
        filter.setSortDescending(true);
        rules = this.ruleDAO.findRulesIdsByFilter(filter, 0, 10);
        RuleDAOTest.assertEquals((int)3, (int)rules.size());
        RuleDAOTest.assertEquals((Object)rule1.getId(), rules.get(0));
        RuleDAOTest.assertEquals((Object)rule2.getId(), rules.get(1));
        RuleDAOTest.assertEquals((Object)rule3.getId(), rules.get(2));
        filter.setSortBy("endDate");
        filter.setSortDescending(false);
        rules = this.ruleDAO.findRulesIdsByFilter(filter, 0, 10);
        RuleDAOTest.assertEquals((int)3, (int)rules.size());
        RuleDAOTest.assertEquals((Object)rule1.getId(), rules.get(0));
        RuleDAOTest.assertEquals((Object)rule3.getId(), rules.get(1));
        RuleDAOTest.assertEquals((Object)rule2.getId(), rules.get(2));
        filter.setSortBy("endDate");
        filter.setSortDescending(true);
        filter.setDateFilterType(DateFilterType.STARTED_WITH_END);
        rules = this.ruleDAO.findRulesIdsByFilter(filter, 0, 10);
        RuleDAOTest.assertEquals((int)2, (int)rules.size());
        RuleDAOTest.assertEquals((Object)rule2.getId(), rules.get(0));
        RuleDAOTest.assertEquals((Object)rule3.getId(), rules.get(1));
        filter.setSortBy("title");
        filter.setSortDescending(true);
        filter.setDateFilterType(null);
        rules = this.ruleDAO.findRulesIdsByFilter(filter, 0, 10);
        RuleDAOTest.assertEquals((int)3, (int)rules.size());
        RuleDAOTest.assertEquals((Object)rule3.getId(), rules.get(0));
        RuleDAOTest.assertEquals((Object)rule2.getId(), rules.get(1));
        RuleDAOTest.assertEquals((Object)rule1.getId(), rules.get(2));
        filter.setSortBy("title");
        filter.setSortDescending(false);
        filter.setDateFilterType(null);
        rules = this.ruleDAO.findRulesIdsByFilter(filter, 0, 10);
        RuleDAOTest.assertEquals((int)3, (int)rules.size());
        RuleDAOTest.assertEquals((Object)rule1.getId(), rules.get(0));
        RuleDAOTest.assertEquals((Object)rule2.getId(), rules.get(1));
        RuleDAOTest.assertEquals((Object)rule3.getId(), rules.get(2));
    }

    @Test
    public void testCountRulesByFilter() {
        RuleFilter filter = new RuleFilter();
        ProgramEntity domainEntity = this.newDomain();
        ProgramEntity domainEntity2 = this.newDomain();
        RuleDAOTest.assertEquals((int)0, (int)this.ruleDAO.countRulesByFilter(filter));
        this.newRule("rule1", domainEntity.getId());
        filter.setProgramId(domainEntity.getId().longValue());
        filter.setSpaceIds(Collections.singletonList(domainEntity.getAudienceId()));
        RuleDAOTest.assertEquals((int)1, (int)this.ruleDAO.countRulesByFilter(filter));
        this.newRule("rule2", domainEntity.getId());
        RuleDAOTest.assertEquals((int)2, (int)this.ruleDAO.countRulesByFilter(filter));
        this.newRule("rule3", domainEntity2.getId());
        RuleDAOTest.assertEquals((int)2, (int)this.ruleDAO.countRulesByFilter(filter));
    }

    private RuleEntity newOpenRule(int score, String title, Long domainId) {
        RuleEntity ruleEntity = this.newRule(title, domainId);
        ruleEntity.setScore(score);
        return (RuleEntity)this.ruleDAO.update((Object)ruleEntity);
    }
}

