/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.dao;

import io.meeds.gamification.constant.EntityType;
import io.meeds.gamification.constant.IdentityType;
import io.meeds.gamification.constant.RealizationStatus;
import io.meeds.gamification.dao.RealizationDAO;
import io.meeds.gamification.entity.AbstractAuditingEntity;
import io.meeds.gamification.entity.ProgramEntity;
import io.meeds.gamification.entity.RealizationEntity;
import io.meeds.gamification.entity.RuleEntity;
import io.meeds.gamification.model.PiechartLeaderboard;
import io.meeds.gamification.model.ProfileReputation;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.StandardLeaderboard;
import io.meeds.gamification.model.filter.RealizationFilter;
import io.meeds.gamification.test.AbstractServiceTest;
import io.meeds.gamification.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.Test;

public class RealizationDAOTest
extends AbstractServiceTest {
    @Test
    public void testGetLeaderboardRank() {
        RealizationDAOTest.assertEquals((int)0, (int)this.realizationDAO.getLeaderboardRank(IdentityType.USER, "1"));
        ProgramEntity domainEntity1 = this.newDomain();
        RealizationEntity realizationEntity1 = this.newRealizationEntity("rule", domainEntity1.getId());
        RealizationDAOTest.assertEquals((int)1, (int)this.realizationDAO.getLeaderboardRank(IdentityType.USER, "1"));
        realizationEntity1.setStatus(RealizationStatus.REJECTED);
        this.realizationDAO.update((Object)realizationEntity1);
        this.restartTransaction();
        RealizationDAOTest.assertEquals((int)0, (int)this.realizationDAO.getLeaderboardRank(IdentityType.USER, "1"));
        ProgramEntity domainEntity2 = this.newDomain();
        this.newRealizationEntity("rule", domainEntity2.getId());
        RealizationDAOTest.assertEquals((int)1, (int)this.realizationDAO.getLeaderboardRank(IdentityType.USER, "1"));
        RealizationDAOTest.assertEquals((int)1, (int)this.realizationDAO.getLeaderboardRankByDate(IdentityType.USER, "1", this.fromDate));
        RealizationDAOTest.assertEquals((int)0, (int)this.realizationDAO.getLeaderboardRankByDate(IdentityType.USER, "1", this.toDate));
        RealizationDAOTest.assertEquals((int)1, (int)this.realizationDAO.getLeaderboardRankByProgramId(IdentityType.USER, "1", domainEntity2.getId().longValue()));
        RealizationDAOTest.assertEquals((int)0, (int)this.realizationDAO.getLeaderboardRankByProgramId(IdentityType.USER, "1", domainEntity1.getId().longValue()));
        RealizationDAOTest.assertEquals((int)0, (int)this.realizationDAO.getLeaderboardRankByDateAndProgramId(IdentityType.USER, "1", this.fromDate, domainEntity1.getId().longValue()));
        RealizationDAOTest.assertEquals((int)0, (int)this.realizationDAO.getLeaderboardRankByDateAndProgramId(IdentityType.USER, "1", this.toDate, domainEntity2.getId().longValue()));
        RealizationDAOTest.assertEquals((int)1, (int)this.realizationDAO.getLeaderboardRankByDateAndProgramId(IdentityType.USER, "1", this.fromDate, domainEntity2.getId().longValue()));
        RealizationDAOTest.assertEquals((int)0, (int)this.realizationDAO.getLeaderboardRankByDateAndProgramId(IdentityType.USER, "1", this.toDate, domainEntity1.getId().longValue()));
    }

    @Test
    public void testGetLeaderboard() {
        RealizationDAOTest.assertEquals((int)0, (int)this.realizationDAO.getLeaderboard(IdentityType.USER, 0, 10).size());
        ProgramEntity domainEntity = this.newDomain();
        RealizationEntity realizationEntity = this.newRealizationEntity("rule", domainEntity.getId());
        this.newRealizationEntity("rule", domainEntity.getId());
        this.newRealizationEntity("rule", domainEntity.getId());
        List leaderboardList = this.realizationDAO.getLeaderboard(IdentityType.USER, 0, 10);
        RealizationDAOTest.assertEquals((int)1, (int)leaderboardList.size());
        RealizationDAOTest.assertEquals((String)"1", (String)((StandardLeaderboard)leaderboardList.get(0)).getEarnerId());
        RealizationDAOTest.assertEquals((long)((long)Integer.parseInt("50") * 3L), (long)((StandardLeaderboard)leaderboardList.get(0)).getReputationScore());
        realizationEntity.setStatus(RealizationStatus.REJECTED);
        this.realizationDAO.update((Object)realizationEntity);
        leaderboardList = this.realizationDAO.getLeaderboard(IdentityType.USER, 0, 10);
        RealizationDAOTest.assertEquals((int)1, (int)leaderboardList.size());
        RealizationDAOTest.assertEquals((String)"1", (String)((StandardLeaderboard)leaderboardList.get(0)).getEarnerId());
        RealizationDAOTest.assertEquals((long)((long)Integer.parseInt("50") * 2L), (long)((StandardLeaderboard)leaderboardList.get(0)).getReputationScore());
    }

    @Test
    public void testFindActionHistoryByActionTitleAndEarnerIdAndReceiverAndObjectId() {
        ProgramEntity domainEntity = this.newDomain();
        RealizationEntity realizationEntity = this.newRealizationEntity("rule", domainEntity.getId());
        RealizationDAOTest.assertNotNull((Object)this.realizationDAO.findLastRealizationByRuleIdAndEarnerIdAndReceiverAndObjectId(realizationEntity.getRuleEntity().getId().longValue(), "1", "1", "objectId", "objectType"));
    }

    @Test
    public void testFindAllActionsHistoryByDateByDomain() {
        ProgramEntity domainEntity = this.newDomain();
        RealizationDAOTest.assertEquals((int)0, (int)this.realizationDAO.getLeaderboardByDateAndProgramId(this.fromDate, IdentityType.USER, domainEntity.getId().longValue(), 0, 10).size());
        RealizationEntity realizationEntity = this.newRealizationEntity("rule", domainEntity.getId());
        this.newRealizationEntity("rule", domainEntity.getId());
        this.newRealizationEntity("rule", domainEntity.getId());
        List leaderboardList = this.realizationDAO.getLeaderboardByDateAndProgramId(this.fromDate, IdentityType.USER, domainEntity.getId().longValue(), 0, 10);
        RealizationDAOTest.assertEquals((int)leaderboardList.size(), (int)1);
        RealizationDAOTest.assertEquals((String)((StandardLeaderboard)leaderboardList.get(0)).getEarnerId(), (String)"1");
        RealizationDAOTest.assertEquals((long)((StandardLeaderboard)leaderboardList.get(0)).getReputationScore(), (long)((long)Integer.parseInt("50") * 3L));
        realizationEntity.setStatus(RealizationStatus.REJECTED);
        this.realizationDAO.update((Object)realizationEntity);
        leaderboardList = this.realizationDAO.getLeaderboard(IdentityType.USER, 0, 10);
        RealizationDAOTest.assertEquals((int)leaderboardList.size(), (int)1);
        RealizationDAOTest.assertEquals((String)((StandardLeaderboard)leaderboardList.get(0)).getEarnerId(), (String)"1");
        RealizationDAOTest.assertEquals((long)((StandardLeaderboard)leaderboardList.get(0)).getReputationScore(), (long)((long)Integer.parseInt("50") * 2L));
    }

    @Test
    public void testFindAllActionsHistoryByDomain() {
        ProgramEntity domainEntity = this.newDomain();
        RealizationDAOTest.assertEquals((int)0, (int)this.realizationDAO.getLeaderboardByProgramId(domainEntity.getId().longValue(), IdentityType.USER, 0, 10).size());
        RealizationEntity realizationEntity = this.newRealizationEntity("rule", domainEntity.getId());
        this.newRealizationEntity("rule", domainEntity.getId());
        this.newRealizationEntity("rule", domainEntity.getId());
        List leaderboardList = this.realizationDAO.getLeaderboardByProgramId(domainEntity.getId().longValue(), IdentityType.USER, 0, 10);
        RealizationDAOTest.assertEquals((int)leaderboardList.size(), (int)1);
        RealizationDAOTest.assertEquals((String)((StandardLeaderboard)leaderboardList.get(0)).getEarnerId(), (String)"1");
        RealizationDAOTest.assertEquals((long)((StandardLeaderboard)leaderboardList.get(0)).getReputationScore(), (long)((long)Integer.parseInt("50") * 3L));
        realizationEntity.setStatus(RealizationStatus.REJECTED);
        this.realizationDAO.update((Object)realizationEntity);
        leaderboardList = this.realizationDAO.getLeaderboard(IdentityType.USER, 0, 10);
        RealizationDAOTest.assertEquals((int)leaderboardList.size(), (int)1);
        RealizationDAOTest.assertEquals((String)((StandardLeaderboard)leaderboardList.get(0)).getEarnerId(), (String)"1");
        RealizationDAOTest.assertEquals((long)((StandardLeaderboard)leaderboardList.get(0)).getReputationScore(), (long)((long)Integer.parseInt("50") * 2L));
    }

    @Test
    public void testFindAllActionsHistoryByDate() {
        RealizationDAOTest.assertEquals((int)this.realizationDAO.getLeaderboardByDate(this.fromDate, IdentityType.USER, 0, 10).size(), (int)0);
        ProgramEntity domainEntity = this.newDomain();
        RealizationEntity realizationEntity = this.newRealizationEntity("rule", domainEntity.getId());
        this.newRealizationEntity("rule", domainEntity.getId());
        this.newRealizationEntity("rule", domainEntity.getId());
        List leaderboardList = this.realizationDAO.getLeaderboardByDate(this.fromDate, IdentityType.USER, 0, 10);
        RealizationDAOTest.assertEquals((int)1, (int)leaderboardList.size());
        RealizationDAOTest.assertEquals((String)"1", (String)((StandardLeaderboard)leaderboardList.get(0)).getEarnerId());
        RealizationDAOTest.assertEquals((long)((long)Integer.parseInt("50") * 3L), (long)((StandardLeaderboard)leaderboardList.get(0)).getReputationScore());
        realizationEntity.setStatus(RealizationStatus.REJECTED);
        this.realizationDAO.update((Object)realizationEntity);
        leaderboardList = this.realizationDAO.getLeaderboardByDate(this.fromDate, IdentityType.USER, 0, 10);
        RealizationDAOTest.assertEquals((int)1, (int)leaderboardList.size());
        RealizationDAOTest.assertEquals((String)"1", (String)((StandardLeaderboard)leaderboardList.get(0)).getEarnerId());
        RealizationDAOTest.assertEquals((long)(Integer.parseInt("50") * 2), (long)((StandardLeaderboard)leaderboardList.get(0)).getReputationScore());
    }

    @Test
    public void testFindAllActionsHistory() {
        RealizationDAOTest.assertEquals((int)this.realizationDAO.getLeaderboard(IdentityType.USER, 0, 3).size(), (int)0);
        ProgramEntity domainEntity = this.newDomain();
        RealizationEntity realizationEntity = this.newRealizationEntity("rule", domainEntity.getId());
        this.newRealizationEntity("rule", domainEntity.getId());
        this.newRealizationEntity("rule", domainEntity.getId());
        List leaderboardList = this.realizationDAO.getLeaderboard(IdentityType.USER, 0, 3);
        RealizationDAOTest.assertEquals((int)1, (int)leaderboardList.size());
        RealizationDAOTest.assertEquals((String)"1", (String)((StandardLeaderboard)leaderboardList.get(0)).getEarnerId());
        RealizationDAOTest.assertEquals((long)((long)Integer.parseInt("50") * 3L), (long)((StandardLeaderboard)leaderboardList.get(0)).getReputationScore());
        realizationEntity.setStatus(RealizationStatus.REJECTED);
        this.realizationDAO.update((Object)realizationEntity);
        leaderboardList = this.realizationDAO.getLeaderboardByDate(this.fromDate, IdentityType.USER, 0, 10);
        RealizationDAOTest.assertEquals((int)1, (int)leaderboardList.size());
        RealizationDAOTest.assertEquals((String)"1", (String)((StandardLeaderboard)leaderboardList.get(0)).getEarnerId());
        RealizationDAOTest.assertEquals((long)((long)Integer.parseInt("50") * 2L), (long)((StandardLeaderboard)leaderboardList.get(0)).getReputationScore());
    }

    @Test
    public void testFindActionsHistoryByDateByDomain() {
        ProgramEntity domainEntity = this.newDomain();
        RealizationDAOTest.assertEquals((int)this.realizationDAO.getLeaderboardByDateAndProgramId(this.fromDate, IdentityType.USER, domainEntity.getId().longValue(), 0, 3).size(), (int)0);
        this.newRealizationEntity("rule", domainEntity.getId());
        this.newRealizationEntity("rule", domainEntity.getId());
        this.newRealizationEntity("rule", domainEntity.getId());
        List leaderboardList = this.realizationDAO.getLeaderboardByDateAndProgramId(this.fromDate, IdentityType.USER, domainEntity.getId().longValue(), 0, 3);
        RealizationDAOTest.assertEquals((int)leaderboardList.size(), (int)1);
        RealizationDAOTest.assertEquals((String)((StandardLeaderboard)leaderboardList.get(0)).getEarnerId(), (String)"1");
        RealizationDAOTest.assertEquals((long)((StandardLeaderboard)leaderboardList.get(0)).getReputationScore(), (long)((long)Integer.parseInt("50") * 3L));
    }

    @Test
    public void testFindStatsByUserId() {
        RealizationDAOTest.assertEquals((int)this.realizationDAO.getLeaderboardStatsByIdentityId("1", this.fromDate, this.toDate).size(), (int)0);
        ProgramEntity domainEntity = this.newDomain();
        this.newRealizationEntity("rule", domainEntity.getId());
        this.newRealizationEntity("rule", domainEntity.getId());
        this.newRealizationEntity("rule", domainEntity.getId());
        List pieChartLeaderboardList = this.realizationDAO.getLeaderboardStatsByIdentityId("1", this.fromDate, this.toDate);
        RealizationDAOTest.assertEquals((int)pieChartLeaderboardList.size(), (int)1);
        PiechartLeaderboard piechartLeaderboard = (PiechartLeaderboard)pieChartLeaderboardList.get(0);
        ProgramDTO program = this.programService.getProgramById(piechartLeaderboard.getProgramId());
        RealizationDAOTest.assertNotNull((Object)program);
        RealizationDAOTest.assertEquals((String)"TeamWork", (String)program.getTitle());
    }

    @Test
    public void testFindStatsByUserIdWhenProgramDeleted() {
        RealizationDAOTest.assertTrue((boolean)this.realizationDAO.getLeaderboardStatsByIdentityId("1", this.fromDate, this.toDate).isEmpty());
        ProgramEntity domainEntity = this.newDomain();
        RuleEntity rule = this.newRule("rule", domainEntity.getId());
        RealizationEntity realization1 = this.newRealizationByRuleByEarnerId(rule, "1");
        RealizationEntity realization2 = this.newRealizationByRuleByEarnerId(rule, "1");
        RealizationEntity realization3 = this.newRealizationByRuleByEarnerId(rule, "1");
        RealizationDAOTest.assertEquals((int)1, (int)this.realizationDAO.getLeaderboardStatsByIdentityId("1", this.fromDate, this.toDate).size());
        realization1.setDomainEntity(null);
        this.realizationDAO.update((Object)realization1);
        realization2.setDomainEntity(null);
        this.realizationDAO.update((Object)realization2);
        realization3.setDomainEntity(null);
        this.realizationDAO.update((Object)realization3);
        RealizationDAOTest.assertTrue((boolean)this.realizationDAO.getLeaderboardStatsByIdentityId("1", this.fromDate, this.toDate).isEmpty());
    }

    @Test
    public void testFindDomainScoreByIdentityId() {
        ProgramEntity domainEntity = this.newDomain();
        RealizationDAOTest.assertEquals((int)this.realizationDAO.getScorePerProgramByIdentityId("1").size(), (int)0);
        this.newRealizationEntity("rule", domainEntity.getId());
        this.newRealizationEntity("rule", domainEntity.getId());
        this.newRealizationEntity("rule", domainEntity.getId());
        RealizationDAOTest.assertEquals((int)1, (int)this.realizationDAO.getScorePerProgramByIdentityId("1").size());
        RealizationDAOTest.assertEquals((long)((long)Integer.parseInt("50") * 3L), (long)((ProfileReputation)this.realizationDAO.getScorePerProgramByIdentityId("1").get(0)).getScore());
    }

    @Test
    public void testFindUserReputationScoreBetweenDate() {
        RealizationDAOTest.assertEquals((long)this.realizationDAO.getScoreByIdentityIdAndBetweenDates("1", this.fromDate, this.toDate), (long)0L);
        ProgramEntity domainEntity = this.newDomain();
        RealizationEntity realizationEntity = this.newRealizationEntity("rule", domainEntity.getId());
        this.newRealizationEntity("rule", domainEntity.getId());
        this.newRealizationEntity("rule", domainEntity.getId());
        RealizationDAOTest.assertEquals((long)((long)Integer.parseInt("50") * 3L), (long)this.realizationDAO.getScoreByIdentityIdAndBetweenDates("1", this.fromDate, this.toDate));
        realizationEntity.setStatus(RealizationStatus.REJECTED);
        this.realizationDAO.update((Object)realizationEntity);
        RealizationDAOTest.assertEquals((long)((long)Integer.parseInt("50") * 2L), (long)this.realizationDAO.getScoreByIdentityIdAndBetweenDates("1", this.fromDate, this.toDate));
    }

    @Test
    public void testFindUsersReputationScoreBetweenDate() {
        ArrayList<String> earnersId = new ArrayList<String>();
        earnersId.add("1");
        Map scores = this.realizationDAO.getScoreByIdentityIdsAndBetweenDates(earnersId, this.fromDate, this.toDate);
        RealizationDAOTest.assertEquals((Object)0L, (Object)Optional.ofNullable((Long)scores.get(Long.parseLong("1"))).orElse(0L));
        ProgramEntity domainEntity = this.newDomain();
        RealizationEntity realizationEntity = this.newRealizationEntity("rule", domainEntity.getId());
        this.newRealizationEntity("rule", domainEntity.getId());
        this.newRealizationEntity("rule", domainEntity.getId());
        scores = this.realizationDAO.getScoreByIdentityIdsAndBetweenDates(earnersId, this.fromDate, this.toDate);
        Long expected = (long)Integer.parseInt("50") * 3L;
        RealizationDAOTest.assertEquals((Object)expected, (Object)Optional.ofNullable((Long)scores.get(Long.parseLong("1"))).orElse(0L));
        realizationEntity.setStatus(RealizationStatus.REJECTED);
        this.realizationDAO.update((Object)realizationEntity);
        expected = (long)Integer.parseInt("50") * 2L;
        scores = this.realizationDAO.getScoreByIdentityIdsAndBetweenDates(earnersId, this.fromDate, this.toDate);
        RealizationDAOTest.assertEquals((Object)expected, (Object)Optional.ofNullable((Long)scores.get(Long.parseLong("1"))).orElse(0L));
    }

    @Test
    public void testFindAllRealizationsByFilterSortByActionType() {
        RuleEntity rule1Automatic = this.newRule("testFindRealizationsByFilterSortByActionType1", "domain1", true, EntityType.AUTOMATIC);
        RuleEntity rule2Automatic = this.newRule("testFindRealizationsByFilterSortByActionType2", "domain2", true, EntityType.AUTOMATIC);
        RuleEntity rule3Manual = this.newRule("testFindRealizationsByFilterSortByActionType3", "domain3", true, EntityType.MANUAL);
        ArrayList<RealizationEntity> histories = new ArrayList<RealizationEntity>();
        histories.add(this.newRealizationEntityWithRuleId(rule1Automatic.getEventEntity().getTitle(), rule1Automatic.getId()));
        histories.add(this.newRealizationEntityWithRuleId("", rule3Manual.getId()));
        histories.add(this.newRealizationEntityWithRuleId("", rule1Automatic.getId()));
        histories.add(this.newRealizationEntityWithRuleId(rule3Manual.getEventEntity().getTitle(), rule3Manual.getId()));
        histories.add(this.newRealizationEntityWithRuleId("", rule2Automatic.getId()));
        histories.add(this.newRealizationEntityWithRuleId(rule2Automatic.getEventEntity().getTitle(), rule2Automatic.getId()));
        histories.add(this.newRealizationEntityWithRuleId("", rule3Manual.getId()));
        RealizationFilter dateFilter = new RealizationFilter();
        List domainIds = Collections.emptyList();
        dateFilter.setFromDate(this.fromDate);
        dateFilter.setToDate(this.toDate);
        dateFilter.setSortField("type");
        dateFilter.setSortDescending(true);
        dateFilter.setEarnerIds(new ArrayList());
        dateFilter.setEarnerType(IdentityType.getType((String)""));
        dateFilter.setProgramIds(domainIds);
        List ids = this.realizationDAO.findRealizationsByFilter(dateFilter, 0, 2);
        RealizationDAOTest.assertNotNull((Object)ids);
        RealizationDAOTest.assertEquals((int)2, (int)ids.size());
        RealizationDAOTest.assertEquals(Arrays.asList(((RealizationEntity)histories.get(6)).getId(), ((RealizationEntity)histories.get(3)).getId()), (Object)ids);
        ids = this.realizationDAO.findRealizationsByFilter(dateFilter, 0, 4);
        RealizationDAOTest.assertNotNull((Object)ids);
        RealizationDAOTest.assertEquals((int)4, (int)ids.size());
        RealizationDAOTest.assertEquals(Arrays.asList(((RealizationEntity)histories.get(6)).getId(), ((RealizationEntity)histories.get(3)).getId(), ((RealizationEntity)histories.get(1)).getId(), ((RealizationEntity)histories.get(5)).getId()), (Object)ids);
        dateFilter.setSortDescending(false);
        ids = this.realizationDAO.findRealizationsByFilter(dateFilter, 0, 2);
        RealizationDAOTest.assertNotNull((Object)ids);
        RealizationDAOTest.assertEquals((int)2, (int)ids.size());
        RealizationDAOTest.assertEquals(Arrays.asList(((RealizationEntity)histories.get(5)).getId(), ((RealizationEntity)histories.get(4)).getId()), (Object)ids);
        ids = this.realizationDAO.findRealizationsByFilter(dateFilter, 2, 6);
        RealizationDAOTest.assertNotNull((Object)ids);
        RealizationDAOTest.assertEquals((int)5, (int)ids.size());
        RealizationDAOTest.assertEquals(Arrays.asList(((RealizationEntity)histories.get(2)).getId(), ((RealizationEntity)histories.get(0)).getId(), ((RealizationEntity)histories.get(6)).getId(), ((RealizationEntity)histories.get(3)).getId(), ((RealizationEntity)histories.get(1)).getId()), (Object)ids);
    }

    @Test
    public void testFindAllRealizationsByFilter() {
        RealizationFilter dateFilter = new RealizationFilter();
        List domainIds = Collections.emptyList();
        dateFilter.setFromDate(this.fromDate);
        dateFilter.setToDate(this.toDate);
        dateFilter.setSortField("date");
        dateFilter.setEarnerIds(new ArrayList());
        dateFilter.setEarnerType(IdentityType.getType((String)""));
        dateFilter.setProgramIds(domainIds);
        List filteredRealizations = this.realizationDAO.findRealizationsByFilter(dateFilter, 0, 3);
        RealizationDAOTest.assertEquals((int)0, (int)filteredRealizations.size());
        ArrayList<RealizationEntity> createdActionHistories = new ArrayList<RealizationEntity>();
        ProgramEntity domainEntity = this.newDomain();
        long domainId = domainEntity.getId();
        for (int i = 0; i < 6; ++i) {
            createdActionHistories.add(this.newRealizationEntity("rule", domainId));
        }
        filteredRealizations = this.realizationDAO.findRealizationsByFilter(dateFilter, 0, 3);
        RealizationDAOTest.assertEquals((int)3, (int)filteredRealizations.size());
        RealizationDAOTest.assertEquals(createdActionHistories.subList(0, 3).stream().map(RealizationEntity::getId).toList(), (Object)filteredRealizations);
        dateFilter.setSortField("date");
        dateFilter.setSortDescending(false);
        filteredRealizations = this.realizationDAO.findRealizationsByFilter(dateFilter, 0, 3);
        RealizationDAOTest.assertEquals((int)3, (int)filteredRealizations.size());
        RealizationDAOTest.assertEquals(createdActionHistories.subList(0, 3).stream().map(RealizationEntity::getId).toList(), (Object)filteredRealizations);
        dateFilter.setSortField("date");
        dateFilter.setSortDescending(true);
        filteredRealizations = this.realizationDAO.findRealizationsByFilter(dateFilter, 0, 3);
        Collections.reverse(createdActionHistories);
        RealizationDAOTest.assertEquals(createdActionHistories.subList(0, 3).stream().map(RealizationEntity::getId).toList(), (Object)filteredRealizations);
    }

    @Test
    public void testFindRealizationsByFilterSortByActionTypeInDateRange() {
        RuleEntity rule1Automatic = this.newRule("testFindRealizationsByFilterSortByActionType1", "domain1", true, EntityType.AUTOMATIC);
        RuleEntity rule2Automatic = this.newRule("testFindRealizationsByFilterSortByActionType2", "domain2", true, EntityType.AUTOMATIC);
        RuleEntity rule3Manual = this.newRule("testFindRealizationsByFilterSortByActionType3", "domain3", true, EntityType.MANUAL);
        ArrayList<RealizationEntity> histories = new ArrayList<RealizationEntity>();
        histories.add(this.newRealizationToBeSortedByActionTypeInDateRange(this.fromDate, rule1Automatic.getEventEntity().getTitle(), rule1Automatic.getId()));
        histories.add(this.newRealizationToBeSortedByActionTypeInDateRange(this.fromDate, "", rule3Manual.getId()));
        histories.add(this.newRealizationToBeSortedByActionTypeInDateRange(this.fromDate, "", rule1Automatic.getId()));
        histories.add(this.newRealizationToBeSortedByActionTypeInDateRange(this.fromDate, rule3Manual.getEventEntity().getTitle(), rule3Manual.getId()));
        histories.add(this.newRealizationToBeSortedByActionTypeInDateRange(this.fromDate, "", rule2Automatic.getId()));
        histories.add(this.newRealizationToBeSortedByActionTypeInDateRange(this.fromDate, rule2Automatic.getEventEntity().getTitle(), rule2Automatic.getId()));
        histories.add(this.newRealizationToBeSortedByActionTypeInDateRange(this.outOfRangeDate, rule3Manual.getEventEntity().getTitle(), rule3Manual.getId()));
        RealizationFilter dateFilter = new RealizationFilter();
        List domainIds = Collections.emptyList();
        dateFilter.setProgramIds(domainIds);
        dateFilter.setFromDate(this.fromDate);
        dateFilter.setToDate(this.toDate);
        dateFilter.setSortField("type");
        dateFilter.setSortDescending(true);
        dateFilter.setEarnerIds(new ArrayList());
        dateFilter.setEarnerType(IdentityType.getType((String)""));
        List ids = this.realizationDAO.findRealizationsByFilter(dateFilter, 0, 2);
        RealizationDAOTest.assertNotNull((Object)ids);
        RealizationDAOTest.assertEquals((int)2, (int)ids.size());
        RealizationDAOTest.assertEquals(Arrays.asList(((RealizationEntity)histories.get(3)).getId(), ((RealizationEntity)histories.get(1)).getId()), (Object)ids);
        RealizationDAOTest.assertTrue((boolean)ids.stream().map(arg_0 -> ((RealizationDAO)this.realizationDAO).find(arg_0)).map(AbstractAuditingEntity::getCreatedDate).map(this::isThisDateWithinThisRange).reduce(true, Boolean::logicalAnd));
        ids = this.realizationDAO.findRealizationsByFilter(dateFilter, 0, 3);
        RealizationDAOTest.assertNotNull((Object)ids);
        RealizationDAOTest.assertEquals((int)3, (int)ids.size());
        RealizationDAOTest.assertEquals(Arrays.asList(((RealizationEntity)histories.get(3)).getId(), ((RealizationEntity)histories.get(1)).getId(), ((RealizationEntity)histories.get(5)).getId()), (Object)ids);
        RealizationDAOTest.assertTrue((boolean)ids.stream().map(arg_0 -> ((RealizationDAO)this.realizationDAO).find(arg_0)).map(AbstractAuditingEntity::getCreatedDate).map(this::isThisDateWithinThisRange).reduce(true, Boolean::logicalAnd));
        dateFilter.setSortDescending(false);
        ids = this.realizationDAO.findRealizationsByFilter(dateFilter, 0, 2);
        RealizationDAOTest.assertNotNull((Object)ids);
        RealizationDAOTest.assertEquals((int)2, (int)ids.size());
        RealizationDAOTest.assertEquals(Arrays.asList(((RealizationEntity)histories.get(5)).getId(), ((RealizationEntity)histories.get(4)).getId()), (Object)ids);
        RealizationDAOTest.assertTrue((boolean)ids.stream().map(arg_0 -> ((RealizationDAO)this.realizationDAO).find(arg_0)).map(AbstractAuditingEntity::getCreatedDate).map(this::isThisDateWithinThisRange).reduce(true, Boolean::logicalAnd));
        ids = this.realizationDAO.findRealizationsByFilter(dateFilter, 2, 6);
        RealizationDAOTest.assertNotNull((Object)ids);
        RealizationDAOTest.assertEquals((int)4, (int)ids.size());
        RealizationDAOTest.assertEquals(Arrays.asList(((RealizationEntity)histories.get(2)).getId(), ((RealizationEntity)histories.get(0)).getId(), ((RealizationEntity)histories.get(3)).getId(), ((RealizationEntity)histories.get(1)).getId()), (Object)ids);
        RealizationDAOTest.assertTrue((boolean)ids.stream().map(arg_0 -> ((RealizationDAO)this.realizationDAO).find(arg_0)).map(AbstractAuditingEntity::getCreatedDate).map(this::isThisDateWithinThisRange).reduce(true, Boolean::logicalAnd));
    }

    @Test
    public void testFindAllRealizationsByFilterSortByStatus() {
        ArrayList<RealizationEntity> histories = new ArrayList<RealizationEntity>();
        histories.add(this.newRealizationsByStatus(RealizationStatus.ACCEPTED));
        histories.add(this.newRealizationsByStatus(RealizationStatus.REJECTED));
        histories.add(this.newRealizationsByStatus(RealizationStatus.ACCEPTED));
        RealizationFilter dateFilter = new RealizationFilter();
        List domainIds = Collections.emptyList();
        dateFilter.setProgramIds(domainIds);
        dateFilter.setFromDate(this.fromDate);
        dateFilter.setToDate(this.toDate);
        dateFilter.setSortField("status");
        dateFilter.setSortDescending(true);
        dateFilter.setEarnerIds(new ArrayList());
        dateFilter.setEarnerType(IdentityType.getType((String)""));
        List ids = this.realizationDAO.findRealizationsByFilter(dateFilter, 0, 2);
        RealizationDAOTest.assertNotNull((Object)ids);
        RealizationDAOTest.assertEquals((int)2, (int)ids.size());
        RealizationDAOTest.assertEquals(Arrays.asList(((RealizationEntity)histories.get(1)).getId(), ((RealizationEntity)histories.get(2)).getId()), (Object)ids);
        ids = this.realizationDAO.findRealizationsByFilter(dateFilter, 0, 3);
        RealizationDAOTest.assertNotNull((Object)ids);
        RealizationDAOTest.assertEquals((int)3, (int)ids.size());
        RealizationDAOTest.assertEquals(Arrays.asList(((RealizationEntity)histories.get(1)).getId(), ((RealizationEntity)histories.get(2)).getId(), ((RealizationEntity)histories.get(0)).getId()), (Object)ids);
        dateFilter.setSortDescending(false);
        ids = this.realizationDAO.findRealizationsByFilter(dateFilter, 0, 2);
        RealizationDAOTest.assertNotNull((Object)ids);
        RealizationDAOTest.assertEquals((int)2, (int)ids.size());
        RealizationDAOTest.assertEquals(Arrays.asList(((RealizationEntity)histories.get(2)).getId(), ((RealizationEntity)histories.get(0)).getId()), (Object)ids);
        ids = this.realizationDAO.findRealizationsByFilter(dateFilter, 0, 3);
        RealizationDAOTest.assertNotNull((Object)ids);
        RealizationDAOTest.assertEquals((int)3, (int)ids.size());
        RealizationDAOTest.assertEquals(Arrays.asList(((RealizationEntity)histories.get(2)).getId(), ((RealizationEntity)histories.get(0)).getId(), ((RealizationEntity)histories.get(1)).getId()), (Object)ids);
    }

    @Test
    public void testFindUsersRealizationsByConnectedUserType() {
        ArrayList<RealizationEntity> histories = new ArrayList<RealizationEntity>();
        histories.add(this.newRealizationsByEarnerId("1"));
        histories.add(this.newRealizationsByEarnerId("1"));
        histories.add(this.newRealizationsByEarnerId("1"));
        histories.add(this.newRealizationsByEarnerId("1"));
        histories.add(this.newRealizationsByEarnerId("1"));
        histories.add(this.newRealizationsByEarnerId("1"));
        histories.add(this.newRealizationsByEarnerId("2"));
        RealizationFilter dateFilter = new RealizationFilter();
        List domainIds = Collections.emptyList();
        dateFilter.setProgramIds(domainIds);
        dateFilter.setEarnerIds(new ArrayList<String>(Collections.singleton("1")));
        dateFilter.setFromDate(this.fromDate);
        dateFilter.setToDate(this.toDate);
        dateFilter.setSortField("type");
        dateFilter.setSortDescending(true);
        dateFilter.setEarnerType(IdentityType.getType((String)""));
        List result1 = this.realizationDAO.findRealizationsByFilter(dateFilter, 0, 6);
        RealizationDAOTest.assertNotNull((Object)result1);
        RealizationDAOTest.assertEquals((int)6, (int)result1.size());
        dateFilter.setEarnerIds(new ArrayList<String>(Collections.singleton("2")));
        List result3 = this.realizationDAO.findRealizationsByFilter(dateFilter, 0, 6);
        RealizationDAOTest.assertNotNull((Object)result3);
        RealizationDAOTest.assertEquals((int)1, (int)result3.size());
        dateFilter.setSortDescending(true);
        List result4 = this.realizationDAO.findRealizationsByFilter(dateFilter, 0, 6);
        RealizationDAOTest.assertNotNull((Object)result4);
        RealizationDAOTest.assertEquals((int)1, (int)result4.size());
        dateFilter.setSortField("date");
        dateFilter.setSortDescending(false);
        dateFilter.setEarnerIds(new ArrayList<String>(Collections.singleton("2")));
        List result7 = this.realizationDAO.findRealizationsByFilter(dateFilter, 0, 6);
        RealizationDAOTest.assertNotNull((Object)result7);
        RealizationDAOTest.assertEquals((int)1, (int)result7.size());
        dateFilter.setSortField("date");
        dateFilter.setSortDescending(true);
        List result8 = this.realizationDAO.findRealizationsByFilter(dateFilter, 0, 6);
        RealizationDAOTest.assertNotNull((Object)result8);
        RealizationDAOTest.assertEquals((int)1, (int)result8.size());
        dateFilter.setSortField("status");
        dateFilter.setSortDescending(false);
        dateFilter.setEarnerIds(new ArrayList<String>(Collections.singleton("2")));
        List result9 = this.realizationDAO.findRealizationsByFilter(dateFilter, 0, 6);
        RealizationDAOTest.assertNotNull((Object)result9);
        RealizationDAOTest.assertEquals((int)1, (int)result9.size());
        dateFilter.setSortField("status");
        dateFilter.setSortDescending(true);
        List result10 = this.realizationDAO.findRealizationsByFilter(dateFilter, 0, 6);
        RealizationDAOTest.assertNotNull((Object)result10);
        RealizationDAOTest.assertEquals((int)1, (int)result10.size());
    }

    @Test
    public void testFindAllRealizationsByDomainId() {
        Date createDate = new Date(System.currentTimeMillis());
        Date lastModifiedDate = new Date(System.currentTimeMillis() + 10L);
        ProgramDTO domain1 = new ProgramDTO();
        domain1.setTitle("domain1");
        domain1.setDescription("Description");
        domain1.setCreatedBy("1");
        domain1.setCreatedDate(Utils.toRFC3339Date((Date)createDate));
        domain1.setLastModifiedBy("1");
        domain1.setDeleted(false);
        domain1.setEnabled(true);
        domain1.setLastModifiedDate(Utils.toRFC3339Date((Date)lastModifiedDate));
        this.programService.createProgram(domain1);
        ProgramDTO domain2 = new ProgramDTO();
        domain2.setTitle("domain2");
        domain2.setDescription("Description");
        domain2.setCreatedBy("1");
        domain2.setCreatedDate(Utils.toRFC3339Date((Date)createDate));
        domain2.setLastModifiedBy("1");
        domain2.setDeleted(false);
        domain2.setEnabled(true);
        domain2.setLastModifiedDate(Utils.toRFC3339Date((Date)lastModifiedDate));
        this.programService.createProgram(domain2);
        RuleEntity rule1Automatic = this.newRule("domain1", "domain1", true, EntityType.AUTOMATIC);
        RuleEntity rule2Automatic = this.newRule("domain2", "domain2", true, EntityType.AUTOMATIC);
        RuleEntity rule3Manual = this.newRule("domain2", "domain2", true, EntityType.MANUAL);
        ArrayList<RealizationEntity> histories = new ArrayList<RealizationEntity>();
        histories.add(this.newRealizationByRuleByEarnerId(rule1Automatic, "1"));
        histories.add(this.newRealizationByRuleByEarnerId(rule1Automatic, "1"));
        histories.add(this.newRealizationByRuleByEarnerId(rule1Automatic, "1"));
        histories.add(this.newRealizationByRuleByEarnerId(rule2Automatic, "1"));
        histories.add(this.newRealizationByRuleByEarnerId(rule2Automatic, "1"));
        histories.add(this.newRealizationByRuleByEarnerId(rule2Automatic, "1"));
        histories.add(this.newRealizationByRuleByEarnerId(rule3Manual, "1"));
        RealizationFilter dateFilter = new RealizationFilter();
        ArrayList<Long> domainIds = new ArrayList<Long>();
        domainIds.add(rule1Automatic.getDomainEntity().getId());
        dateFilter.setProgramIds(domainIds);
        dateFilter.setEarnerIds(new ArrayList());
        dateFilter.setFromDate(this.fromDate);
        dateFilter.setToDate(this.toDate);
        dateFilter.setEarnerType(IdentityType.getType((String)""));
        List result = this.realizationDAO.findRealizationsByFilter(dateFilter, 0, 6);
        RealizationDAOTest.assertNotNull((Object)result);
        RealizationDAOTest.assertEquals((int)3, (int)result.size());
        RealizationDAOTest.assertEquals(Arrays.asList(((RealizationEntity)histories.get(0)).getId(), ((RealizationEntity)histories.get(1)).getId(), ((RealizationEntity)histories.get(2)).getId()), (Object)result);
    }

    @Test
    public void testFindAllRealizationsByDomainIdByActionType() {
        Date createDate = new Date(System.currentTimeMillis());
        Date lastModifiedDate = new Date(System.currentTimeMillis() + 10L);
        ProgramDTO domain1 = new ProgramDTO();
        domain1.setTitle("domain1");
        domain1.setDescription("Description");
        domain1.setCreatedBy("1");
        domain1.setCreatedDate(Utils.toRFC3339Date((Date)createDate));
        domain1.setLastModifiedBy("1");
        domain1.setDeleted(false);
        domain1.setEnabled(true);
        domain1.setLastModifiedDate(Utils.toRFC3339Date((Date)lastModifiedDate));
        this.programService.createProgram(domain1);
        ProgramDTO domain2 = new ProgramDTO();
        domain2.setTitle("domain2");
        domain2.setDescription("Description");
        domain2.setCreatedBy("1");
        domain2.setCreatedDate(Utils.toRFC3339Date((Date)createDate));
        domain2.setLastModifiedBy("1");
        domain2.setDeleted(false);
        domain2.setEnabled(true);
        domain2.setLastModifiedDate(Utils.toRFC3339Date((Date)lastModifiedDate));
        this.programService.createProgram(domain2);
        RuleEntity rule1Automatic = this.newRule("domain1", "domain1", true, EntityType.MANUAL);
        RuleEntity rule2Automatic = this.newRule("domain2", "domain2", true, EntityType.AUTOMATIC);
        RuleEntity rule3Manual = this.newRule("domain2", "domain1", true, EntityType.MANUAL);
        ArrayList<RealizationEntity> histories = new ArrayList<RealizationEntity>();
        histories.add(this.newRealizationByRuleByEarnerId(rule1Automatic, "1"));
        histories.add(this.newRealizationByRuleByEarnerId(rule1Automatic, "1"));
        histories.add(this.newRealizationByRuleByEarnerId(rule1Automatic, "1"));
        histories.add(this.newRealizationByRuleByEarnerId(rule2Automatic, "1"));
        histories.add(this.newRealizationByRuleByEarnerId(rule2Automatic, "1"));
        histories.add(this.newRealizationByRuleByEarnerId(rule2Automatic, "1"));
        histories.add(this.newRealizationByRuleByEarnerId(rule3Manual, "1"));
        RealizationFilter dateFilter = new RealizationFilter();
        ArrayList<Long> domainIds = new ArrayList<Long>();
        domainIds.add(rule1Automatic.getDomainEntity().getId());
        dateFilter.setProgramIds(domainIds);
        dateFilter.setEarnerIds(new ArrayList());
        dateFilter.setFromDate(this.fromDate);
        dateFilter.setToDate(this.toDate);
        dateFilter.setEarnerType(IdentityType.getType((String)""));
        dateFilter.setSortField("type");
        dateFilter.setSortDescending(true);
        List result = this.realizationDAO.findRealizationsByFilter(dateFilter, 0, 6);
        RealizationDAOTest.assertNotNull((Object)result);
        RealizationDAOTest.assertEquals((int)3, (int)result.size());
        RealizationDAOTest.assertEquals(Arrays.asList(((RealizationEntity)histories.get(2)).getId(), ((RealizationEntity)histories.get(1)).getId(), ((RealizationEntity)histories.get(0)).getId()), (Object)result);
    }

    @Test
    public void testFindAllRealizationsByDomainIdByEarnerId() {
        Date createDate = new Date(System.currentTimeMillis());
        Date lastModifiedDate = new Date(System.currentTimeMillis() + 10L);
        ProgramDTO domain1 = new ProgramDTO();
        domain1.setTitle("domain1");
        domain1.setDescription("Description");
        domain1.setCreatedBy("1");
        domain1.setCreatedDate(Utils.toRFC3339Date((Date)createDate));
        domain1.setLastModifiedBy("1");
        domain1.setDeleted(false);
        domain1.setEnabled(true);
        domain1.setLastModifiedDate(Utils.toRFC3339Date((Date)lastModifiedDate));
        this.programService.createProgram(domain1);
        ProgramDTO domain2 = new ProgramDTO();
        domain2.setTitle("domain2");
        domain2.setDescription("Description");
        domain2.setCreatedBy("1");
        domain2.setCreatedDate(Utils.toRFC3339Date((Date)createDate));
        domain2.setLastModifiedBy("1");
        domain2.setDeleted(false);
        domain2.setEnabled(true);
        domain2.setLastModifiedDate(Utils.toRFC3339Date((Date)lastModifiedDate));
        this.programService.createProgram(domain2);
        RuleEntity rule1Automatic = this.newRule("domain1", "domain1", true, EntityType.AUTOMATIC);
        RuleEntity rule2Automatic = this.newRule("domain2", "domain2", true, EntityType.AUTOMATIC);
        RuleEntity rule3Manual = this.newRule("domain2", "domain2", true, EntityType.MANUAL);
        ArrayList<RealizationEntity> histories = new ArrayList<RealizationEntity>();
        histories.add(this.newRealizationByRuleByEarnerId(rule1Automatic, "1"));
        histories.add(this.newRealizationByRuleByEarnerId(rule1Automatic, "2"));
        histories.add(this.newRealizationByRuleByEarnerId(rule1Automatic, "1"));
        histories.add(this.newRealizationByRuleByEarnerId(rule2Automatic, "1"));
        histories.add(this.newRealizationByRuleByEarnerId(rule2Automatic, "1"));
        histories.add(this.newRealizationByRuleByEarnerId(rule2Automatic, "1"));
        histories.add(this.newRealizationByRuleByEarnerId(rule3Manual, "1"));
        RealizationFilter dateFilter = new RealizationFilter();
        ArrayList<Long> domainIds = new ArrayList<Long>();
        domainIds.add(rule1Automatic.getDomainEntity().getId());
        dateFilter.setProgramIds(domainIds);
        dateFilter.setEarnerIds(new ArrayList<String>(Collections.singleton("1")));
        dateFilter.setFromDate(this.fromDate);
        dateFilter.setToDate(this.toDate);
        dateFilter.setEarnerType(IdentityType.getType((String)""));
        List result = this.realizationDAO.findRealizationsByFilter(dateFilter, 0, 6);
        RealizationDAOTest.assertNotNull((Object)result);
        RealizationDAOTest.assertEquals((int)2, (int)result.size());
        RealizationDAOTest.assertEquals(Arrays.asList(((RealizationEntity)histories.get(0)).getId(), ((RealizationEntity)histories.get(2)).getId()), (Object)result);
    }
}

