/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.service.injection;

import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import io.meeds.gamification.constant.EntityStatusType;
import io.meeds.gamification.constant.EntityType;
import io.meeds.gamification.model.EventDTO;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.ProgramDescriptor;
import io.meeds.gamification.model.ProgramDescriptorList;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.model.RuleDescriptor;
import io.meeds.gamification.model.RuleDescriptorList;
import io.meeds.gamification.model.filter.ProgramFilter;
import io.meeds.gamification.service.ProgramService;
import io.meeds.gamification.service.RuleService;
import io.meeds.gamification.service.injection.ProgramImportService$AjcClosure1;
import io.meeds.gamification.service.injection.ProgramTranslationImportService;
import io.meeds.gamification.utils.Utils;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ProgramImportService {
    private static final String DEFAULT_RULE_IMPORT = "DEFAULT_RULE_IMPORT";
    private static final Scope DEFAULT_RULE_IMPORT_SCOPE;
    private static final Scope DEFAULT_PROGRAM_IMPORT_SCOPE;
    private static final Context DEFAULT_PROGRAM_CONTEXT;
    private static final Log LOG;
    @Autowired
    private ProgramTranslationImportService programTranslationImportService;
    @Autowired
    private FileService fileService;
    @Autowired
    private ProgramService programService;
    @Autowired
    private RuleService ruleService;
    @Autowired
    private SettingService settingService;
    @Autowired
    private UserACL userAcl;
    @Value(value="${meeds.programs.import.override:false}")
    private boolean forceReimport;
    private final List<RuleDescriptor> rulesWithPrerequisite = new ArrayList<RuleDescriptor>();
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @PostConstruct
    public void init() {
        CompletableFuture.runAsync(this::importPrograms);
    }

    @ContainerTransactional
    public void importPrograms() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        ProgramImportService$AjcClosure1 programImportService$AjcClosure1 = new ProgramImportService$AjcClosure1(objectArray);
        ContainerTransactionalAspect.aspectOf().around(programImportService$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    protected List<RuleDescriptor> parseRuleDescriptors(URL url) {
        List<RuleDescriptor> list;
        block8: {
            InputStream inputStream = url.openStream();
            try {
                String content = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                RuleDescriptorList list2 = Utils.fromJsonString(content, RuleDescriptorList.class);
                List<RuleDescriptor> list3 = list = list2 != null ? list2.getDescriptors() : Collections.emptyList();
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.warn("An unknown error happened while parsing default rules from url {}", new Object[]{url, e});
                    return Collections.emptyList();
                }
            }
            inputStream.close();
        }
        return list;
    }

    protected List<ProgramDescriptor> parseProgramDescriptors(URL url) {
        List<ProgramDescriptor> list;
        block8: {
            InputStream inputStream = url.openStream();
            try {
                String content = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                ProgramDescriptorList list2 = Utils.fromJsonString(content, ProgramDescriptorList.class);
                List<ProgramDescriptor> list3 = list = list2 != null ? list2.getDescriptors() : Collections.emptyList();
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.warn("An unknown error happened while parsing default programs from url {}", new Object[]{url, e});
                    return Collections.emptyList();
                }
            }
            inputStream.close();
        }
        return list;
    }

    protected void importProgramDescriptor(ProgramDescriptor descriptor) {
        String descriptorId = descriptor.getNameId();
        long existingId = this.getProgramSettingValue(descriptorId);
        if (this.forceReimport || existingId == 0L) {
            this.importProgram(descriptor, existingId);
        } else {
            LOG.debug("Ignore re-importing default program {}", new Object[]{descriptorId});
        }
    }

    protected void importRuleDescriptor(RuleDescriptor descriptor) {
        String descriptorId = descriptor.getNameId();
        long existingId = this.getSettingValue(descriptorId);
        if (existingId == 0L) {
            this.importRule(descriptor, existingId);
        } else {
            LOG.debug("Ignore re-importing Rule {}", new Object[]{descriptorId});
        }
    }

    protected void importProgram(ProgramDescriptor d, long oldId) {
        String descriptorId = d.getNameId();
        try {
            ProgramDTO programDTO = this.saveProgram(d, oldId);
            if (programDTO != null && (this.forceReimport || oldId == 0L || programDTO.getId() != oldId)) {
                this.saveProgramNames(d, programDTO);
                this.saveProgramDescriptions(d, programDTO);
                this.setProgramSettingValue(descriptorId, programDTO.getId());
            }
        }
        catch (Exception e) {
            LOG.warn("An error occurred while importing default program {}", new Object[]{descriptorId, e});
        }
    }

    protected void importRule(RuleDescriptor d, long oldId) {
        String descriptorId = d.getNameId();
        try {
            RuleDTO rule = this.saveRule(d, oldId);
            if (rule == null) {
                return;
            }
            if (this.forceReimport || oldId == 0L || rule.getId() != oldId) {
                this.saveNames(d, rule);
                this.saveDescriptions(d, rule);
                this.setSettingValue(descriptorId, rule.getId());
            }
        }
        catch (Exception e) {
            LOG.warn("An error occurred while importing default rule {}", new Object[]{descriptorId, e});
        }
    }

    protected void saveNames(RuleDescriptor d, RuleDTO ruleDTO) {
        this.programTranslationImportService.saveTranslationLabels("rule", ruleDTO.getId(), "title", d.getNames(), d.getAppendEmoji());
    }

    protected void saveDescriptions(RuleDescriptor d, RuleDTO ruleDTO) {
        this.programTranslationImportService.saveTranslationLabels("rule", ruleDTO.getId(), "description", d.getDescriptions(), null);
    }

    protected void saveProgramNames(ProgramDescriptor d, ProgramDTO programDTO) {
        this.programTranslationImportService.saveTranslationLabels("program", programDTO.getId(), "title", d.getNames(), d.getAppendEmoji());
    }

    protected void saveProgramDescriptions(ProgramDescriptor d, ProgramDTO programDTO) {
        this.programTranslationImportService.saveProgramDescriptionTranslationLabels(programDTO.getId(), d.getDescriptions());
    }

    protected ProgramDTO saveProgram(ProgramDescriptor d, long oldId) {
        boolean isNew;
        ProgramDTO program = null;
        if (oldId > 0L) {
            program = this.programService.getProgramById(oldId);
        }
        boolean bl = isNew = program == null;
        if (isNew) {
            program = new ProgramDTO();
        }
        program.setTitle((String)(d.getAppendEmoji() != null ? this.programTranslationImportService.getI18NLabel(d.getNames().get("en"), Locale.ENGLISH) + " " + d.getAppendEmoji() : this.programTranslationImportService.getI18NLabel(d.getNames().get("en"), Locale.ENGLISH)));
        program.setDescription(this.programTranslationImportService.getProgramDescriptionLabel(d.getDescriptions(), Locale.ENGLISH));
        program.setEnabled(d.isEnabled());
        if (d.getCoverUrl() != null) {
            program.setCoverFileId(this.storeProgramCover(d.getCoverUrl()));
        }
        if (isNew) {
            return this.programService.createProgram(program);
        }
        return this.programService.updateProgram(program);
    }

    protected RuleDTO saveRule(RuleDescriptor d, long oldId) {
        boolean isNew;
        RuleDTO rule = null;
        if (oldId > 0L) {
            rule = this.ruleService.findRuleById(oldId);
        }
        boolean bl = isNew = rule == null;
        if (isNew) {
            rule = new RuleDTO();
        }
        rule.setTitle((String)(d.getAppendEmoji() != null ? this.programTranslationImportService.getI18NLabel(d.getNames().get("en"), Locale.ENGLISH) + " " + d.getAppendEmoji() : this.programTranslationImportService.getI18NLabel(d.getNames().get("en"), Locale.ENGLISH)));
        rule.setDescription(this.programTranslationImportService.getI18NLabel(d.getDescriptions().get("en"), Locale.ENGLISH));
        rule.setType(EntityType.AUTOMATIC);
        rule.setScore(d.getScore());
        rule.setEnabled(true);
        if (d.getRecurrence() != null) {
            rule.setRecurrence(d.getRecurrence());
        }
        EventDTO eventDTO = new EventDTO();
        eventDTO.setType("meeds");
        eventDTO.setTrigger(d.getEvent());
        eventDTO.setTitle(d.getEvent());
        rule.setEvent(eventDTO);
        if (this.getProgramSettingValue(d.getProgramNameId()) > 0L) {
            ProgramDTO program = this.programService.getProgramById(this.getProgramSettingValue(d.getProgramNameId()));
            rule.setProgram(program);
        }
        rule.setDefaultRealizationStatus(d.getDefaultRealizationStatus());
        if (d.getPrerequisiteRules() != null) {
            this.rulesWithPrerequisite.add(d);
        }
        if (isNew) {
            return this.ruleService.createRule(rule);
        }
        return this.ruleService.updateRule(rule);
    }

    protected void updateRuleWithPrerequisite(RuleDescriptor rule) {
        long ruleId = this.getSettingValue(rule.getNameId());
        RuleDTO ruleDTO = this.ruleService.findRuleById(ruleId);
        if (ruleDTO != null) {
            HashSet<Long> prerequisiteRuleIds = new HashSet<Long>();
            rule.getPrerequisiteRules().forEach(item -> {
                long prerequisiteRuleId = this.getSettingValue((String)item);
                if (prerequisiteRuleId > 0L) {
                    prerequisiteRuleIds.add(prerequisiteRuleId);
                }
            });
            try {
                ruleDTO.setPrerequisiteRuleIds(prerequisiteRuleIds);
                this.ruleService.updateRule(ruleDTO);
            }
            catch (ObjectNotFoundException e) {
                LOG.warn("Error while automatically updating the rule. Rule = {} ", new Object[]{rule, e});
            }
        }
    }

    protected void setProgramSettingValue(String name, long value) {
        this.settingService.set(DEFAULT_PROGRAM_CONTEXT, DEFAULT_PROGRAM_IMPORT_SCOPE, name, SettingValue.create((String)String.valueOf(value)));
    }

    protected long getProgramSettingValue(String name) {
        try {
            SettingValue settingValue = this.settingService.get(DEFAULT_PROGRAM_CONTEXT, DEFAULT_PROGRAM_IMPORT_SCOPE, name);
            return settingValue == null || settingValue.getValue() == null ? 0L : Long.parseLong(settingValue.getValue().toString());
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    protected void setSettingValue(String name, long value) {
        this.settingService.set(DEFAULT_PROGRAM_CONTEXT, DEFAULT_RULE_IMPORT_SCOPE, name, SettingValue.create((String)String.valueOf(value)));
    }

    protected long getSettingValue(String name) {
        try {
            SettingValue settingValue = this.settingService.get(DEFAULT_PROGRAM_CONTEXT, DEFAULT_RULE_IMPORT_SCOPE, name);
            return settingValue == null || settingValue.getValue() == null ? 0L : Long.parseLong(settingValue.getValue().toString());
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    private ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long storeProgramCover(String coverUrl) {
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(coverUrl);){
            if (inputStream == null) {
                long l2 = 0L;
                return l2;
            }
            FileItem fileItem = new FileItem(null, coverUrl, "image/png", "gamification", (long)inputStream.available(), new Date(), "gamification", false, inputStream);
            long l = (fileItem = this.fileService.writeFile(fileItem)) != null ? fileItem.getFileInfo().getId() : 0L;
            return l;
        }
        catch (Exception e) {
            LOG.warn("Error while writing program {} cover file", new Object[]{coverUrl, e});
            return 0L;
        }
    }

    static {
        ProgramImportService.ajc$preClinit();
        DEFAULT_RULE_IMPORT_SCOPE = Scope.APPLICATION.id(DEFAULT_RULE_IMPORT);
        DEFAULT_PROGRAM_IMPORT_SCOPE = Scope.APPLICATION.id("DEFAULT_PROGRAM_IMPORT_SCOPE");
        DEFAULT_PROGRAM_CONTEXT = Context.GLOBAL.id("DEFAULT_PROGRAM");
        LOG = ExoLogger.getLogger(ProgramImportService.class);
    }

    static final /* synthetic */ void importPrograms_aroundBody0(ProgramImportService ajc$this, JoinPoint joinPoint) {
        LOG.info((Object)"Importing Default Programs");
        ConversationState.setCurrent((ConversationState)new ConversationState(Utils.getUserAclIdentity(ajc$this.userAcl.getSuperUser())));
        try {
            ProgramFilter filter = new ProgramFilter();
            filter.setIncludeDeleted(true);
            filter.setStatus(EntityStatusType.ALL);
            int programsCount = ajc$this.programService.countPrograms(filter);
            if (ajc$this.forceReimport || programsCount == 0) {
                Collections.list(ajc$this.getClassLoader().getResources("default-programs.json")).stream().map(ajc$this::parseProgramDescriptors).flatMap(Collection::stream).forEach(ajc$this::importProgramDescriptor);
                Collections.list(ajc$this.getClass().getClassLoader().getResources("default-rules.json")).stream().map(ajc$this::parseRuleDescriptors).flatMap(Collection::stream).forEach(ajc$this::importRuleDescriptor);
                if (CollectionUtils.isNotEmpty(ajc$this.rulesWithPrerequisite)) {
                    ajc$this.rulesWithPrerequisite.forEach(ajc$this::updateRuleWithPrerequisite);
                }
                LOG.info((Object)"Importing Default Programs finished successfully.");
                ajc$this.programTranslationImportService.postImport("program");
                ajc$this.programTranslationImportService.postImport("rule");
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"An error occurred while importing default programs", (Throwable)e);
        }
        finally {
            ConversationState.setCurrent(null);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ProgramImportService.java", ProgramImportService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "importPrograms", "io.meeds.gamification.service.injection.ProgramImportService", "", "", "", "void"), 117);
    }
}

