/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.service;

import io.meeds.gamification.constant.EntityFilterType;
import io.meeds.gamification.constant.EntityStatusType;
import io.meeds.gamification.model.EventDTO;
import io.meeds.gamification.model.RealizationDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.model.filter.RuleFilter;
import io.meeds.gamification.test.AbstractServiceTest;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RealizationComputingServiceTest
extends AbstractServiceTest {
    private static final String ADMIN_USER = "root1";
    private String adminIdentityId;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.adminIdentityId = this.identityManager.getOrCreateUserIdentity(ADMIN_USER).getId();
    }

    public void testGetLockingRules() {
        RuleDTO disabledRule = this.newRuleDTO();
        disabledRule.setEnabled(false);
        RuleDTO lockingRule01 = this.newRuleDTO("lockingRule01");
        RuleDTO lockingRule02 = this.newRuleDTO("lockingRule02");
        disabledRule.setPrerequisiteRuleIds(Stream.of(lockingRule01.getId(), lockingRule02.getId()).collect(Collectors.toSet()));
        this.ruleService.updateRule(disabledRule, ADMIN_USER);
        RuleDTO lockedRule1 = this.newRuleDTO();
        RuleDTO lockingRule1 = this.newRuleDTO("lockingRule1");
        RuleDTO lockingRule2 = this.newRuleDTO("lockingRule2");
        lockedRule1.setPrerequisiteRuleIds(Stream.of(lockingRule1.getId(), lockingRule2.getId()).collect(Collectors.toSet()));
        this.ruleService.updateRule(lockedRule1, ADMIN_USER);
        for (int i = 0; i < 10; ++i) {
            this.newRuleDTO();
        }
        RuleDTO lockedRule2 = this.newRuleDTO();
        RuleDTO lockingRule21 = this.newRuleDTO("lockingRule21");
        RuleDTO lockingRule22 = this.newRuleDTO("lockingRule22");
        lockedRule2.setPrerequisiteRuleIds(Stream.of(lockingRule21.getId(), lockingRule22.getId()).collect(Collectors.toSet()));
        this.ruleService.updateRule(lockedRule2, ADMIN_USER);
        RuleFilter filter = new RuleFilter();
        filter.setStatus(EntityStatusType.ENABLED);
        filter.setType(EntityFilterType.ALL);
        filter.setSortBy("createdDate");
        filter.setSortDescending(true);
        List lockingRules = this.realizationComputingService.getLockingRules(filter, ADMIN_USER, 0, 10);
        RealizationComputingServiceTest.assertNotNull((Object)lockingRules);
        RealizationComputingServiceTest.assertEquals((int)4, (int)lockingRules.size());
        RealizationComputingServiceTest.assertEquals((Object)lockingRule22.getId(), (Object)((RuleDTO)lockingRules.get(0)).getId());
        RealizationComputingServiceTest.assertEquals((Object)lockingRule21.getId(), (Object)((RuleDTO)lockingRules.get(1)).getId());
        RealizationComputingServiceTest.assertEquals((Object)lockingRule2.getId(), (Object)((RuleDTO)lockingRules.get(2)).getId());
        RealizationComputingServiceTest.assertEquals((Object)lockingRule1.getId(), (Object)((RuleDTO)lockingRules.get(3)).getId());
        this.achieveRule(lockingRule22);
        lockingRules = this.realizationComputingService.getLockingRules(filter, ADMIN_USER, 0, 10);
        RealizationComputingServiceTest.assertNotNull((Object)lockingRules);
        RealizationComputingServiceTest.assertEquals((int)3, (int)lockingRules.size());
        RealizationComputingServiceTest.assertEquals((Object)lockingRule21.getId(), (Object)((RuleDTO)lockingRules.get(0)).getId());
        RealizationComputingServiceTest.assertEquals((Object)lockingRule2.getId(), (Object)((RuleDTO)lockingRules.get(1)).getId());
        RealizationComputingServiceTest.assertEquals((Object)lockingRule1.getId(), (Object)((RuleDTO)lockingRules.get(2)).getId());
        this.achieveRule(lockingRule1);
        lockingRules = this.realizationComputingService.getLockingRules(filter, ADMIN_USER, 0, 10);
        RealizationComputingServiceTest.assertNotNull((Object)lockingRules);
        RealizationComputingServiceTest.assertEquals((int)2, (int)lockingRules.size());
        RealizationComputingServiceTest.assertEquals((Object)lockingRule21.getId(), (Object)((RuleDTO)lockingRules.get(0)).getId());
        RealizationComputingServiceTest.assertEquals((Object)lockingRule2.getId(), (Object)((RuleDTO)lockingRules.get(1)).getId());
        this.achieveRule(lockingRule2);
        this.achieveRule(lockingRule21);
        lockingRules = this.realizationComputingService.getLockingRules(filter, ADMIN_USER, 0, 10);
        RealizationComputingServiceTest.assertNotNull((Object)lockingRules);
        RealizationComputingServiceTest.assertEquals((int)0, (int)lockingRules.size());
    }

    private RuleDTO newRuleDTO(String eventName) {
        RuleDTO rule = this.newRuleDTO();
        long eventId = rule.getEvent().getId();
        EventDTO event = this.eventService.getEvent(eventId);
        event.setTitle(eventName);
        this.eventService.updateEvent(event);
        rule.setEvent(event);
        rule.setTitle(eventName);
        this.ruleService.updateRule(rule);
        return rule;
    }

    private void achieveRule(RuleDTO rule) {
        RealizationDTO realization = (RealizationDTO)this.realizationService.createRealizations(rule.getEvent().getTitle(), null, this.adminIdentityId, this.adminIdentityId, "245590", "activity").getFirst();
        RealizationComputingServiceTest.assertNotNull((Object)realization);
        RealizationComputingServiceTest.assertTrue((realization.getId() > 0L ? 1 : 0) != 0);
    }
}

