/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.connector;

import io.meeds.gamification.entity.ProgramEntity;
import io.meeds.gamification.entity.RuleEntity;
import io.meeds.gamification.test.AbstractServiceTest;
import org.exoplatform.commons.search.domain.Document;
import org.junit.Assert;
import org.junit.Test;

public class RuleIndexingServiceConnectorTest
extends AbstractServiceTest {
    public static final String INDEX = "rules";

    @Test
    public void testGetConnectorName() {
        RuleIndexingServiceConnectorTest.assertEquals((String)INDEX, (String)this.ruleIndexingServiceConnector.getConnectorName());
    }

    @Test
    public void testCreate() {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.ruleIndexingServiceConnector.update(""));
        Assert.assertThrows(IllegalStateException.class, () -> this.ruleIndexingServiceConnector.update("5122165"));
        ProgramEntity domainEntity = this.newDomain();
        RuleEntity rule = this.newRule("test", domainEntity.getId());
        Document document = this.ruleIndexingServiceConnector.create(String.valueOf(rule.getId()));
        RuleIndexingServiceConnectorTest.assertNotNull((Object)document);
        RuleIndexingServiceConnectorTest.assertEquals((long)rule.getId(), (long)Long.parseLong(document.getId()));
        RuleIndexingServiceConnectorTest.assertNotNull((Object)document.getFields());
    }

    @Test
    public void testUpdate() {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.ruleIndexingServiceConnector.update(""));
        Assert.assertThrows(IllegalStateException.class, () -> this.ruleIndexingServiceConnector.update("5122165"));
        ProgramEntity domainEntity = this.newDomain();
        RuleEntity rule = this.newManualRule("test", domainEntity.getId());
        Document document = this.ruleIndexingServiceConnector.update(String.valueOf(rule.getId()));
        RuleIndexingServiceConnectorTest.assertNotNull((Object)document);
        RuleIndexingServiceConnectorTest.assertEquals((long)rule.getId(), (long)Long.parseLong(document.getId()));
        RuleIndexingServiceConnectorTest.assertNotNull((Object)document.getFields());
    }

    @Test
    public void getAllIds() {
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.ruleIndexingServiceConnector.getAllIds(0, 10));
    }
}

