/**
 * This file is part of the Meeds project (https://meeds.io/).
 * Copyright (C) 2022 Meeds Association
 * contact@meeds.io
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

package io.meeds.gamification.model;

import java.util.HashMap;
import java.util.Map;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

@Data
@EqualsAndHashCode(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
public class AnnouncementActivity extends Announcement {

  public AnnouncementActivity(long id, // NOSONAR
                              Long challengeId,
                              String challengeTitle,
                              Long assignee,
                              String comment,
                              Long creator,
                              String createdDate,
                              Long activityId,
                              Map<String, String> templateParams) {
    super(id, challengeId, challengeTitle, assignee, comment, creator, createdDate, activityId);
    this.templateParams = templateParams;
  }

  private Map<String, String> templateParams;

  @Override
  public AnnouncementActivity clone() { // NOSONAR
    return new AnnouncementActivity(id,
                                    challengeId,
                                    challengeTitle,
                                    assignee,
                                    comment,
                                    creator,
                                    createdDate,
                                    activityId,
                                    templateParams == null ? null : new HashMap<>(templateParams));
  }

}
