/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.plugin;

import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.test.AbstractServiceTest;
import java.util.Arrays;
import java.util.Collections;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.attachment.model.FileAttachmentResourceList;
import org.exoplatform.social.attachment.model.ObjectAttachmentList;
import org.junit.Assert;

public class RuleAttachmentPluginTest
extends AbstractServiceTest {
    private final Identity adminAclIdentity = new Identity("root1", Arrays.asList(new MembershipEntry("/platform/administrators"), new MembershipEntry("/platform/rewarding")));
    private final Identity userAclIdentity = new Identity("root2", Arrays.asList(new MembershipEntry("/platform/externals")));
    private AttachmentService attachmentService;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.identityRegistry.register(this.adminAclIdentity);
        this.attachmentService = (AttachmentService)ExoContainerContext.getService(AttachmentService.class);
    }

    public void testRuleAttachmentPlugin() throws IllegalAccessException, ObjectNotFoundException {
        RuleDTO rule = this.newRuleDTO();
        RuleAttachmentPluginTest.assertNotNull((Object)rule);
        long ruleId = rule.getId();
        long adminIdentityId = 1L;
        long userIdentityId = 2L;
        Assert.assertThrows(IllegalAccessException.class, () -> this.attachmentService.saveAttachments(new FileAttachmentResourceList(Collections.emptyList(), Collections.emptyList(), userIdentityId, "rule", String.valueOf(ruleId), null), this.userAclIdentity));
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.attachmentService.saveAttachments(new FileAttachmentResourceList(Collections.emptyList(), Collections.emptyList(), userIdentityId, "rule", String.valueOf(5555L), null), this.adminAclIdentity));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.attachmentService.saveAttachments(new FileAttachmentResourceList(Collections.emptyList(), Collections.emptyList(), 0L, "rule", String.valueOf(ruleId), null), this.adminAclIdentity));
        this.attachmentService.saveAttachments(new FileAttachmentResourceList(Collections.emptyList(), Collections.emptyList(), adminIdentityId, "rule", String.valueOf(ruleId), null), this.adminAclIdentity);
        ObjectAttachmentList objectAttachmentList = this.attachmentService.getAttachments("rule", String.valueOf(ruleId), this.adminAclIdentity);
        RuleAttachmentPluginTest.assertNotNull((Object)objectAttachmentList);
        RuleAttachmentPluginTest.assertNotNull((Object)objectAttachmentList.getAttachments());
        RuleAttachmentPluginTest.assertEquals((int)0, (int)objectAttachmentList.getAttachments().size());
        RuleAttachmentPluginTest.assertEquals((String)"rule", (String)objectAttachmentList.getObjectType());
        RuleAttachmentPluginTest.assertEquals((String)String.valueOf(ruleId), (String)objectAttachmentList.getObjectId());
    }
}

