/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.service.impl;

import io.meeds.gamification.model.EventDTO;
import io.meeds.gamification.model.Trigger;
import io.meeds.gamification.model.filter.EventFilter;
import io.meeds.gamification.plugin.EventPlugin;
import io.meeds.gamification.service.EventRegistry;
import io.meeds.gamification.service.EventService;
import io.meeds.gamification.storage.EventStorage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;

public class EventServiceImpl
implements EventService {
    private final EventStorage eventStorage;
    private final EventRegistry eventRegistry;
    private final Map<String, EventPlugin> eventPlugins = new HashMap<String, EventPlugin>();

    public EventServiceImpl(EventStorage eventStorage, EventRegistry eventRegistry) {
        this.eventStorage = eventStorage;
        this.eventRegistry = eventRegistry;
    }

    @Override
    public void addPlugin(EventPlugin eventPlugin) {
        this.eventPlugins.put(eventPlugin.getEventType(), eventPlugin);
    }

    @Override
    public void removePlugin(String eventType) {
        this.eventPlugins.remove(eventType);
    }

    @Override
    public EventPlugin getEventPlugin(String eventName) {
        return this.eventPlugins.values().stream().filter(eventPlugin -> eventPlugin.getTriggers().contains(eventName)).findFirst().orElse(null);
    }

    @Override
    public List<EventDTO> getEvents(EventFilter eventFilter, int offset, int limit) {
        return this.eventStorage.findEventsByFilter(eventFilter, offset, limit);
    }

    @Override
    public List<EventDTO> getEventsByTitle(String title, int offset, int limit) {
        return this.eventStorage.getEventsByTitle(title, offset, limit);
    }

    @Override
    public int countEvents(EventFilter eventFilter) {
        return this.eventStorage.countEventsByFilter(eventFilter);
    }

    @Override
    public EventDTO getEventByTitleAndTrigger(String title, String trigger) {
        return this.eventStorage.getEventByTitleAndTrigger(title, trigger);
    }

    @Override
    public EventDTO createEvent(EventDTO eventDTO) {
        if (eventDTO == null) {
            throw new IllegalArgumentException("event object is mandatory");
        }
        return this.eventStorage.saveEvent(eventDTO);
    }

    @Override
    public EventDTO updateEvent(EventDTO eventDTO) throws ObjectNotFoundException {
        if (eventDTO.getId() <= 0L) {
            throw new IllegalArgumentException("Event id must not be null");
        }
        EventDTO storedEvent = this.eventStorage.getEventById(eventDTO.getId());
        if (storedEvent == null) {
            throw new ObjectNotFoundException("Event with id " + eventDTO.getId() + " is not found");
        }
        return this.eventStorage.saveEvent(eventDTO);
    }

    @Override
    public List<EventDTO> getEventsByCancellerTrigger(String eventType, String cancellerTrigger, int offset, int limit) {
        List<String> triggers = this.eventRegistry.getTriggers(eventType).stream().filter(t -> CollectionUtils.isNotEmpty(t.getCanceller()) && t.getCanceller().contains(cancellerTrigger)).map(Trigger::getTitle).toList();
        EventFilter eventFilter = new EventFilter();
        eventFilter.setTriggers(triggers);
        return this.getEvents(eventFilter, offset, limit);
    }

    @Override
    public boolean canVariableRewarding(String triggerType, String triggerName) {
        Trigger trigger = this.eventRegistry.getTrigger(triggerType, triggerName);
        if (trigger != null) {
            return trigger.isCanVariableRewarding();
        }
        return false;
    }

    @Override
    public EventDTO getEvent(long eventId) {
        return this.eventStorage.getEventById(eventId);
    }

    @Override
    public EventDTO deleteEventById(long eventId) throws ObjectNotFoundException {
        EventDTO eventDTO;
        try {
            eventDTO = this.eventStorage.deleteEventById(eventId);
        }
        catch (ObjectNotFoundException e) {
            throw new ObjectNotFoundException("Event with id " + eventId + " is not found");
        }
        return eventDTO;
    }
}

