/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.rest;

import io.meeds.gamification.constant.EntityType;
import io.meeds.gamification.entity.ProgramEntity;
import io.meeds.gamification.entity.RuleEntity;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.model.UserInfoContext;
import io.meeds.gamification.rest.RuleRest;
import io.meeds.gamification.rest.model.ProgramWithRulesRestEntity;
import io.meeds.gamification.rest.model.RuleList;
import io.meeds.gamification.rest.model.RuleRestEntity;
import io.meeds.gamification.test.AbstractServiceTest;
import io.meeds.gamification.utils.Utils;
import java.io.StringWriter;
import java.util.Date;
import java.util.List;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.security.ConversationState;
import org.json.JSONObject;
import org.json.JSONWriter;
import org.junit.Before;
import org.junit.Test;

public class TestRuleRest
extends AbstractServiceTest {
    private static final String GAMIFICATION_RULES_REST_PATH = "/gamification/rules/";
    private static final long MILLIS_IN_A_DAY = 86400000L;
    private static final String START_DATE = Utils.toRFC3339Date((Date)new Date(System.currentTimeMillis() - 259200000L));
    private static final String END_DATE = Utils.toRFC3339Date((Date)new Date(System.currentTimeMillis() - 172800000L));

    protected Class<?> getComponentClass() {
        return RuleRest.class;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.registerAdministratorUser("root1");
        this.registerInternalUser("user");
        this.registry(this.getComponentClass());
        ConversationState.setCurrent(null);
    }

    @Test
    public void testCreateRule() throws Exception {
        this.startSessionAs("root10");
        ProgramDTO domain = this.newProgram();
        StringWriter writer = new StringWriter();
        JSONWriter jsonWriter = new JSONWriter((Appendable)writer);
        jsonWriter.object().key("title").value((Object)"Rule").key("description").value((Object)"Rule description").key("startDate").value((Object)START_DATE).key("endDate").value((Object)END_DATE).key("points").value((Object)"10").key("program").object().key("id").value(domain.getId()).endObject().endObject();
        ContainerResponse response = this.getResponse("POST", this.getURLResource("rules"), writer.getBuffer().toString());
        TestRuleRest.assertNotNull((Object)response);
        TestRuleRest.assertEquals((int)401, (int)response.getStatus());
        this.startSessionAs("root1");
        response = this.getResponse("POST", this.getURLResource("rules"), null);
        TestRuleRest.assertNotNull((Object)response);
        TestRuleRest.assertEquals((int)400, (int)response.getStatus());
        response = this.getResponse("POST", this.getURLResource("rules"), writer.getBuffer().toString());
        TestRuleRest.assertNotNull((Object)response);
        TestRuleRest.assertEquals((int)200, (int)response.getStatus());
    }

    @Test
    public void testUpdateRule() throws Exception {
        this.startSessionAs("root1");
        ProgramDTO domain = this.newProgram();
        StringWriter writer = new StringWriter();
        JSONWriter jsonWriter = new JSONWriter((Appendable)writer);
        jsonWriter.object().key("title").value((Object)"Rule").key("description").value((Object)"Rule description").key("startDate").value((Object)START_DATE).key("endDate").value((Object)END_DATE).key("points").value((Object)"10").key("enabled").value(true).key("publish").value(false).key("program").object().key("id").value(domain.getId()).endObject().key("event").object().key("title").value((Object)"eventTitle").key("trigger").value((Object)"eventTrigger").key("type").value((Object)"eventType").endObject().endObject();
        ContainerResponse response = this.getResponse("POST", this.getURLResource("rules"), writer.getBuffer().toString());
        TestRuleRest.assertNotNull((Object)response);
        TestRuleRest.assertEquals((int)200, (int)response.getStatus());
        RuleRestEntity rule = (RuleRestEntity)response.getEntity();
        TestRuleRest.assertNotNull((Object)rule);
        TestRuleRest.assertFalse((boolean)rule.isPublished());
        this.startSessionAs("root2");
        writer = new StringWriter();
        jsonWriter = new JSONWriter((Appendable)writer);
        jsonWriter.object().key("id").value((Object)"0").key("title").value((Object)"Rule updated").key("description").value((Object)"Rule description updated").key("startDate").value((Object)START_DATE).key("endDate").value((Object)END_DATE).key("points").value((Object)"100").key("program").object().key("id").value(domain.getId()).endObject().key("event").object().key("id").value(rule.getEvent().getId()).endObject().endObject();
        response = this.getResponse("PUT", this.getURLResource("rules"), null);
        TestRuleRest.assertNotNull((Object)response);
        TestRuleRest.assertEquals((int)400, (int)response.getStatus());
        response = this.getResponse("PUT", this.getURLResource("rules"), writer.getBuffer().toString());
        TestRuleRest.assertNotNull((Object)response);
        TestRuleRest.assertEquals((int)404, (int)response.getStatus());
        writer = new StringWriter();
        jsonWriter = new JSONWriter((Appendable)writer);
        jsonWriter.object().key("id").value((Object)rule.getId()).key("title").value((Object)"Rule updated").key("description").value((Object)"Rule description updated").key("startDate").value((Object)START_DATE).key("endDate").value((Object)END_DATE).key("points").value((Object)"100").key("program").object().key("id").value(domain.getId()).endObject().key("event").object().key("id").value(rule.getEvent().getId()).endObject().endObject();
        response = this.getResponse("PUT", this.getURLResource("rules"), writer.getBuffer().toString());
        TestRuleRest.assertNotNull((Object)response);
        TestRuleRest.assertEquals((int)401, (int)response.getStatus());
        writer = new StringWriter();
        jsonWriter = new JSONWriter((Appendable)writer);
        jsonWriter.object().key("id").value((Object)rule.getId()).key("title").value((Object)"Rule updated").key("description").value((Object)"Rule description updated").key("startDate").value((Object)START_DATE).key("endDate").value((Object)END_DATE).key("points").value((Object)"100").key("enabled").value(true).key("publish").value(true).key("program").object().key("id").value(domain.getId()).endObject().key("event").object().key("id").value(rule.getEvent().getId()).key("title").value((Object)rule.getEvent().getTitle()).key("trigger").value((Object)rule.getEvent().getTrigger()).key("type").value((Object)rule.getEvent().getType()).endObject().endObject();
        response = this.getResponse("PUT", this.getURLResource("rules"), writer.getBuffer().toString());
        TestRuleRest.assertNotNull((Object)response);
        TestRuleRest.assertEquals((int)401, (int)response.getStatus());
        this.startSessionAs("root1");
        response = this.getResponse("PUT", this.getURLResource("rules"), writer.getBuffer().toString());
        TestRuleRest.assertNotNull((Object)response);
        TestRuleRest.assertEquals((int)200, (int)response.getStatus());
        rule = (RuleRestEntity)response.getEntity();
        TestRuleRest.assertNotNull((Object)rule);
        TestRuleRest.assertTrue((boolean)rule.isPublished());
        writer = new StringWriter();
        jsonWriter = new JSONWriter((Appendable)writer);
        jsonWriter.object().key("id").value((Object)"10").key("title").value((Object)"Rule updated").key("description").value((Object)"Rule description updated").key("startDate").value((Object)START_DATE).key("endDate").value((Object)END_DATE).key("points").value((Object)"100").key("program").object().key("id").value(domain.getId()).endObject().key("event").object().key("id").value(rule.getEvent().getId()).endObject().endObject();
        response = this.getResponse("PUT", this.getURLResource("rules"), writer.getBuffer().toString());
        TestRuleRest.assertNotNull((Object)response);
        TestRuleRest.assertEquals((int)404, (int)response.getStatus());
    }

    @Test
    public void testGetRuleById() throws Exception {
        this.startSessionAs("root1");
        ProgramDTO domain = this.newProgram();
        StringWriter writer = new StringWriter();
        JSONWriter jsonWriter = new JSONWriter((Appendable)writer);
        jsonWriter.object().key("title").value((Object)"Rule").key("description").value((Object)"Rule description").key("startDate").value((Object)START_DATE).key("endDate").value((Object)END_DATE).key("points").value((Object)"10").key("program").object().key("id").value(domain.getId()).endObject().endObject();
        ContainerResponse response = this.getResponse("POST", this.getURLResource("rules"), writer.getBuffer().toString());
        TestRuleRest.assertNotNull((Object)response);
        TestRuleRest.assertEquals((int)200, (int)response.getStatus());
        RuleRestEntity ruleRestEntity = (RuleRestEntity)response.getEntity();
        TestRuleRest.assertNotNull((Object)ruleRestEntity);
        this.startSessionAs("root2");
        response = this.getResponse("GET", this.getURLResource("rules/0"), null);
        TestRuleRest.assertNotNull((Object)response);
        TestRuleRest.assertEquals((int)400, (int)response.getStatus());
        response = this.getResponse("GET", this.getURLResource("rules/555"), null);
        TestRuleRest.assertNotNull((Object)response);
        TestRuleRest.assertEquals((int)404, (int)response.getStatus());
        this.startSessionAs("root1");
        response = this.getResponse("GET", this.getURLResource("rules/" + ruleRestEntity.getId()), null);
        TestRuleRest.assertNotNull((Object)response);
        TestRuleRest.assertEquals((int)200, (int)response.getStatus());
        RuleRestEntity savedRuleRestEntity = (RuleRestEntity)response.getEntity();
        TestRuleRest.assertNotNull((Object)savedRuleRestEntity);
        TestRuleRest.assertEquals((Object)ruleRestEntity.getId(), (Object)savedRuleRestEntity.getId());
        TestRuleRest.assertFalse((boolean)savedRuleRestEntity.isPublished());
    }

    @Test
    public void testGetRules() throws Exception {
        ProgramEntity domainEntity = this.newDomain();
        this.newRule("rule", domainEntity.getId());
        this.newRule("rule1", domainEntity.getId());
        this.startSessionAs("root0");
        ContainerResponse response = this.getResponse("GET", this.getURLResource("rules?returnSize=true"), null);
        TestRuleRest.assertEquals((int)200, (int)response.getStatus());
        response = this.getResponse("GET", this.getURLResource("rules?returnSize=true&limit=-1"), null);
        TestRuleRest.assertEquals((int)400, (int)response.getStatus());
        response = this.getResponse("GET", this.getURLResource("rules?returnSize=true&offset=-1"), null);
        TestRuleRest.assertEquals((int)400, (int)response.getStatus());
        response = this.getResponse("GET", this.getURLResource("rules?returnSize=true&programId=" + domainEntity.getId()), null);
        TestRuleRest.assertEquals((int)200, (int)response.getStatus());
        RuleList rules = (RuleList)response.getEntity();
        TestRuleRest.assertNotNull((Object)rules);
        TestRuleRest.assertEquals((int)0, (int)rules.getSize());
        this.startSessionAsAdministrator("root1");
        response = this.getResponse("GET", this.getURLResource("rules?returnSize=true&programId=" + domainEntity.getId()), null);
        TestRuleRest.assertEquals((int)200, (int)response.getStatus());
        rules = (RuleList)response.getEntity();
        TestRuleRest.assertNotNull((Object)rules);
        TestRuleRest.assertEquals((int)2, (int)rules.getSize());
        response = this.getResponse("GET", this.getURLResource("rules?returnSize=true&spaceId=5555"), null);
        TestRuleRest.assertEquals((int)200, (int)response.getStatus());
        rules = (RuleList)response.getEntity();
        TestRuleRest.assertNotNull((Object)rules);
        TestRuleRest.assertEquals((int)0, (int)rules.getSize());
        response = this.getResponse("GET", this.getURLResource("rules?returnSize=true&spaceId=" + domainEntity.getAudienceId() + "&spaceId=5555"), null);
        TestRuleRest.assertEquals((int)200, (int)response.getStatus());
        rules = (RuleList)response.getEntity();
        TestRuleRest.assertNotNull((Object)rules);
        TestRuleRest.assertEquals((int)2, (int)rules.getSize());
    }

    @Test
    public void testGetRulesByUser() throws Exception {
        this.startSessionAs("root1");
        ProgramDTO domain = this.newProgram();
        Object restPath = GAMIFICATION_RULES_REST_PATH;
        StringWriter writer = new StringWriter();
        JSONWriter jsonWriter = new JSONWriter((Appendable)writer);
        jsonWriter.object().key("title").value((Object)"Rule").key("description").value((Object)"Rule description").key("startDate").value((Object)START_DATE).key("endDate").value((Object)END_DATE).key("points").value((Object)"10").key("enabled").value(true).key("program").object().key("id").value(domain.getId()).endObject().endObject();
        ContainerResponse response = this.getResponse("POST", (String)restPath, writer.getBuffer().toString());
        TestRuleRest.assertNotNull((Object)response);
        TestRuleRest.assertEquals((int)200, (int)response.getStatus());
        RuleRestEntity rule = (RuleRestEntity)response.getEntity();
        TestRuleRest.assertNotNull((Object)rule);
        response = this.getResponse("POST", (String)restPath, writer.getBuffer().toString());
        TestRuleRest.assertNotNull((Object)response);
        TestRuleRest.assertEquals((int)200, (int)response.getStatus());
        rule = (RuleRestEntity)response.getEntity();
        TestRuleRest.assertNotNull((Object)rule);
        this.startSessionAs("root2");
        restPath = "/gamification/rules/?offset=0&limit=10";
        response = this.getResponse("GET", (String)restPath, null);
        TestRuleRest.assertNotNull((Object)response);
        TestRuleRest.assertEquals((int)200, (int)response.getStatus());
        RuleList savedRules = (RuleList)response.getEntity();
        TestRuleRest.assertEquals((int)0, (int)savedRules.getSize());
        this.startSessionAs("root1");
        restPath = "/gamification/rules/?offset=0&limit=10&programId=" + domain.getId() + "&announcements=4";
        response = this.getResponse("GET", (String)restPath, null);
        TestRuleRest.assertNotNull((Object)response);
        TestRuleRest.assertEquals((int)200, (int)response.getStatus());
        savedRules = (RuleList)response.getEntity();
        TestRuleRest.assertEquals((int)2, (int)savedRules.getRules().size());
        restPath = "/gamification/rules/?offset=0&limit=10&programId=0&announcements=4&groupByProgram=true";
        response = this.getResponse("GET", (String)restPath, null);
        TestRuleRest.assertNotNull((Object)response);
        TestRuleRest.assertEquals((int)200, (int)response.getStatus());
        List domainWithRules = (List)response.getEntity();
        TestRuleRest.assertEquals((int)1, (int)domainWithRules.size());
        TestRuleRest.assertEquals((int)2, (int)((ProgramWithRulesRestEntity)domainWithRules.get(0)).getRules().size());
        restPath = "/gamification/rules/?offset=0&limit=1&returnSize=true";
        response = this.getResponse("GET", (String)restPath, null);
        TestRuleRest.assertNotNull((Object)response);
        TestRuleRest.assertEquals((int)200, (int)response.getStatus());
        savedRules = (RuleList)response.getEntity();
        TestRuleRest.assertEquals((int)2, (int)savedRules.getSize());
        TestRuleRest.assertEquals((int)1, (int)savedRules.getRules().size());
    }

    @Test
    public void testGetRuleByAnonym() throws Exception {
        ProgramDTO program = this.newProgram();
        program = this.programService.createProgram(program);
        RuleEntity rule = this.newRule("testGetRuleByAnonym", program.getId());
        ContainerResponse response = this.getResponse("GET", this.getURLResource("rules/0"), null);
        TestRuleRest.assertNotNull((Object)response);
        TestRuleRest.assertEquals((int)400, (int)response.getStatus());
        response = this.getResponse("GET", this.getURLResource("rules/555"), null);
        TestRuleRest.assertNotNull((Object)response);
        TestRuleRest.assertEquals((int)404, (int)response.getStatus());
        response = this.getResponse("GET", this.getURLResource("rules/" + rule.getId()), null);
        TestRuleRest.assertNotNull((Object)response);
        TestRuleRest.assertEquals((int)401, (int)response.getStatus());
        program.setSpaceId(Long.parseLong("200"));
        this.programService.updateProgram(program);
        response = this.getResponse("GET", this.getURLResource("rules/" + rule.getId()), null);
        TestRuleRest.assertNotNull((Object)response);
        TestRuleRest.assertEquals((int)200, (int)response.getStatus());
        RuleRestEntity ruleRestEntity = (RuleRestEntity)response.getEntity();
        TestRuleRest.assertNotNull((Object)ruleRestEntity);
        TestRuleRest.assertEquals((Object)rule.getId(), (Object)ruleRestEntity.getId());
        UserInfoContext userInfo = (UserInfoContext)ruleRestEntity.getUserInfo();
        TestRuleRest.assertTrue((boolean)userInfo.isCanView());
        TestRuleRest.assertFalse((boolean)userInfo.isCanEdit());
        TestRuleRest.assertFalse((boolean)userInfo.isManager());
        TestRuleRest.assertFalse((boolean)userInfo.isMember());
        TestRuleRest.assertFalse((boolean)userInfo.isProgramOwner());
        TestRuleRest.assertFalse((boolean)userInfo.isRedactor());
        this.setRestrictedHubAccess();
        response = this.getResponse("GET", this.getURLResource("rules/" + rule.getId()), null);
        TestRuleRest.assertNotNull((Object)response);
        TestRuleRest.assertEquals((int)401, (int)response.getStatus());
    }

    @Test
    public void testGetRulesByAnonym() throws Exception {
        ProgramDTO program = this.newProgram();
        program = this.programService.createProgram(program);
        RuleEntity rule = this.newRule("testGetRulesByAnonym", program.getId());
        ContainerResponse response = this.getResponse("GET", this.getURLResource("rules?offset=0&limit=10&returnSize=true"), null);
        TestRuleRest.assertNotNull((Object)response);
        TestRuleRest.assertEquals((int)200, (int)response.getStatus());
        RuleList ruleList = (RuleList)response.getEntity();
        TestRuleRest.assertNotNull((Object)ruleList);
        TestRuleRest.assertEquals((int)0, (int)ruleList.getSize());
        TestRuleRest.assertNotNull((Object)ruleList.getRules());
        TestRuleRest.assertEquals((int)0, (int)ruleList.getRules().size());
        program.setSpaceId(Long.parseLong("200"));
        this.programService.updateProgram(program);
        response = this.getResponse("GET", this.getURLResource("rules?offset=0&limit=10&returnSize=true"), null);
        TestRuleRest.assertNotNull((Object)response);
        TestRuleRest.assertEquals((int)200, (int)response.getStatus());
        ruleList = (RuleList)response.getEntity();
        TestRuleRest.assertNotNull((Object)ruleList);
        TestRuleRest.assertEquals((int)1, (int)ruleList.getSize());
        TestRuleRest.assertNotNull((Object)ruleList.getRules());
        TestRuleRest.assertEquals((int)1, (int)ruleList.getRules().size());
        RuleRestEntity ruleRestEntity = (RuleRestEntity)ruleList.getRules().get(0);
        TestRuleRest.assertNotNull((Object)ruleRestEntity);
        TestRuleRest.assertEquals((Object)rule.getId(), (Object)ruleRestEntity.getId());
        UserInfoContext userInfo = (UserInfoContext)ruleRestEntity.getUserInfo();
        TestRuleRest.assertTrue((boolean)userInfo.isCanView());
        TestRuleRest.assertFalse((boolean)userInfo.isCanEdit());
        TestRuleRest.assertFalse((boolean)userInfo.isManager());
        TestRuleRest.assertFalse((boolean)userInfo.isMember());
        TestRuleRest.assertFalse((boolean)userInfo.isProgramOwner());
        TestRuleRest.assertFalse((boolean)userInfo.isRedactor());
        this.setRestrictedHubAccess();
        response = this.getResponse("GET", this.getURLResource("rules?offset=0&limit=10&returnSize=true"), null);
        TestRuleRest.assertNotNull((Object)response);
        TestRuleRest.assertEquals((int)401, (int)response.getStatus());
    }

    @Test
    public void testCreateAndDeleteRule() throws Exception {
        this.startSessionAs("root1");
        ProgramDTO domain = this.newProgram();
        Object restPath = GAMIFICATION_RULES_REST_PATH;
        StringWriter writer = new StringWriter();
        JSONWriter jsonWriter = new JSONWriter((Appendable)writer);
        jsonWriter.object().key("title").value((Object)"Rule").key("description").value((Object)"Rule description").key("startDate").value((Object)START_DATE).key("endDate").value((Object)END_DATE).key("points").value((Object)"10").key("program").object().key("id").value(domain.getId()).endObject().endObject();
        ContainerResponse response = this.getResponse("POST", (String)restPath, writer.getBuffer().toString());
        TestRuleRest.assertNotNull((Object)response);
        TestRuleRest.assertEquals((int)200, (int)response.getStatus());
        RuleRestEntity rule = (RuleRestEntity)response.getEntity();
        TestRuleRest.assertNotNull((Object)rule);
        this.startSessionAs("root2");
        restPath = "/gamification/rules/0";
        response = this.getResponse("DELETE", (String)restPath, null);
        TestRuleRest.assertNotNull((Object)response);
        TestRuleRest.assertEquals((int)400, (int)response.getStatus());
        restPath = "/gamification/rules/1100";
        response = this.getResponse("DELETE", (String)restPath, null);
        TestRuleRest.assertNotNull((Object)response);
        TestRuleRest.assertEquals((int)404, (int)response.getStatus());
        restPath = GAMIFICATION_RULES_REST_PATH + rule.getId();
        response = this.getResponse("DELETE", (String)restPath, null);
        TestRuleRest.assertNotNull((Object)response);
        TestRuleRest.assertEquals((int)401, (int)response.getStatus());
        this.startSessionAs("root1");
        response = this.getResponse("DELETE", (String)restPath, null);
        TestRuleRest.assertNotNull((Object)response);
        TestRuleRest.assertEquals((int)200, (int)response.getStatus());
    }

    @Test
    public void testGetAutomaticRuleById() throws Exception {
        ProgramEntity domainEntity = this.newDomain();
        RuleEntity ruleEntity = this.newRule("rule", domainEntity.getTitle(), true, EntityType.AUTOMATIC);
        String resourceURL = "rules/" + ruleEntity.getId();
        ContainerResponse response = this.getResponse("GET", this.getURLResource(resourceURL), null);
        TestRuleRest.assertEquals((int)401, (int)response.getStatus());
        this.startSessionAs("root0");
        response = this.getResponse("GET", this.getURLResource(resourceURL), null);
        TestRuleRest.assertEquals((int)401, (int)response.getStatus());
        this.startSessionAs("root1");
        response = this.getResponse("GET", this.getURLResource("rules/555"), null);
        TestRuleRest.assertEquals((int)404, (int)response.getStatus());
        response = this.getResponse("GET", this.getURLResource(resourceURL), null);
        TestRuleRest.assertEquals((int)200, (int)response.getStatus());
    }

    @Test
    public void testAddRule() throws Exception {
        ProgramDTO program = this.newProgram();
        JSONObject domainData = new JSONObject();
        domainData.put("id", program.getId());
        domainData.put("title", (Object)program.getTitle());
        JSONObject eventData = new JSONObject();
        eventData.put("title", (Object)"eventTitle");
        eventData.put("trigger", (Object)"eventTrigger");
        eventData.put("type", (Object)"eventType");
        JSONObject data = new JSONObject();
        data.put("title", (Object)"foo");
        data.put("description", (Object)"description");
        data.put("event", (Object)eventData);
        data.put("area", (Object)program.getTitle());
        data.put("type", (Object)"AUTOMATIC");
        data.put("program", (Object)domainData);
        data.put("enabled", (Object)"true");
        this.startSessionAs("root10");
        ContainerResponse response = this.getResponse("POST", this.getURLResource("rules"), data.toString());
        TestRuleRest.assertEquals((int)401, (int)response.getStatus());
        this.startSessionAs("root1");
        response = this.getResponse("POST", this.getURLResource("rules"), data.toString());
        TestRuleRest.assertEquals((int)200, (int)response.getStatus());
        RuleRestEntity rule = (RuleRestEntity)response.getEntity();
        TestRuleRest.assertEquals((String)"description", (String)rule.getDescription());
        TestRuleRest.assertEquals((String)"foo", (String)rule.getTitle());
        response = this.getResponse("POST", this.getURLResource("rules"), null);
        TestRuleRest.assertEquals((int)400, (int)response.getStatus());
    }

    @Test
    public void testDeleteRule() throws Exception {
        RuleEntity ruleEntity = this.newRule();
        this.startSessionAs("root10");
        ContainerResponse response = this.getResponse("DELETE", this.getURLResource("rules/" + ruleEntity.getId()), null);
        TestRuleRest.assertEquals((int)401, (int)response.getStatus());
        this.startSessionAs("root1");
        response = this.getResponse("DELETE", this.getURLResource("rules/-1"), null);
        TestRuleRest.assertEquals((int)400, (int)response.getStatus());
        response = this.getResponse("DELETE", this.getURLResource("rules/20000"), null);
        TestRuleRest.assertEquals((int)404, (int)response.getStatus());
        response = this.getResponse("DELETE", this.getURLResource("rules/" + ruleEntity.getId()), null);
        TestRuleRest.assertEquals((int)200, (int)response.getStatus());
    }

    @Test
    public void testUpdateAutomaticRule() throws Exception {
        RuleDTO ruleDTO = this.newRuleDTO();
        ProgramDTO program = this.newProgram();
        JSONObject domainData = new JSONObject();
        domainData.put("id", program.getId());
        domainData.put("title", (Object)program.getTitle());
        this.startSessionAs("root1");
        ContainerResponse response = this.getResponse("PUT", this.getURLResource("rules"), null);
        TestRuleRest.assertEquals((int)400, (int)response.getStatus());
        JSONObject data = new JSONObject();
        data.put("id", 0);
        data.put("title", (Object)ruleDTO.getTitle());
        data.put("description", (Object)(ruleDTO.getDescription() + "_test"));
        response = this.getResponse("PUT", this.getURLResource("rules"), data.toString());
        TestRuleRest.assertEquals((int)404, (int)response.getStatus());
        JSONObject eventData = new JSONObject();
        eventData.put("id", ruleDTO.getEvent().getId());
        eventData.put("title", (Object)ruleDTO.getEvent().getTitle());
        eventData.put("trigger", (Object)(ruleDTO.getEvent().getTrigger() + "_test"));
        eventData.put("type", (Object)ruleDTO.getEvent().getType());
        data = new JSONObject();
        data.put("id", (Object)ruleDTO.getId());
        data.put("title", (Object)ruleDTO.getTitle());
        data.put("description", (Object)(ruleDTO.getDescription() + "_test"));
        data.put("event", (Object)eventData);
        data.put("area", (Object)ruleDTO.getProgram().getTitle());
        data.put("type", (Object)ruleDTO.getType());
        data.put("program", (Object)domainData);
        data.put("createdDate", (Object)ruleDTO.getCreatedDate());
        response = this.getResponse("PUT", this.getURLResource("rules"), data.toString());
        TestRuleRest.assertEquals((int)200, (int)response.getStatus());
        RuleRestEntity rule = (RuleRestEntity)response.getEntity();
        TestRuleRest.assertEquals((String)"Description_test", (String)rule.getDescription());
        this.startSessionAs("root10");
        response = this.getResponse("PUT", this.getURLResource("rules"), data.toString());
        TestRuleRest.assertEquals((int)401, (int)response.getStatus());
    }
}

