/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.scheduled;

import io.meeds.gamification.entity.ProgramEntity;
import io.meeds.gamification.entity.RuleEntity;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.scheduled.ProgramAutoDisableJob;
import io.meeds.gamification.test.AbstractServiceTest;
import io.meeds.gamification.utils.Utils;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.Date;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.quartz.JobExecutionException;

public class ProgramAutoDisableJobTest
extends AbstractServiceTest {
    public void testDisablePrograms() throws JobExecutionException, ObjectNotFoundException {
        ProgramEntity domain1 = this.newDomain();
        RuleEntity rule1 = this.newRule("rule1", domain1.getId());
        rule1.setEndDate(Date.from(LocalDate.now().minusDays(1L).atStartOfDay().toInstant(ZoneOffset.UTC)));
        rule1 = (RuleEntity)this.ruleDAO.update((Object)rule1);
        ProgramAutoDisableJobTest.assertEquals((int)0, (int)this.ruleService.countActiveRules(domain1.getId().longValue()));
        ProgramEntity domain2 = this.newDomain();
        RuleEntity rule2 = this.newRule("rule2", domain2.getId());
        ProgramAutoDisableJobTest.assertEquals((int)1, (int)this.ruleService.countActiveRules(domain2.getId().longValue()));
        ProgramAutoDisableJob programAutoDisableJob = new ProgramAutoDisableJob();
        programAutoDisableJob.execute(null);
        ProgramAutoDisableJobTest.assertEquals((int)0, (int)this.ruleService.countActiveRules(domain1.getId().longValue()));
        ProgramAutoDisableJobTest.assertEquals((int)1, (int)this.ruleService.countActiveRules(domain2.getId().longValue()));
        domain1 = (ProgramEntity)this.programDAO.find((Serializable)domain1.getId());
        domain2 = (ProgramEntity)this.programDAO.find((Serializable)domain2.getId());
        ProgramAutoDisableJobTest.assertFalse((boolean)domain1.isEnabled());
        ProgramAutoDisableJobTest.assertTrue((boolean)domain2.isEnabled());
        RuleDTO ruleDto2 = this.ruleService.findRuleById(rule2.getId().longValue());
        ruleDto2.setEndDate(Utils.toSimpleDateFormat((Date)Date.from(LocalDate.now().minusDays(1L).atStartOfDay().toInstant(ZoneOffset.UTC))));
        this.ruleService.updateRule(ruleDto2);
        programAutoDisableJob.execute(null);
        ProgramAutoDisableJobTest.assertEquals((int)0, (int)this.ruleService.countActiveRules(domain1.getId().longValue()));
        ProgramAutoDisableJobTest.assertEquals((int)0, (int)this.ruleService.countActiveRules(domain2.getId().longValue()));
        domain1 = (ProgramEntity)this.programDAO.find((Serializable)domain1.getId());
        domain2 = (ProgramEntity)this.programDAO.find((Serializable)domain2.getId());
        ProgramAutoDisableJobTest.assertFalse((boolean)domain1.isEnabled());
        ProgramAutoDisableJobTest.assertFalse((boolean)domain2.isEnabled());
    }
}

