/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.utils;

import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.model.UserInfoContext;
import io.meeds.gamification.rest.builder.ProgramBuilder;
import io.meeds.gamification.service.ProgramService;
import io.meeds.gamification.test.AbstractServiceTest;
import io.meeds.gamification.utils.Utils;
import java.util.Date;
import java.util.TimeZone;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.junit.Test;

public class UtilsTest
extends AbstractServiceTest {
    @Test
    public void testToRFC3339Date() {
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        Date date = new Date(System.currentTimeMillis());
        date.setHours(15);
        UtilsTest.assertNull((Object)Utils.toRFC3339Date(null));
        int dateMonth = date.getMonth() + 1;
        int dateDay = date.getDate();
        int dateYear = date.getYear() + 1900;
        String rfc3339Date = Utils.toRFC3339Date((Date)date);
        UtilsTest.assertNotNull((Object)rfc3339Date);
        String fullDate = rfc3339Date.split("T")[0];
        String year = fullDate.split("-")[0];
        String month = fullDate.split("-")[1];
        String day = fullDate.split("-")[2];
        UtilsTest.assertEquals((int)Integer.parseInt(month), (int)dateMonth);
        UtilsTest.assertEquals((int)Integer.parseInt(day), (int)dateDay);
        UtilsTest.assertEquals((int)Integer.parseInt(year), (int)dateYear);
    }

    @Test
    public void testParseRFC3339Date() {
        String rfc3339Date = "2022-04-05T13:45:51.701Z";
        String fullDate = rfc3339Date.split("T")[0];
        String year = fullDate.split("-")[0];
        String month = fullDate.split("-")[1];
        String day = fullDate.split("-")[2];
        UtilsTest.assertNull((Object)Utils.parseRFC3339Date((String)""));
        Date date = Utils.parseRFC3339Date((String)rfc3339Date);
        UtilsTest.assertNotNull((Object)date);
        int dateMonth = date.getMonth() + 1;
        int dateDay = date.getDate();
        int dateYear = date.getYear() + 1900;
        UtilsTest.assertEquals((int)Integer.parseInt(month), (int)dateMonth);
        UtilsTest.assertEquals((int)Integer.parseInt(day), (int)dateDay);
        UtilsTest.assertEquals((int)Integer.parseInt(year), (int)dateYear);
    }

    @Test
    public void testToSimpleDateFormat() {
        Date date = new Date(System.currentTimeMillis());
        UtilsTest.assertNull((Object)Utils.toRFC3339Date(null));
        int dateMonth = date.getMonth() + 1;
        int dateDay = date.getDate();
        int dateYear = date.getYear() + 1900;
        String rfc3339Date = Utils.toSimpleDateFormat((Date)date);
        UtilsTest.assertNotNull((Object)rfc3339Date);
        String fullDate = rfc3339Date.split("T")[0];
        String year = fullDate.split("-")[0];
        String month = fullDate.split("-")[1];
        String day = fullDate.split("-")[2];
        UtilsTest.assertEquals((String)"00:00:00", (String)rfc3339Date.split("T")[1]);
        UtilsTest.assertEquals((int)Integer.parseInt(month), (int)dateMonth);
        UtilsTest.assertEquals((int)Integer.parseInt(day), (int)dateDay);
        UtilsTest.assertEquals((int)Integer.parseInt(year), (int)dateYear);
    }

    @Test
    public void testParseSimpleDate() {
        TimeZone.setDefault(TimeZone.getTimeZone("US/Hawaii"));
        String simpleDate = "2022-04-05T00:00:00";
        String fullDate = simpleDate.split("T")[0];
        String year = fullDate.split("-")[0];
        String month = fullDate.split("-")[1];
        String day = fullDate.split("-")[2];
        Date date = Utils.parseSimpleDate((String)simpleDate);
        UtilsTest.assertNull((Object)Utils.toRFC3339Date(null));
        int dateMonth = date.getMonth() + 1;
        int dateDay = date.getDate();
        int dateYear = date.getYear() + 1900;
        UtilsTest.assertEquals((String)"00:00:00", (String)simpleDate.split("T")[1]);
        UtilsTest.assertEquals((int)Integer.parseInt(month), (int)dateMonth);
        UtilsTest.assertEquals((int)Integer.parseInt(day), (int)dateDay);
        UtilsTest.assertEquals((int)Integer.parseInt(year), (int)dateYear);
    }

    @Test
    public void testEscapeIllegalCharacterInMessage() {
        String message = "testing escaping illegal characters such as , and ; and \n";
        UtilsTest.assertTrue((boolean)message.contains(","));
        UtilsTest.assertTrue((boolean)message.contains(";"));
        UtilsTest.assertTrue((boolean)message.contains("\n"));
        UtilsTest.assertNull((Object)Utils.escapeIllegalCharacterInMessage(null));
        message = Utils.escapeIllegalCharacterInMessage((String)message);
        UtilsTest.assertNotNull((Object)message);
        UtilsTest.assertFalse((boolean)message.contains(","));
        UtilsTest.assertFalse((boolean)message.contains(";"));
        UtilsTest.assertFalse((boolean)message.contains("\n"));
    }

    @Test
    public void testGetCurrentUser() {
        ConversationState.setCurrent(null);
        String currentUser = Utils.getCurrentUser();
        UtilsTest.assertNull((Object)currentUser);
        ConversationState.setCurrent((ConversationState)new ConversationState(new org.exoplatform.services.security.Identity("root")));
        currentUser = Utils.getCurrentUser();
        UtilsTest.assertNotNull((Object)currentUser);
        UtilsTest.assertEquals((String)"root", (String)currentUser);
    }

    @Test
    public void testGetSpaceFromObjectId() {
        String objectId = "/portal/g/:spaces:space150";
        String spaceDisplayName = Utils.getSpaceFromObjectID((String)"test");
        UtilsTest.assertNull((Object)spaceDisplayName);
        spaceDisplayName = Utils.getSpaceFromObjectID((String)"");
        UtilsTest.assertNull((Object)spaceDisplayName);
        spaceDisplayName = Utils.getSpaceFromObjectID((String)objectId);
        UtilsTest.assertNotNull((Object)spaceDisplayName);
        UtilsTest.assertEquals((String)"test space", (String)spaceDisplayName);
    }

    @Test
    public void testCreateUser() {
        RuleDTO rule = this.newRuleDTO();
        Identity identity = this.identityManager.getOrCreateUserIdentity("root1");
        UserInfoContext userContext = ProgramBuilder.toUserContext((ProgramService)this.programService, (ProgramDTO)rule.getProgram(), (String)identity.getRemoteId());
        UtilsTest.assertNotNull((Object)userContext);
        UtilsTest.assertEquals((String)"root1", (String)userContext.getRemoteId());
        UtilsTest.assertFalse((boolean)userContext.isAllowedToRealize());
    }

    @Test
    public void testGetIdentityByTypeAndId() {
        Identity identity = Utils.getIdentityByTypeAndId((String)"organization", (String)"root1");
        UtilsTest.assertNotNull((Object)identity);
    }

    @Test
    public void testGetUserRemoteId() {
        String remoteId = Utils.getUserRemoteId((String)"15893");
        UtilsTest.assertNull((Object)remoteId);
        remoteId = Utils.getUserRemoteId((String)"1");
        UtilsTest.assertNotNull((Object)remoteId);
    }

    @Test
    public void testGetSpaceById() {
        Space space = new Space();
        space.setId("1");
        space.setPrettyName("space150");
        space.setDisplayName("test space");
        space.setGroupId("/spaces/space150");
        Space savedSpace = Utils.getSpaceById((String)"");
        UtilsTest.assertNull((Object)savedSpace);
        savedSpace = Utils.getSpaceById((String)"2");
        UtilsTest.assertNull((Object)savedSpace);
        savedSpace = Utils.getSpaceById((String)"1");
        UtilsTest.assertNotNull((Object)savedSpace);
        UtilsTest.assertEquals((String)space.getId(), (String)savedSpace.getId());
    }

    @Test
    public void testBuildAttachmentUrl() {
        Long lastModifiedDate = System.currentTimeMillis();
        String attachementURl = Utils.buildAttachmentUrl((String)"0", (Long)lastModifiedDate, (String)"cover", (String)"default-cover", (boolean)false);
        UtilsTest.assertNull((Object)attachementURl);
        attachementURl = Utils.buildAttachmentUrl((String)"1", (Long)0L, (String)"cover", (String)"default-cover", (boolean)true);
        UtilsTest.assertNotNull((Object)attachementURl);
        UtilsTest.assertTrue((boolean)attachementURl.contains("default-cover"));
        attachementURl = Utils.buildAttachmentUrl((String)"1", (Long)lastModifiedDate, (String)"cover", (String)"default-cover", (boolean)false);
        UtilsTest.assertNotNull((Object)attachementURl);
        UtilsTest.assertFalse((boolean)attachementURl.contains("default-cover"));
    }

    @Test
    public void testIsAttachmentTokenValid() {
        long lastModifiedTime = System.currentTimeMillis();
        String domainId = "1";
        String token = Utils.generateAttachmentToken((String)domainId, (String)"cover", (Long)lastModifiedTime);
        UtilsTest.assertTrue((boolean)Utils.isAttachmentTokenValid((String)token, (String)domainId, (String)"cover", (Long)lastModifiedTime));
        UtilsTest.assertFalse((boolean)Utils.isAttachmentTokenValid((String)"", (String)domainId, (String)"cover", (Long)lastModifiedTime));
    }
}

