/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.rest;

import io.meeds.gamification.entity.BadgeEntity;
import io.meeds.gamification.model.BadgeDTO;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.rest.BadgeRest;
import io.meeds.gamification.test.AbstractServiceTest;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.json.JSONObject;
import org.junit.Before;
import org.junit.Test;

public class TestBadgeRest
extends AbstractServiceTest {
    protected Class<?> getComponentClass() {
        return BadgeRest.class;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.startSessionAs("root1");
        this.registry(this.getComponentClass());
    }

    @Test
    public void testGetAllBadges() throws Exception {
        ContainerResponse response = this.getResponse("GET", this.getURLResource("badges/all"), null);
        TestBadgeRest.assertNotNull((Object)response);
        TestBadgeRest.assertEquals((int)200, (int)response.getStatus());
    }

    @Test
    public void testAddBadge() throws Exception {
        ProgramDTO program = this.newProgram();
        JSONObject programData = new JSONObject();
        programData.put("id", program.getId());
        programData.put("title", (Object)program.getTitle());
        JSONObject data = new JSONObject();
        data.put("title", (Object)"foo");
        data.put("description", (Object)"description");
        data.put("program", (Object)programData);
        ContainerResponse response = this.getResponse("POST", this.getURLResource("badges/add"), data.toString());
        TestBadgeRest.assertNotNull((Object)response);
        TestBadgeRest.assertEquals((int)200, (int)response.getStatus());
        BadgeDTO entity = (BadgeDTO)response.getEntity();
        TestBadgeRest.assertEquals((String)"foo", (String)entity.getTitle());
        TestBadgeRest.assertEquals((String)"description", (String)entity.getDescription());
        TestBadgeRest.assertEquals((String)"TeamWork", (String)entity.getProgram().getTitle());
    }

    @Test
    public void testDeleteBadge() throws Exception {
        BadgeEntity badgeEntity = this.newBadge(1L);
        ContainerResponse response = this.getResponse("DELETE", this.getURLResource("badges/delete/" + badgeEntity.getId()), null);
        TestBadgeRest.assertNotNull((Object)response);
        TestBadgeRest.assertEquals((int)200, (int)response.getStatus());
    }

    @Test
    public void testUpdateBadge() throws Exception {
        BadgeEntity badgeEntity = this.newBadge(1L);
        ProgramDTO program = this.newProgram();
        JSONObject domainData = new JSONObject();
        domainData.put("id", program.getId());
        domainData.put("title", (Object)program.getTitle());
        JSONObject data = new JSONObject();
        data.put("id", (Object)badgeEntity.getId());
        data.put("title", (Object)badgeEntity.getTitle());
        data.put("description", (Object)(badgeEntity.getDescription() + "_test"));
        data.put("program", (Object)domainData);
        ContainerResponse response = this.getResponse("PUT", this.getURLResource("badges/update"), data.toString());
        TestBadgeRest.assertNotNull((Object)response);
        TestBadgeRest.assertEquals((int)200, (int)response.getStatus());
        BadgeDTO entity = (BadgeDTO)response.getEntity();
        TestBadgeRest.assertEquals((String)entity.getDescription(), (String)"Description_test");
    }
}

