/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.controller;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.exoplatform.services.log.Log;
import org.gatein.pc.api.info.PortletInfo;
import org.gatein.pc.controller.ControllerContext;
import org.gatein.pc.controller.EventControllerContextSafeInvoker;
import org.gatein.pc.controller.PortletController;
import org.gatein.pc.controller.event.WindowEvent;

public class EventPhaseContext
implements Iterator<WindowEvent> {
    private static final EventControllerContextSafeInvoker safeInvoker = new EventControllerContextSafeInvoker();
    private final Log log;
    LinkedList<WindowEvent> toConsumeEvents;
    int consumedEventSize;
    private int producedEventSize;
    final PortletController controller;
    final ControllerContext context;
    private WindowEvent next = null;

    EventPhaseContext(PortletController controller, ControllerContext context, Log log) {
        this.controller = controller;
        this.context = context;
        this.log = log;
        this.toConsumeEvents = new LinkedList();
        this.consumedEventSize = 0;
        this.producedEventSize = 0;
    }

    boolean push(WindowEvent producedEvent) {
        return this.push(null, producedEvent);
    }

    boolean push(WindowEvent consumedEvent, WindowEvent producedEvent) {
        String producerId = producedEvent.getWindowId();
        PortletInfo producerPortletInfo = this.context.getPortletInfo(producerId);
        if (producerPortletInfo == null) {
            this.log.trace((Object)("Cannot deliver event " + String.valueOf(producedEvent) + " because the producer does not have portlet info"));
            safeInvoker.eventDiscarded(this.context.getEventControllerContext(), this, producedEvent, 1);
            return true;
        }
        if (!this.controller.getDistributeNonProduceableEvents() && !producerPortletInfo.getEventing().getProducedEvents().containsKey(producedEvent.getName())) {
            this.log.trace((Object)("Cannot deliver event " + String.valueOf(producedEvent) + " because the producer of the event does not produce the event name"));
            safeInvoker.eventDiscarded(this.context.getEventControllerContext(), this, producedEvent, 4);
            return true;
        }
        int producedEventThreshold = this.controller.getProducedEventThreshold();
        if (producedEventThreshold >= 0 && this.producedEventSize + 1 > producedEventThreshold) {
            this.log.trace((Object)"Event distribution interrupted because the maximum number of produced event is reached");
            safeInvoker.eventDiscarded(this.context.getEventControllerContext(), this, producedEvent, 6);
            return false;
        }
        Iterable<WindowEvent> toConsume = safeInvoker.eventProduced(this.context.getEventControllerContext(), this, consumedEvent, producedEvent);
        if (toConsume == null) {
            return false;
        }
        ++this.producedEventSize;
        for (WindowEvent event : toConsume) {
            this.toConsumeEvents.add(event);
        }
        return true;
    }

    @Override
    public boolean hasNext() {
        while (this.next == null && this.toConsumeEvents.size() > 0) {
            WindowEvent toConsumeEvent = this.toConsumeEvents.removeFirst();
            String consumedId = toConsumeEvent.getWindowId();
            PortletInfo consumerPortletInfo = this.context.getPortletInfo(consumedId);
            if (consumerPortletInfo == null) {
                this.log.trace((Object)("Cannot deliver event " + String.valueOf(toConsumeEvent) + " because the consumer of the event does not have a portlet info"));
                safeInvoker.eventDiscarded(this.context.getEventControllerContext(), this, toConsumeEvent, 3);
                continue;
            }
            if (!this.controller.getDistributeNonConsumableEvents() && !consumerPortletInfo.getEventing().getConsumedEvents().containsKey(toConsumeEvent.getName())) {
                this.log.trace((Object)("Cannot deliver event " + String.valueOf(toConsumeEvent) + " because the consumer of the event does not accept the event name"));
                safeInvoker.eventDiscarded(this.context.getEventControllerContext(), this, toConsumeEvent, 4);
                continue;
            }
            this.next = toConsumeEvent;
        }
        return this.next != null;
    }

    @Override
    public WindowEvent next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        WindowEvent tmp = this.next;
        this.next = null;
        return tmp;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

